/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.placeholder;

import java.util.List;
import java.util.stream.Stream;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.sabafly.emeraldbank.EmeraldBank;
import net.sabafly.emeraldbank.bank.User;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmeraldBankPlaceholderExpansion
extends PlaceholderExpansion {
    private final EmeraldBank plugin;

    public EmeraldBankPlaceholderExpansion(EmeraldBank plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "emeraldbank";
    }

    @NotNull
    public String getAuthor() {
        return "ikafly144";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getPluginMeta().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @NotNull
    public List<String> getPlaceholders() {
        return Stream.of("balance", "balance_<player>", "wallet", "wallet_<player>", "bank_balance_<bank>", "bank_owner_<bank>", "bank_members_<bank>", "bank_list").map(s -> "%" + this.getIdentifier() + "_" + s + "%").toList();
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        try {
            if (params.startsWith("balance_")) {
                OfflinePlayer offlinePlayer = this.plugin.getServer().getOfflinePlayer(params.substring(8));
                return EmeraldBank.economy().format(EmeraldBank.economy().getBalance(offlinePlayer));
            }
            if (params.startsWith("wallet_")) {
                OfflinePlayer offlinePlayer = this.plugin.getServer().getOfflinePlayer(params.substring(7));
                return EmeraldBank.economy().format(EmeraldBank.database().getUser(offlinePlayer.getUniqueId()).wallet());
            }
            try {
                if (params.startsWith("bank_balance_")) {
                    String bankName = params.substring(13);
                    return EmeraldBank.economy().format(EmeraldBank.economy().bankBalance((String)bankName).balance);
                }
                if (params.startsWith("bank_owner_")) {
                    String bankName = params.substring(11);
                    List<User> members = EmeraldBank.database().getOwners(bankName);
                    return members.isEmpty() ? "" : String.join((CharSequence)", ", members.stream().map(User::getName).toList());
                }
                if (params.startsWith("bank_members_")) {
                    String bankName = params.substring(13);
                    List<User> members = EmeraldBank.database().getMembers(bankName);
                    return members.isEmpty() ? "" : String.join((CharSequence)", ", members.stream().map(User::getName).toList());
                }
                if (params.startsWith("bank_list")) {
                    List<String> banks = EmeraldBank.economy().getBanks();
                    return String.join((CharSequence)", ", banks);
                }
            }
            catch (Exception e) {
                return "";
            }
            if (player == null) {
                return null;
            }
            if (params.equals("balance")) {
                return EmeraldBank.economy().format(EmeraldBank.economy().getBalance(player));
            }
            if (params.equals("wallet")) {
                return EmeraldBank.economy().format(EmeraldBank.database().getUser(player.getUniqueId()).wallet());
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String onPlaceholderRequest(Player player, @NotNull String params) {
        return this.onRequest((OfflinePlayer)player, params);
    }
}

