/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.util;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.TagPattern;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.sabafly.emeraldbank.EmeraldBank;
import net.sabafly.emeraldbank.configuration.Settings;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class EmeraldUtils {
    public static Settings.Messages getMessages() {
        return EmeraldBank.config().messages;
    }

    public static boolean depositPlayer(OfflinePlayer account, double amount) {
        return EmeraldBank.economy().depositPlayer(account, amount).transactionSuccess();
    }

    public static boolean withdrawPlayer(Player account, double amount) {
        return EmeraldBank.economy().withdrawPlayer((OfflinePlayer)account, amount).transactionSuccess();
    }

    public static boolean payPlayer(Player from, OfflinePlayer to, double amount, int cost) {
        return EmeraldUtils.withdrawPlayer(from, amount) && EmeraldUtils.depositPlayer(to, amount - (double)cost);
    }

    public static Message serializeBrigadierMessage(String message, TagResolver ... resolvers) {
        return (Message)MessageComponentSerializer.message().serialize(MiniMessage.miniMessage().deserialize(message, resolvers));
    }

    public static CommandSyntaxException createCommandException(String message, TagResolver ... resolvers) {
        return new SimpleCommandExceptionType(EmeraldUtils.serializeBrigadierMessage(message, resolvers)).create();
    }

    public static TagResolver tagResolver(@TagPattern @NotNull String name, Component value) {
        return TagResolver.builder().tag(name, Tag.inserting((Component)value)).build();
    }

    public static TagResolver tagResolver(@TagPattern @NotNull String name, ComponentLike value) {
        return TagResolver.builder().tag(name, Tag.inserting((ComponentLike)value)).build();
    }

    @Deprecated
    @NotNull
    public static World getWorld() {
        return Objects.requireNonNull(EmeraldBank.getInstance().getServer().getWorld(NamespacedKey.minecraft((String)"overworld")));
    }

    @NotNull
    public static TextComponent formatCurrency(double balance) {
        return Component.text((String)EmeraldBank.economy().format(balance));
    }
}

