/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.util;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashMap;
import java.util.Map;
import net.sabafly.emeraldbank.configuration.Settings;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;

public class PlayerInventoryUtils {
    private PlayerInventoryUtils() {
    }

    public static int getCurrencyAmount(Player player, Settings.Currency currency) {
        int amount = PlayerInventoryUtils.getCurrencyCount(player, currency);
        return (int)Math.floor((double)amount * currency.rate);
    }

    public static int getCurrencyCount(Player player, Settings.Currency currency) {
        int amount = 0;
        amount += player.getInventory().all(((ItemType)RegistryAccess.registryAccess().getRegistry(RegistryKey.ITEM).getOrThrow(currency.itemType)).createItemStack().getType()).values().stream().mapToInt(ItemStack::getAmount).sum();
        for (Map.Entry<NamespacedKey, Integer> child : currency.children.entrySet()) {
            amount += player.getInventory().all(((ItemType)RegistryAccess.registryAccess().getRegistry(RegistryKey.ITEM).getOrThrow(child.getKey())).createItemStack().getType()).values().stream().mapToInt(ItemStack::getAmount).map(v -> v * (Integer)child.getValue()).sum();
        }
        return amount;
    }

    private static int removeCurrency0(Player player, Settings.Currency currency, int count) {
        if (count <= 0) {
            return 0;
        }
        int remain = count;
        for (Map.Entry<NamespacedKey, Integer> child : currency.children.entrySet()) {
            int childAmount = (int)Math.ceil((double)remain / (double)child.getValue().intValue());
            if ((remain -= PlayerInventoryUtils.removeCurrency1(player, (ItemType)RegistryAccess.registryAccess().getRegistry(RegistryKey.ITEM).getOrThrow(child.getKey()), childAmount) * child.getValue()) > 0) continue;
            return count + PlayerInventoryUtils.addCurrency(player, currency, -remain);
        }
        if ((remain -= PlayerInventoryUtils.removeCurrency1(player, (ItemType)RegistryAccess.registryAccess().getRegistry(RegistryKey.ITEM).getOrThrow(currency.itemType), remain)) < 0) {
            return count + PlayerInventoryUtils.addCurrency(player, currency, -remain);
        }
        return count - remain;
    }

    private static int removeCurrency1(Player player, ItemType type, int count) {
        int remain = count;
        for (ItemStack item : player.getInventory().all(type.createItemStack().getType()).values()) {
            if (item.getAmount() > remain) {
                item.setAmount(item.getAmount() - remain);
                return count;
            }
            remain -= item.getAmount();
            item.setAmount(0);
        }
        return count - remain;
    }

    public static boolean removeCurrency(Player player, Settings.Currency currency, int count) {
        if (PlayerInventoryUtils.getCurrencyAmount(player, currency) < count) {
            return false;
        }
        int removed = PlayerInventoryUtils.removeCurrency0(player, currency, count);
        Preconditions.checkArgument((removed == count ? 1 : 0) != 0, (Object)("Removed " + removed + " items, but expected " + count));
        return true;
    }

    private static int addCurrency1(Player player, ItemType type, int count) {
        int remain = count;
        for (ItemStack item : player.getInventory().all(type.createItemStack().getType()).values()) {
            if (item.getAmount() + remain <= item.getMaxStackSize()) {
                item.setAmount(item.getAmount() + remain);
                return 0;
            }
            remain -= item.getMaxStackSize() - item.getAmount();
            item.setAmount(item.getMaxStackSize());
        }
        if (remain > 0) {
            HashMap map = player.getInventory().addItem(new ItemStack[]{type.createItemStack(remain)});
            remain = map.values().stream().mapToInt(ItemStack::getAmount).sum();
        }
        return remain;
    }

    private static int addCurrency0(Player player, Settings.Currency currency, int count) {
        int remain = count;
        for (Map.Entry<NamespacedKey, Integer> child : currency.children.entrySet()) {
            int childAmount = remain / child.getValue();
            remain -= childAmount * child.getValue();
            if (childAmount > 0) {
                remain += PlayerInventoryUtils.addCurrency1(player, (ItemType)RegistryAccess.registryAccess().getRegistry(RegistryKey.ITEM).getOrThrow(child.getKey()), childAmount) * child.getValue();
            }
            if (remain > 0) continue;
            return 0;
        }
        return PlayerInventoryUtils.addCurrency1(player, (ItemType)RegistryAccess.registryAccess().getRegistry(RegistryKey.ITEM).getOrThrow(currency.itemType), remain);
    }

    public static int addCurrency(Player player, Settings.Currency currency, int count) {
        if (count <= 0) {
            return 0;
        }
        return PlayerInventoryUtils.addCurrency0(player, currency, count);
    }

    public static void addCurrencyItem(Player player, Settings.Currency target, int count) {
        int remain = PlayerInventoryUtils.addCurrency(player, target, count);
        if (remain > 0) {
            ItemStack itemStack = ((ItemType)RegistryAccess.registryAccess().getRegistry(RegistryKey.ITEM).getOrThrow(target.itemType)).createItemStack(remain);
            HashMap map = player.getInventory().addItem(new ItemStack[]{itemStack});
            remain = map.values().stream().mapToInt(ItemStack::getAmount).sum();
            if (remain > 0) {
                player.getWorld().dropItem(player.getLocation(), itemStack);
            }
        }
    }
}

