/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.libs.org.apache.commons.dbutils;

import java.sql.CallableStatement;
import java.sql.SQLException;

public class OutParameter<T> {
    private final int sqlType;
    private final Class<T> javaType;
    private T value = null;

    public OutParameter(int sqlType, Class<T> javaType) {
        this.sqlType = sqlType;
        this.javaType = javaType;
    }

    public OutParameter(int sqlType, Class<T> javaType, T value) {
        this.sqlType = sqlType;
        this.javaType = javaType;
        this.value = value;
    }

    public Class<T> getJavaType() {
        return this.javaType;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public T getValue() {
        return this.value;
    }

    void register(CallableStatement stmt, int index) throws SQLException {
        stmt.registerOutParameter(index, this.sqlType);
        if (this.value != null) {
            stmt.setObject(index, this.value);
        }
    }

    void setValue(CallableStatement stmt, int index) throws SQLException {
        this.value = this.javaType.cast(stmt.getObject(index));
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String toString() {
        return "OutParameter{sqlType=" + this.sqlType + ", javaType=" + this.javaType + ", value=" + this.value + '}';
    }
}

