/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.libs.org.apache.commons.dbutils;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import net.sabafly.libs.org.apache.commons.dbutils.AbstractQueryRunner;
import net.sabafly.libs.org.apache.commons.dbutils.OutParameter;
import net.sabafly.libs.org.apache.commons.dbutils.ResultSetHandler;
import net.sabafly.libs.org.apache.commons.dbutils.StatementConfiguration;

public class QueryRunner
extends AbstractQueryRunner {
    public QueryRunner() {
    }

    public QueryRunner(boolean pmdKnownBroken) {
        super(pmdKnownBroken);
    }

    public QueryRunner(DataSource ds) {
        super(ds);
    }

    public QueryRunner(DataSource ds, boolean pmdKnownBroken) {
        super(ds, pmdKnownBroken);
    }

    public QueryRunner(DataSource ds, boolean pmdKnownBroken, StatementConfiguration stmtConfig) {
        super(ds, pmdKnownBroken, stmtConfig);
    }

    public QueryRunner(DataSource ds, StatementConfiguration stmtConfig) {
        super(ds, stmtConfig);
    }

    public QueryRunner(StatementConfiguration stmtConfig) {
        super(stmtConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batch(Connection conn, String sql, Object[][] params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            throw new SQLException("Null SQL statement");
        }
        if (params == null) {
            throw new SQLException("Null parameters. If parameters aren't need, pass an empty array.");
        }
        PreparedStatement stmt = null;
        ParameterMetaData pmd = null;
        int[] rows = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            pmd = this.getParameterMetaData(stmt);
            for (Object[] param : params) {
                this.fillStatement(stmt, pmd, param);
                stmt.addBatch();
            }
            rows = stmt.executeBatch();
        }
        catch (SQLException e) {
            this.rethrow(e, sql, (Object[])params);
        }
        finally {
            this.close(stmt);
        }
        return rows;
    }

    public int[] batch(String sql, Object[][] params) throws SQLException {
        try (Connection conn = this.prepareConnection();){
            int[] nArray = this.batch(conn, sql, params);
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Connection conn, String sql, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            throw new SQLException("Null SQL statement");
        }
        CallableStatement stmt = null;
        int rows = 0;
        try {
            stmt = this.prepareCall(conn, sql);
            this.fillStatement((PreparedStatement)stmt, params);
            stmt.execute();
            rows = stmt.getUpdateCount();
            this.retrieveOutParameters(stmt, params);
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
        }
        finally {
            this.close(stmt);
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> execute(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            throw new SQLException("Null SQL statement");
        }
        if (rsh == null) {
            throw new SQLException("Null ResultSetHandler");
        }
        CallableStatement stmt = null;
        LinkedList<T> results = new LinkedList<T>();
        try {
            stmt = this.prepareCall(conn, sql);
            this.fillStatement((PreparedStatement)stmt, params);
            boolean moreResultSets = stmt.execute();
            while (moreResultSets) {
                ResultSet resultSet = this.wrap(stmt.getResultSet());
                try {
                    results.add(rsh.handle(resultSet));
                    moreResultSets = stmt.getMoreResults();
                }
                finally {
                    if (resultSet == null) continue;
                    resultSet.close();
                }
            }
            this.retrieveOutParameters(stmt, params);
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
        }
        finally {
            this.close(stmt);
        }
        return results;
    }

    public int execute(String sql, Object ... params) throws SQLException {
        try (Connection conn = this.prepareConnection();){
            int n = this.execute(conn, sql, params);
            return n;
        }
    }

    public <T> List<T> execute(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        try (Connection conn = this.prepareConnection();){
            List<T> list = this.execute(conn, sql, rsh, params);
            return list;
        }
    }

    public <T> T insert(Connection conn, String sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.insert(conn, sql, rsh, (Object[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T insert(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            throw new SQLException("Null SQL statement");
        }
        if (rsh == null) {
            throw new SQLException("Null ResultSetHandler");
        }
        Statement stmt = null;
        T generatedKeys = null;
        try {
            if (params != null && params.length > 0) {
                PreparedStatement ps = conn.prepareStatement(sql, 1);
                stmt = ps;
                this.fillStatement(ps, params);
                ps.executeUpdate();
            } else {
                stmt = conn.createStatement();
                stmt.executeUpdate(sql, 1);
            }
            try (ResultSet resultSet = stmt.getGeneratedKeys();){
                generatedKeys = rsh.handle(resultSet);
            }
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
        }
        finally {
            this.close(stmt);
        }
        return generatedKeys;
    }

    public <T> T insert(String sql, ResultSetHandler<T> rsh) throws SQLException {
        try (Connection conn = this.prepareConnection();){
            T t = this.insert(conn, sql, rsh, (Object[])null);
            return t;
        }
    }

    public <T> T insert(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        try (Connection conn = this.prepareConnection();){
            T t = this.insert(conn, sql, rsh, params);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T insertBatch(Connection conn, String sql, ResultSetHandler<T> rsh, Object[][] params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            throw new SQLException("Null SQL statement");
        }
        if (params == null) {
            throw new SQLException("Null parameters. If parameters aren't need, pass an empty array.");
        }
        PreparedStatement stmt = null;
        T generatedKeys = null;
        try {
            stmt = this.prepareStatement(conn, sql, 1);
            for (Object[] param : params) {
                this.fillStatement(stmt, param);
                stmt.addBatch();
            }
            stmt.executeBatch();
            try (ResultSet resultSet = stmt.getGeneratedKeys();){
                generatedKeys = rsh.handle(resultSet);
            }
        }
        catch (SQLException e) {
            try {
                this.rethrow(e, sql, (Object[])params);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                throw throwable;
            }
            this.close(stmt);
        }
        this.close(stmt);
        return generatedKeys;
    }

    public <T> T insertBatch(String sql, ResultSetHandler<T> rsh, Object[][] params) throws SQLException {
        try (Connection conn = this.prepareConnection();){
            T t = this.insertBatch(conn, sql, rsh, params);
            return t;
        }
    }

    @Deprecated
    public <T> T query(Connection conn, String sql, Object param, ResultSetHandler<T> rsh) throws SQLException {
        return this.query(conn, sql, rsh, param);
    }

    @Deprecated
    public <T> T query(Connection conn, String sql, Object[] params, ResultSetHandler<T> rsh) throws SQLException {
        return this.query(conn, sql, rsh, params);
    }

    public <T> T query(Connection conn, String sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.query(conn, sql, rsh, (Object[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T query(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            throw new SQLException("Null SQL statement");
        }
        if (rsh == null) {
            throw new SQLException("Null ResultSetHandler");
        }
        Statement stmt = null;
        ResultSet resultSet = null;
        T result = null;
        try {
            if (params != null && params.length > 0) {
                PreparedStatement ps = this.prepareStatement(conn, sql);
                stmt = ps;
                this.fillStatement(ps, params);
                resultSet = this.wrap(ps.executeQuery());
            } else {
                stmt = conn.createStatement();
                resultSet = this.wrap(stmt.executeQuery(sql));
            }
            result = rsh.handle(resultSet);
        }
        catch (SQLException e) {
            try {
                this.rethrow(e, sql, params);
            }
            catch (Throwable throwable) {
                this.closeQuietly(resultSet);
                this.closeQuietly(stmt);
                throw throwable;
            }
            this.closeQuietly(resultSet);
            this.closeQuietly(stmt);
        }
        this.closeQuietly(resultSet);
        this.closeQuietly(stmt);
        return result;
    }

    @Deprecated
    public <T> T query(String sql, Object param, ResultSetHandler<T> rsh) throws SQLException {
        try (Connection conn = this.prepareConnection();){
            T t = this.query(conn, sql, rsh, param);
            return t;
        }
    }

    @Deprecated
    public <T> T query(String sql, Object[] params, ResultSetHandler<T> rsh) throws SQLException {
        try (Connection conn = this.prepareConnection();){
            T t = this.query(conn, sql, rsh, params);
            return t;
        }
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh) throws SQLException {
        try (Connection conn = this.prepareConnection();){
            T t = this.query(conn, sql, rsh, (Object[])null);
            return t;
        }
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        try (Connection conn = this.prepareConnection();){
            T t = this.query(conn, sql, rsh, params);
            return t;
        }
    }

    private void retrieveOutParameters(CallableStatement stmt, Object[] params) throws SQLException {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof OutParameter)) continue;
                ((OutParameter)params[i]).setValue(stmt, i + 1);
            }
        }
    }

    public int update(Connection conn, String sql) throws SQLException {
        return this.update(conn, sql, (Object[])null);
    }

    public int update(Connection conn, String sql, Object param) throws SQLException {
        return this.update(conn, sql, new Object[]{param});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection conn, String sql, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            throw new SQLException("Null SQL statement");
        }
        Statement stmt = null;
        int rows = 0;
        try {
            if (params != null && params.length > 0) {
                PreparedStatement ps = this.prepareStatement(conn, sql);
                stmt = ps;
                this.fillStatement(ps, params);
                rows = ps.executeUpdate();
            } else {
                stmt = conn.createStatement();
                rows = stmt.executeUpdate(sql);
            }
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
        }
        finally {
            this.close(stmt);
        }
        return rows;
    }

    public int update(String sql) throws SQLException {
        try (Connection conn = this.prepareConnection();){
            int n = this.update(conn, sql, (Object[])null);
            return n;
        }
    }

    public int update(String sql, Object param) throws SQLException {
        try (Connection conn = this.prepareConnection();){
            int n = this.update(conn, sql, param);
            return n;
        }
    }

    public int update(String sql, Object ... params) throws SQLException {
        try (Connection conn = this.prepareConnection();){
            int n = this.update(conn, sql, params);
            return n;
        }
    }
}

