/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.libs.org.apache.commons.dbutils;

import java.time.Duration;

public class StatementConfiguration {
    private final Integer fetchDirection;
    private final Integer fetchSize;
    private final Integer maxFieldSize;
    private final Integer maxRows;
    private final Duration queryTimeout;

    public StatementConfiguration(Integer fetchDirection, Integer fetchSize, Integer maxFieldSize, Integer maxRows, Duration queryTimeout) {
        this.fetchDirection = fetchDirection;
        this.fetchSize = fetchSize;
        this.maxFieldSize = maxFieldSize;
        this.maxRows = maxRows;
        if (queryTimeout != null && queryTimeout.getSeconds() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("queryTimeout overflow: %d > %,d", queryTimeout.getSeconds(), Integer.MAX_VALUE));
        }
        this.queryTimeout = queryTimeout;
    }

    @Deprecated
    public StatementConfiguration(Integer fetchDirection, Integer fetchSize, Integer maxFieldSize, Integer maxRows, Integer queryTimeout) {
        this(fetchDirection, fetchSize, maxFieldSize, maxRows, Duration.ofSeconds(queryTimeout.intValue()));
    }

    public Integer getFetchDirection() {
        return this.fetchDirection;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public Integer getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    @Deprecated
    public Integer getQueryTimeout() {
        return this.queryTimeout != null ? Integer.valueOf((int)this.queryTimeout.getSeconds()) : null;
    }

    public Duration getQueryTimeoutDuration() {
        return this.queryTimeout;
    }

    public boolean isFetchDirectionSet() {
        return this.fetchDirection != null;
    }

    public boolean isFetchSizeSet() {
        return this.fetchSize != null;
    }

    public boolean isMaxFieldSizeSet() {
        return this.maxFieldSize != null;
    }

    public boolean isMaxRowsSet() {
        return this.maxRows != null;
    }

    public boolean isQueryTimeoutSet() {
        return this.queryTimeout != null;
    }

    public static final class Builder {
        private Integer fetchDirection;
        private Integer fetchSize;
        private Integer maxRows;
        private Duration queryTimeout;
        private Integer maxFieldSize;

        public StatementConfiguration build() {
            return new StatementConfiguration(this.fetchDirection, this.fetchSize, this.maxFieldSize, this.maxRows, this.queryTimeout);
        }

        public Builder fetchDirection(Integer fetchDirection) {
            this.fetchDirection = fetchDirection;
            return this;
        }

        public Builder fetchSize(Integer fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder maxFieldSize(Integer maxFieldSize) {
            this.maxFieldSize = maxFieldSize;
            return this;
        }

        public Builder maxRows(Integer maxRows) {
            this.maxRows = maxRows;
            return this;
        }

        public Builder queryTimeout(Duration queryTimeout) {
            this.queryTimeout = queryTimeout;
            return this;
        }

        @Deprecated
        public Builder queryTimeout(Integer queryTimeout) {
            this.queryTimeout = queryTimeout != null ? Duration.ofSeconds(queryTimeout.intValue()) : null;
            return this;
        }
    }
}

