/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.gui.BiomeSearchEntry;
import com.chaosthedude.naturescompass.gui.BiomeSearchList;
import com.chaosthedude.naturescompass.gui.TransparentButton;
import com.chaosthedude.naturescompass.gui.TransparentTextField;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.network.SearchPacket;
import com.chaosthedude.naturescompass.network.TeleportPacket;
import com.chaosthedude.naturescompass.sorting.ISorting;
import com.chaosthedude.naturescompass.sorting.NameSorting;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.CompassState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class NaturesCompassScreen
extends Screen {
    public Level level;
    private Player player;
    private List<Biome> allowedBiomes;
    private List<Biome> biomesMatchingSearch;
    private ItemStack stack;
    private NaturesCompassItem natureCompass;
    private Button startSearchButton;
    private Button teleportButton;
    private Button cancelButton;
    private Button sortByButton;
    private TransparentTextField searchTextField;
    private BiomeSearchList selectionList;
    private ISorting<?> sortingCategory;

    public NaturesCompassScreen(Level level, Player player, ItemStack stack, NaturesCompassItem natureCompass, List<ResourceLocation> allowedBiomes) {
        super((Component)Component.translatable((String)"string.naturescompass.selectBiome"));
        this.level = level;
        this.player = player;
        this.stack = stack;
        this.natureCompass = natureCompass;
        this.allowedBiomes = new ArrayList<Biome>();
        this.loadAllowedBiomes(allowedBiomes);
        this.sortingCategory = new NameSorting();
        this.biomesMatchingSearch = new ArrayList<Biome>(this.allowedBiomes);
    }

    public boolean mouseScrolled(double par1, double par2, double par3, double par4) {
        return this.selectionList.mouseScrolled(par1, par2, par3, par4);
    }

    protected void init() {
        this.setupWidgets();
    }

    public void tick() {
        boolean bl = this.teleportButton.active = this.natureCompass.getState(this.stack) == CompassState.FOUND;
        if (this.allowedBiomes.size() != NaturesCompass.allowedBiomes.size()) {
            this.teleportButton.visible = NaturesCompass.canTeleport;
            this.removeWidget((GuiEventListener)this.selectionList);
            this.loadAllowedBiomes(NaturesCompass.allowedBiomes);
            this.biomesMatchingSearch = new ArrayList<Biome>(this.allowedBiomes);
            this.selectionList = new BiomeSearchList(this, this.minecraft, this.width + 110, this.height - 40, 40, 45);
            this.addRenderableWidget((GuiEventListener)this.selectionList);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, I18n.get((String)"string.naturescompass.selectBiome", (Object[])new Object[0]), 65, 15, -1);
    }

    public boolean keyPressed(KeyEvent event) {
        boolean ret = super.keyPressed(event);
        if (this.searchTextField.isFocused()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public boolean charTyped(CharacterEvent event) {
        boolean ret = super.charTyped(event);
        if (this.searchTextField.isFocused()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public void selectBiome(BiomeSearchEntry entry) {
        boolean enable;
        this.startSearchButton.active = enable = entry != null;
    }

    public void searchForBiome(Biome biome) {
        if (BiomeUtils.getKeyForBiome(this.level, biome).isPresent()) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SearchPacket(BiomeUtils.getKeyForBiome(this.level, biome).get(), this.player.blockPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.minecraft.setScreen(null);
    }

    public void teleport() {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new TeleportPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.minecraft.setScreen(null);
    }

    public ISorting<?> getSortingCategory() {
        return this.sortingCategory;
    }

    public void processSearchTerm() {
        this.biomesMatchingSearch = new ArrayList<Biome>();
        String searchTerm = this.searchTextField.getValue().toLowerCase();
        for (Biome biome : this.allowedBiomes) {
            if (searchTerm.startsWith("$")) {
                if (!BiomeUtils.getBiomeTags(this.level, biome).toLowerCase().contains(searchTerm.substring(1))) continue;
                this.biomesMatchingSearch.add(biome);
                continue;
            }
            if (searchTerm.startsWith("@")) {
                if (!BiomeUtils.getBiomeSource(this.level, biome).toLowerCase().contains(searchTerm.substring(1))) continue;
                this.biomesMatchingSearch.add(biome);
                continue;
            }
            if (!BiomeUtils.getBiomeNameForDisplay(this.level, biome).toLowerCase().contains(searchTerm)) continue;
            this.biomesMatchingSearch.add(biome);
        }
        this.selectionList.refreshList();
    }

    public List<Biome> sortBiomes() {
        List<Biome> biomes = this.biomesMatchingSearch;
        Collections.sort(biomes, new NameSorting());
        Collections.sort(biomes, this.sortingCategory);
        return biomes;
    }

    private void setupWidgets() {
        this.clearWidgets();
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)new TransparentButton(10, this.height - 30, 110, 20, (Component)Component.translatable((String)"gui.cancel"), onPress -> this.minecraft.setScreen(null)));
        this.sortByButton = (Button)this.addRenderableWidget((GuiEventListener)new TransparentButton(10, 65, 110, 20, (Component)Component.literal((String)(I18n.get((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName())), onPress -> {
            this.sortingCategory = this.sortingCategory.next();
            this.sortByButton.setMessage((Component)Component.literal((String)(I18n.get((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName())));
            this.selectionList.refreshList();
        }));
        this.startSearchButton = (Button)this.addRenderableWidget((GuiEventListener)new TransparentButton(10, 40, 110, 20, (Component)Component.translatable((String)"string.naturescompass.startSearch"), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((BiomeSearchEntry)this.selectionList.getSelected()).searchForBiome();
            }
        }));
        this.teleportButton = (Button)this.addRenderableWidget((GuiEventListener)new TransparentButton(this.width - 120, 10, 110, 20, (Component)Component.translatable((String)"string.naturescompass.teleport"), onPress -> this.teleport()));
        this.startSearchButton.active = false;
        this.teleportButton.visible = NaturesCompass.canTeleport;
        this.searchTextField = (TransparentTextField)this.addRenderableWidget((GuiEventListener)new TransparentTextField(this.font, 130, 10, 140, 20, (Component)Component.translatable((String)"string.naturescompass.search")));
        if (this.selectionList == null) {
            this.selectionList = new BiomeSearchList(this, this.minecraft, this.width + 110, this.height - 40, 40, 45);
        }
        this.addRenderableWidget((GuiEventListener)this.selectionList);
    }

    private void loadAllowedBiomes(List<ResourceLocation> allowedBiomeKeys) {
        this.allowedBiomes = new ArrayList<Biome>();
        for (ResourceLocation biomeKey : allowedBiomeKeys) {
            Optional<Biome> optionalBiome = BiomeUtils.getBiomeForKey(this.level, biomeKey);
            if (!optionalBiome.isPresent()) continue;
            this.allowedBiomes.add(optionalBiome.get());
        }
    }
}

