/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.gui.BiomeInfoScreen;
import com.chaosthedude.naturescompass.gui.BiomeSearchList;
import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import com.chaosthedude.naturescompass.sorting.DimensionSorting;
import com.chaosthedude.naturescompass.sorting.NameSorting;
import com.chaosthedude.naturescompass.sorting.SourceSorting;
import com.chaosthedude.naturescompass.sorting.TagsSorting;
import com.chaosthedude.naturescompass.utils.BiomeUtils;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public class BiomeSearchEntry
extends class_4280.class_4281<BiomeSearchEntry> {
    private final class_310 mc;
    private final NaturesCompassScreen parentScreen;
    private final class_1959 biome;
    private final BiomeSearchList biomesList;
    private final String tags;
    private long lastClickTime;

    public BiomeSearchEntry(BiomeSearchList biomesList, class_1959 biome) {
        this.biomesList = biomesList;
        this.biome = biome;
        this.parentScreen = biomesList.getGuiNaturesCompass();
        this.mc = class_310.method_1551();
        this.tags = BiomeUtils.getBiomeTags(this.parentScreen.world, biome);
    }

    public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
        String tagsLine;
        String title = this.parentScreen.getSortingCategory().getLocalizedName();
        Object value = this.parentScreen.getSortingCategory().getValue(this.biome);
        if (this.parentScreen.getSortingCategory() instanceof NameSorting || this.parentScreen.getSortingCategory() instanceof SourceSorting || this.parentScreen.getSortingCategory() instanceof TagsSorting || this.parentScreen.getSortingCategory() instanceof DimensionSorting) {
            title = class_1074.method_4662((String)"string.naturescompass.dimension", (Object[])new Object[0]);
            class_2960 biomeID = BiomeUtils.getIdentifierForBiome(this.parentScreen.world, this.biome);
            value = biomeID != null ? BiomeUtils.dimensionKeysToString(NaturesCompass.dimensionIDsForAllowedBiomeIDs.get((Object)biomeID)) : "";
        }
        if (this.mc.field_1772.method_1727(tagsLine = class_1074.method_4662((String)"string.naturescompass.tags", (Object[])new Object[0]) + ": " + this.tags) > this.biomesList.method_25322()) {
            tagsLine = this.mc.field_1772.method_27523(tagsLine + "...", this.biomesList.method_25322()) + "...";
        }
        context.method_51433(this.mc.field_1772, BiomeUtils.getBiomeNameForDisplay(this.parentScreen.world, this.biome), this.method_46426() + 1, this.method_46427() + 1, -1, false);
        class_327 class_3272 = this.mc.field_1772;
        String string = title + ": " + String.valueOf(value);
        int n = this.method_46426() + 1;
        int n2 = this.method_46427();
        Objects.requireNonNull(this.mc.field_1772);
        context.method_51433(class_3272, string, n, n2 + 9 + 3, -8355712, false);
        class_327 class_3273 = this.mc.field_1772;
        int n3 = this.method_46426() + 1;
        int n4 = this.method_46427();
        Objects.requireNonNull(this.mc.field_1772);
        context.method_51433(class_3273, tagsLine, n3, n4 + 9 + 14, -8355712, false);
        class_327 class_3274 = this.mc.field_1772;
        class_5250 class_52502 = class_2561.method_43471((String)"string.naturescompass.source").method_27693(": " + BiomeUtils.getBiomeSource(this.parentScreen.world, this.biome));
        int n5 = this.method_46426() + 1;
        int n6 = this.method_46427();
        Objects.requireNonNull(this.mc.field_1772);
        context.method_51439(class_3274, (class_2561)class_52502, n5, n6 + 9 + 25, -8355712, false);
    }

    public boolean method_25402(class_11909 click, boolean doubleClick) {
        this.biomesList.selectBiome(this);
        if (doubleClick) {
            this.searchForBiome();
        }
        return true;
    }

    public void searchForBiome() {
        this.mc.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        this.parentScreen.searchForBiome(this.biome);
    }

    public void viewInfo() {
        this.mc.method_1507((class_437)new BiomeInfoScreen(this.parentScreen, this.biome));
    }

    public class_2561 method_37006() {
        return class_2561.method_43470((String)BiomeUtils.getBiomeNameForDisplay(this.parentScreen.world, this.biome));
    }
}

