/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.permission.Tristate;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.scheduler.ScheduledTask;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.elytrium.commons.utils.updates.UpdatesChecker;
import net.elytrium.limboapi.thirdparty.commons.config.Placeholders;
import net.elytrium.limboapi.thirdparty.commons.kyori.serialization.Serializer;
import net.elytrium.limboapi.thirdparty.commons.kyori.serialization.Serializers;
import net.elytrium.limboapi.thirdparty.org.bstats.velocity.Metrics;
import net.elytrium.limboauth.LimboAuth;
import net.elytrium.limboauth.handler.AuthSessionHandler;
import net.elytrium.limboauth.model.RegisteredPlayer;
import net.elytrium.limboauth.socialaddon.Settings;
import net.elytrium.limboauth.socialaddon.SocialManager;
import net.elytrium.limboauth.socialaddon.command.ForceSocialUnlinkCommand;
import net.elytrium.limboauth.socialaddon.command.ValidateLinkCommand;
import net.elytrium.limboauth.socialaddon.listener.LimboAuthListener;
import net.elytrium.limboauth.socialaddon.listener.ReloadListener;
import net.elytrium.limboauth.socialaddon.model.SocialPlayer;
import net.elytrium.limboauth.socialaddon.social.AbstractSocial;
import net.elytrium.limboauth.socialaddon.social.DiscordSocial;
import net.elytrium.limboauth.socialaddon.social.TelegramSocial;
import net.elytrium.limboauth.socialaddon.social.VKSocial;
import net.elytrium.limboauth.socialaddon.utils.GeoIp;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.Dao;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.DaoManager;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.stmt.UpdateBuilder;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.support.ConnectionSource;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.table.TableUtils;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import org.apache.commons.logging.impl.Jdk13LumberjackLogger;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.apache.commons.logging.impl.SimpleLog;
import org.slf4j.Logger;

@Plugin(id="limboauth-social-addon", name="LimboAuth Social Addon", version="1.0.11-SNAPSHOT", url="https://elytrium.net/", authors={"Elytrium (https://elytrium.net/)"}, dependencies={@Dependency(id="limboauth")})
public class Addon {
    private static final String INFO_BTN = "info";
    private static final String BLOCK_BTN = "block";
    private static final String TOTP_BTN = "2fa";
    private static final String NOTIFY_BTN = "notify";
    private static final String KICK_BTN = "kick";
    private static final String RESTORE_BTN = "restore";
    private static final String UNLINK_BTN = "unlink";
    private static final String PLUGIN_MINIMUM_VERSION = "1.1.0";
    private static Serializer SERIALIZER;
    private final ProxyServer server;
    private final Logger logger;
    private final Metrics.Factory metricsFactory;
    private final Path dataDirectory;
    private final LimboAuth plugin;
    private final Map<String, Integer> codeMap;
    private final Map<String, TempAccount> requestedReverseMap;
    private final Map<String, CachedRegisteredUser> cachedAccountRegistrations = new ConcurrentHashMap<String, CachedRegisteredUser>();
    private Dao<SocialPlayer, String> dao;
    private Pattern nicknamePattern;
    private SocialManager socialManager;
    private List<List<AbstractSocial.ButtonItem>> keyboard;
    private GeoIp geoIp;
    private ScheduledTask purgeCacheTask;

    @Inject
    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public Addon(ProxyServer server, Logger logger, Metrics.Factory metricsFactory, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.metricsFactory = metricsFactory;
        this.dataDirectory = dataDirectory;
        Optional container = this.server.getPluginManager().getPlugin("limboauth");
        String version = (String)container.map(PluginContainer::getDescription).flatMap(PluginDescription::getVersion).orElseThrow();
        if (!UpdatesChecker.checkVersion((String)PLUGIN_MINIMUM_VERSION, (String)version)) {
            throw new IllegalStateException("Incorrect version of LimboAuth plugin, the addon requires version 1.1.0 or newer");
        }
        this.plugin = (LimboAuth)container.flatMap(PluginContainer::getInstance).orElseThrow();
        this.codeMap = new ConcurrentHashMap<String, Integer>();
        this.requestedReverseMap = new ConcurrentHashMap<String, TempAccount>();
    }

    @Subscribe(order=PostOrder.NORMAL)
    public void onProxyInitialization(ProxyInitializeEvent event) throws SQLException {
        this.onReload();
        this.metricsFactory.make((Object)this, 14770);
        if (!UpdatesChecker.checkVersionByURL((String)"https://raw.githubusercontent.com/Elytrium/LimboAuth-SocialAddon/master/VERSION", (String)Settings.IMP.VERSION)) {
            this.logger.error("****************************************");
            this.logger.warn("The new LimboAuth update was found, please update.");
            this.logger.error("https://github.com/Elytrium/LimboAuth-SocialAddon/releases/");
            this.logger.error("****************************************");
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="LEGACY_AMPERSAND can't be null in velocity.")
    private void load() {
        Settings.IMP.reload(new File(this.dataDirectory.toFile().getAbsoluteFile(), "config.yml"), Settings.IMP.PREFIX);
        ComponentSerializer serializer = Settings.IMP.SERIALIZER.getSerializer();
        if (serializer == null) {
            this.logger.warn("The specified serializer could not be founded, using default. (LEGACY_AMPERSAND)");
            Addon.setSerializer(new Serializer(Objects.requireNonNull(Serializers.LEGACY_AMPERSAND.getSerializer())));
        } else {
            Addon.setSerializer(new Serializer(serializer));
        }
        GeoIp geoIp = this.geoIp = Settings.IMP.MAIN.GEOIP.ENABLED ? new GeoIp(this.dataDirectory) : null;
        if (this.socialManager != null) {
            this.socialManager.stop();
        }
        this.socialManager = new SocialManager(DiscordSocial::new, TelegramSocial::new, VKSocial::new);
        this.socialManager.start();
        this.keyboard = List.of(List.of(new AbstractSocial.ButtonItem(INFO_BTN, Settings.IMP.MAIN.STRINGS.INFO_BTN, AbstractSocial.ButtonItem.Color.PRIMARY)), List.of(new AbstractSocial.ButtonItem(BLOCK_BTN, Settings.IMP.MAIN.STRINGS.BLOCK_TOGGLE_BTN, AbstractSocial.ButtonItem.Color.SECONDARY), new AbstractSocial.ButtonItem(TOTP_BTN, Settings.IMP.MAIN.STRINGS.TOGGLE_2FA_BTN, AbstractSocial.ButtonItem.Color.SECONDARY)), List.of(new AbstractSocial.ButtonItem(NOTIFY_BTN, Settings.IMP.MAIN.STRINGS.TOGGLE_NOTIFICATION_BTN, AbstractSocial.ButtonItem.Color.SECONDARY)), List.of(new AbstractSocial.ButtonItem(KICK_BTN, Settings.IMP.MAIN.STRINGS.KICK_BTN, AbstractSocial.ButtonItem.Color.RED), new AbstractSocial.ButtonItem(RESTORE_BTN, Settings.IMP.MAIN.STRINGS.RESTORE_BTN, AbstractSocial.ButtonItem.Color.RED), new AbstractSocial.ButtonItem(UNLINK_BTN, Settings.IMP.MAIN.STRINGS.UNLINK_BTN, AbstractSocial.ButtonItem.Color.RED)));
        this.socialManager.registerKeyboard(this.keyboard);
        this.socialManager.addMessageEvent((dbField, id, message) -> {
            int desiredLength;
            String lowercaseMessage = message.toLowerCase(Locale.ROOT);
            if (Settings.IMP.MAIN.START_MESSAGES.contains(lowercaseMessage)) {
                this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.START_REPLY);
                return;
            }
            for (String socialRegisterCmd : Settings.IMP.MAIN.SOCIAL_REGISTER_CMDS) {
                if (!lowercaseMessage.startsWith(socialRegisterCmd)) continue;
                desiredLength = socialRegisterCmd.length() + 1;
                if (message.length() <= desiredLength) {
                    this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.LINK_SOCIAL_REGISTER_CMD_USAGE);
                    return;
                }
                String userIndex = dbField + id;
                CachedRegisteredUser cachedRegisteredUser = this.cachedAccountRegistrations.get(userIndex);
                if (cachedRegisteredUser == null) {
                    cachedRegisteredUser = new CachedRegisteredUser();
                    this.cachedAccountRegistrations.put(userIndex, cachedRegisteredUser);
                }
                if (cachedRegisteredUser.getRegistrationAmount() >= Settings.IMP.MAIN.MAX_REGISTRATION_COUNT_PER_TIME) {
                    this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.REGISTER_LIMIT);
                    return;
                }
                cachedRegisteredUser.incrementRegistrationAmount();
                if (this.dao.queryForEq(dbField, (Object)id).size() != 0) {
                    this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.LINK_ALREADY);
                    return;
                }
                String account = message.substring(desiredLength);
                if (!this.nicknamePattern.matcher(account).matches()) {
                    this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.REGISTER_INCORRECT_NICKNAME);
                    return;
                }
                String lowercaseNickname = account.toLowerCase(Locale.ROOT);
                if (this.plugin.getPlayerDao().idExists((Object)lowercaseNickname)) {
                    this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.REGISTER_TAKEN_NICKNAME);
                    return;
                }
                if (!Settings.IMP.MAIN.ALLOW_PREMIUM_NAMES_REGISTRATION && this.plugin.isPremium(lowercaseNickname)) {
                    this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.REGISTER_PREMIUM_NICKNAME);
                    return;
                }
                String newPassword = Long.toHexString(Double.doubleToLongBits(Math.random()));
                RegisteredPlayer player = new RegisteredPlayer(account, "", "").setPassword(newPassword);
                this.plugin.getPlayerDao().create((Object)player);
                this.linkSocial(lowercaseNickname, dbField, id);
                this.socialManager.broadcastMessage(dbField, id, Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.REGISTER_SUCCESS, (Object[])new Object[]{newPassword}));
            }
            for (String socialLinkCmd : Settings.IMP.MAIN.SOCIAL_LINK_CMDS) {
                if (!lowercaseMessage.startsWith(socialLinkCmd)) continue;
                desiredLength = socialLinkCmd.length() + 1;
                if (message.length() <= desiredLength) {
                    this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.LINK_SOCIAL_CMD_USAGE);
                    return;
                }
                String[] args = message.substring(desiredLength).split(" ");
                if (this.dao.queryForEq(dbField, (Object)id).size() != 0) {
                    this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.LINK_ALREADY);
                    return;
                }
                String account = args[0].toLowerCase(Locale.ROOT);
                if (!this.nicknamePattern.matcher(account).matches()) {
                    this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.LINK_UNKNOWN_ACCOUNT);
                    return;
                }
                if (args.length == 1) {
                    if (Settings.IMP.MAIN.DISABLE_LINK_WITHOUT_PASSWORD) {
                        this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.LINK_SOCIAL_CMD_USAGE);
                        return;
                    }
                    int code = ThreadLocalRandom.current().nextInt(Settings.IMP.MAIN.CODE_LOWER_BOUND, Settings.IMP.MAIN.CODE_UPPER_BOUND);
                    this.codeMap.put(account, code);
                    this.requestedReverseMap.put(account, new TempAccount(dbField, id));
                    this.socialManager.broadcastMessage(dbField, id, Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.LINK_CODE, (Object[])new Object[]{String.valueOf(code)}));
                } else {
                    if (Settings.IMP.MAIN.DISABLE_LINK_WITH_PASSWORD) {
                        this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.LINK_SOCIAL_CMD_USAGE);
                        return;
                    }
                    RegisteredPlayer registeredPlayer = (RegisteredPlayer)this.plugin.getPlayerDao().queryForId((Object)account);
                    if (AuthSessionHandler.checkPassword((String)args[1], (RegisteredPlayer)registeredPlayer, (Dao)this.plugin.getPlayerDao())) {
                        this.linkSocial(account, dbField, id);
                        this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.LINK_SUCCESS);
                    } else {
                        this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.LINK_WRONG_PASSWORD);
                        return;
                    }
                }
                return;
            }
            for (String forceKeyboardCmd : Settings.IMP.MAIN.FORCE_KEYBOARD_CMDS) {
                if (!lowercaseMessage.startsWith(forceKeyboardCmd)) continue;
                if (this.dao.queryBuilder().where().eq(dbField, (Object)id).countOf() == 0L) {
                    this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.START_REPLY);
                    return;
                }
                this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.KEYBOARD_RESTORED, this.keyboard);
                return;
            }
        });
        this.socialManager.addButtonEvent(INFO_BTN, (dbField, id) -> {
            String location;
            String ip;
            String server;
            List socialPlayerList = this.dao.queryForEq(dbField, (Object)id);
            if (socialPlayerList.size() == 0) {
                return;
            }
            SocialPlayer player = (SocialPlayer)socialPlayerList.get(0);
            Optional proxyPlayer = this.server.getPlayer(player.getLowercaseNickname());
            if (proxyPlayer.isPresent()) {
                Player player1 = (Player)proxyPlayer.get();
                Optional connection = player1.getCurrentServer();
                server = connection.isPresent() ? ((ServerConnection)connection.get()).getServerInfo().getName() : Settings.IMP.MAIN.STRINGS.STATUS_OFFLINE;
                ip = player1.getRemoteAddress().getAddress().getHostAddress();
                location = Optional.ofNullable(this.geoIp).map(nonNullGeo -> nonNullGeo.getLocation(ip)).orElse("");
            } else {
                server = Settings.IMP.MAIN.STRINGS.STATUS_OFFLINE;
                ip = Settings.IMP.MAIN.STRINGS.STATUS_OFFLINE;
                location = "";
            }
            this.socialManager.broadcastMessage(dbField, id, Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.INFO_MSG, (Object[])new Object[]{player.getLowercaseNickname(), server, ip, location, player.isNotifyEnabled() ? Settings.IMP.MAIN.STRINGS.NOTIFY_ENABLED : Settings.IMP.MAIN.STRINGS.NOTIFY_DISABLED, player.isBlocked() != false ? Settings.IMP.MAIN.STRINGS.BLOCK_ENABLED : Settings.IMP.MAIN.STRINGS.BLOCK_DISABLED, player.isTotpEnabled() != false ? Settings.IMP.MAIN.STRINGS.TOTP_ENABLED : Settings.IMP.MAIN.STRINGS.TOTP_DISABLED}), this.keyboard);
        });
        this.socialManager.addButtonEvent(BLOCK_BTN, (dbField, id) -> {
            List socialPlayerList = this.dao.queryForEq(dbField, (Object)id);
            if (socialPlayerList.size() == 0) {
                return;
            }
            SocialPlayer player = (SocialPlayer)socialPlayerList.get(0);
            if (player.isBlocked().booleanValue()) {
                player.setBlocked(false);
                this.socialManager.broadcastMessage(dbField, id, Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.UNBLOCK_SUCCESS, (Object[])new Object[]{player.getLowercaseNickname()}), this.keyboard);
            } else {
                player.setBlocked(true);
                this.plugin.removePlayerFromCache(player.getLowercaseNickname());
                this.server.getPlayer(player.getLowercaseNickname()).ifPresent(e -> e.disconnect(Addon.getSerializer().deserialize(Settings.IMP.MAIN.STRINGS.KICK_GAME_MESSAGE)));
                this.socialManager.broadcastMessage(dbField, id, Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.BLOCK_SUCCESS, (Object[])new Object[]{player.getLowercaseNickname()}), this.keyboard);
            }
            this.dao.update((Object)player);
        });
        this.socialManager.addButtonEvent(TOTP_BTN, (dbField, id) -> {
            List socialPlayerList = this.dao.queryForEq(dbField, (Object)id);
            if (socialPlayerList.size() == 0) {
                return;
            }
            SocialPlayer player = (SocialPlayer)socialPlayerList.get(0);
            if (player.isTotpEnabled().booleanValue()) {
                player.setTotpEnabled(false);
                this.socialManager.broadcastMessage(dbField, id, Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.TOTP_DISABLE_SUCCESS, (Object[])new Object[]{player.getLowercaseNickname()}), this.keyboard);
            } else {
                player.setTotpEnabled(true);
                this.socialManager.broadcastMessage(dbField, id, Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.TOTP_ENABLE_SUCCESS, (Object[])new Object[]{player.getLowercaseNickname()}), this.keyboard);
            }
            this.dao.update((Object)player);
        });
        this.socialManager.addButtonEvent(NOTIFY_BTN, (dbField, id) -> {
            List socialPlayerList = this.dao.queryForEq(dbField, (Object)id);
            if (socialPlayerList.size() == 0) {
                return;
            }
            SocialPlayer player = (SocialPlayer)socialPlayerList.get(0);
            if (player.isNotifyEnabled()) {
                player.setNotifyEnabled(false);
                this.socialManager.broadcastMessage(dbField, id, Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.NOTIFY_DISABLE_SUCCESS, (Object[])new Object[]{player.getLowercaseNickname()}), this.keyboard);
            } else {
                player.setNotifyEnabled(true);
                this.socialManager.broadcastMessage(dbField, id, Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.NOTIFY_ENABLE_SUCCESS, (Object[])new Object[]{player.getLowercaseNickname()}), this.keyboard);
            }
            this.dao.update((Object)player);
        });
        this.socialManager.addButtonEvent(KICK_BTN, (dbField, id) -> {
            List socialPlayerList = this.dao.queryForEq(dbField, (Object)id);
            if (socialPlayerList.size() == 0) {
                return;
            }
            SocialPlayer player = (SocialPlayer)socialPlayerList.get(0);
            Optional proxyPlayer = this.server.getPlayer(player.getLowercaseNickname());
            this.plugin.removePlayerFromCache(player.getLowercaseNickname());
            if (proxyPlayer.isPresent()) {
                ((Player)proxyPlayer.get()).disconnect(Addon.getSerializer().deserialize(Settings.IMP.MAIN.STRINGS.KICK_GAME_MESSAGE));
                this.socialManager.broadcastMessage(dbField, id, Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.KICK_SUCCESS, (Object[])new Object[]{player.getLowercaseNickname()}), this.keyboard);
            } else {
                this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.KICK_IS_OFFLINE.replace("{NICKNAME}", player.getLowercaseNickname()), this.keyboard);
            }
            this.dao.update((Object)player);
        });
        this.socialManager.addButtonEvent(RESTORE_BTN, (dbField, id) -> {
            boolean updated;
            List socialPlayerList = this.dao.queryForEq(dbField, (Object)id);
            if (socialPlayerList.size() == 0) {
                return;
            }
            SocialPlayer player = (SocialPlayer)socialPlayerList.get(0);
            if (Settings.IMP.MAIN.PROHIBIT_PREMIUM_RESTORE && this.plugin.isPremiumInternal(player.getLowercaseNickname()).getState() != LimboAuth.PremiumState.CRACKED) {
                this.socialManager.broadcastMessage(dbField, id, Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.RESTORE_MSG_PREMIUM, (Object[])new Object[]{player.getLowercaseNickname()}), this.keyboard);
                return;
            }
            Dao playerDao = this.plugin.getPlayerDao();
            String newPassword = Long.toHexString(Double.doubleToLongBits(Math.random()));
            UpdateBuilder updateBuilder = playerDao.updateBuilder();
            updateBuilder.where().eq("LOWERCASENICKNAME", (Object)player.getLowercaseNickname());
            updateBuilder.updateColumnValue("HASH", (Object)RegisteredPlayer.genHash((String)newPassword));
            boolean bl = updated = updateBuilder.update() != 0;
            if (updated) {
                this.socialManager.broadcastMessage(dbField, id, Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.RESTORE_MSG, (Object[])new Object[]{player.getLowercaseNickname(), newPassword}), this.keyboard);
            } else {
                this.socialManager.broadcastMessage(dbField, id, Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.RESTORE_MSG_PREMIUM, (Object[])new Object[]{player.getLowercaseNickname()}), this.keyboard);
            }
        });
        this.socialManager.addButtonEvent(UNLINK_BTN, (dbField, id) -> {
            if (Settings.IMP.MAIN.DISABLE_UNLINK) {
                this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.UNLINK_DISABLED, this.keyboard);
                return;
            }
            List socialPlayerList = this.dao.queryForEq(dbField, (Object)id);
            if (socialPlayerList.size() == 0) {
                return;
            }
            SocialPlayer player = (SocialPlayer)socialPlayerList.get(0);
            if (player.isBlocked().booleanValue()) {
                this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.UNLINK_BLOCK_CONFLICT, this.keyboard);
                return;
            }
            if (player.isTotpEnabled().booleanValue()) {
                this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.UNLINK_2FA_CONFLICT, this.keyboard);
                return;
            }
            Long playerId = SocialPlayer.DatabaseField.valueOf(dbField).getIdFor(player);
            SocialPlayer.DatabaseField.valueOf(dbField).setIdFor(player, null);
            boolean allUnlinked = Arrays.stream(SocialPlayer.DatabaseField.values()).noneMatch(v -> v.getIdFor(player) != null);
            SocialPlayer.DatabaseField.valueOf(dbField).setIdFor(player, playerId);
            if (Settings.IMP.MAIN.UNLINK_BTN_ALL || allUnlinked) {
                this.socialManager.unregisterHook(player);
                this.dao.delete((Object)player);
                Settings.IMP.MAIN.AFTER_UNLINKAGE_COMMANDS.forEach(command -> this.server.getCommandManager().executeAsync(p -> Tristate.TRUE, command.replace("{NICKNAME}", player.getLowercaseNickname())));
            } else {
                UpdateBuilder updateBuilder = this.dao.updateBuilder();
                updateBuilder.where().eq("LOWERCASENICKNAME", (Object)player.getLowercaseNickname());
                updateBuilder.updateColumnValue(dbField, null);
                updateBuilder.update();
                this.socialManager.unregisterHook(dbField, player);
            }
            this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.UNLINK_SUCCESS);
            this.server.getPlayer(player.getLowercaseNickname()).ifPresent(p -> p.sendMessage(SERIALIZER.deserialize(Settings.IMP.MAIN.STRINGS.UNLINK_SUCCESS_GAME)));
        });
    }

    public void onReload() throws SQLException {
        this.load();
        this.server.getEventManager().unregisterListeners((Object)this);
        ConnectionSource source = this.plugin.getConnectionSource();
        TableUtils.createTableIfNotExists((ConnectionSource)source, SocialPlayer.class);
        this.dao = DaoManager.createDao((ConnectionSource)source, SocialPlayer.class);
        this.plugin.migrateDb(this.dao);
        this.nicknamePattern = Pattern.compile(net.elytrium.limboauth.Settings.IMP.MAIN.ALLOWED_NICKNAME_REGEX);
        this.server.getEventManager().register((Object)this, (Object)new LimboAuthListener(this, this.plugin, this.dao, this.socialManager, this.keyboard, this.geoIp));
        this.server.getEventManager().register((Object)this, (Object)new ReloadListener(this));
        if (this.purgeCacheTask != null) {
            this.purgeCacheTask.cancel();
        }
        this.purgeCacheTask = this.server.getScheduler().buildTask((Object)this, () -> this.checkCache(this.cachedAccountRegistrations, Settings.IMP.MAIN.PURGE_REGISTRATION_CACHE_MILLIS)).delay(net.elytrium.limboauth.Settings.IMP.MAIN.PURGE_CACHE_MILLIS, TimeUnit.MILLISECONDS).repeat(net.elytrium.limboauth.Settings.IMP.MAIN.PURGE_CACHE_MILLIS, TimeUnit.MILLISECONDS).schedule();
        CommandManager commandManager = this.server.getCommandManager();
        commandManager.unregister(Settings.IMP.MAIN.LINKAGE_MAIN_CMD);
        commandManager.unregister(Settings.IMP.MAIN.FORCE_UNLINK_MAIN_CMD);
        commandManager.register(Settings.IMP.MAIN.LINKAGE_MAIN_CMD, (Command)new ValidateLinkCommand(this), Settings.IMP.MAIN.LINKAGE_ALIAS_CMD.toArray(new String[0]));
        commandManager.register(Settings.IMP.MAIN.FORCE_UNLINK_MAIN_CMD, (Command)new ForceSocialUnlinkCommand(this), Settings.IMP.MAIN.FORCE_UNLINK_ALIAS_CMD.toArray(new String[0]));
    }

    private void checkCache(Map<?, ? extends CachedUser> userMap, long time) {
        userMap.entrySet().stream().filter(userEntry -> ((CachedUser)userEntry.getValue()).getCheckTime() + time <= System.currentTimeMillis()).map(Map.Entry::getKey).forEach(userMap::remove);
    }

    public void unregisterPlayer(String nickname) {
        try {
            SocialPlayer player = (SocialPlayer)this.dao.queryForId((Object)nickname.toLowerCase(Locale.ROOT));
            if (player != null) {
                this.socialManager.unregisterHook(player);
                this.dao.delete((Object)player);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public void linkSocial(String lowercaseNickname, String dbField, Long id) throws SQLException {
        SocialPlayer socialPlayer = (SocialPlayer)this.dao.queryForId((Object)lowercaseNickname);
        if (socialPlayer == null) {
            Settings.IMP.MAIN.AFTER_LINKAGE_COMMANDS.forEach(command -> this.server.getCommandManager().executeAsync(p -> Tristate.TRUE, command.replace("{NICKNAME}", lowercaseNickname)));
            this.dao.create((Object)new SocialPlayer(lowercaseNickname));
        } else if (!Settings.IMP.MAIN.ALLOW_ACCOUNT_RELINK && SocialPlayer.DatabaseField.valueOf(dbField).getIdFor(socialPlayer) != null) {
            this.socialManager.broadcastMessage(dbField, id, Settings.IMP.MAIN.STRINGS.LINK_ALREADY);
            return;
        }
        UpdateBuilder updateBuilder = this.dao.updateBuilder();
        updateBuilder.where().eq("LOWERCASENICKNAME", (Object)lowercaseNickname);
        updateBuilder.updateColumnValue(dbField, (Object)id);
        updateBuilder.update();
    }

    public Integer getCode(String nickname) {
        return this.codeMap.get(nickname);
    }

    public TempAccount getTempAccount(String nickname) {
        return this.requestedReverseMap.get(nickname);
    }

    public void removeCode(String nickname) {
        this.requestedReverseMap.remove(nickname);
        this.codeMap.remove(nickname);
    }

    public SocialManager getSocialManager() {
        return this.socialManager;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public List<List<AbstractSocial.ButtonItem>> getKeyboard() {
        return this.keyboard;
    }

    private static void setSerializer(Serializer serializer) {
        SERIALIZER = serializer;
    }

    public static Serializer getSerializer() {
        return SERIALIZER;
    }

    static {
        Objects.requireNonNull(LogFactoryImpl.class);
        Objects.requireNonNull(Log4JLogger.class);
        Objects.requireNonNull(Jdk14Logger.class);
        Objects.requireNonNull(Jdk13LumberjackLogger.class);
        Objects.requireNonNull(SimpleLog.class);
        if (System.getProperty("api.host") == null) {
            System.setProperty("api.host", "api.vk.ru");
        }
        if (System.getProperty("oauth.host") == null) {
            System.setProperty("oauth.host", "oauth.vk.ru");
        }
    }

    public static class TempAccount {
        private final String dbField;
        private final long id;

        public TempAccount(String dbField, long id) {
            this.dbField = dbField;
            this.id = id;
        }

        public String getDbField() {
            return this.dbField;
        }

        public long getId() {
            return this.id;
        }
    }

    private static class CachedUser {
        private final long checkTime = System.currentTimeMillis();

        private CachedUser() {
        }

        public long getCheckTime() {
            return this.checkTime;
        }
    }

    private static class CachedRegisteredUser
    extends CachedUser {
        private int registrationAmount;

        private CachedRegisteredUser() {
        }

        public int getRegistrationAmount() {
            return this.registrationAmount;
        }

        public void incrementRegistrationAmount() {
            ++this.registrationAmount;
        }
    }
}

