/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon;

import java.util.List;
import net.elytrium.limboapi.thirdparty.commons.config.YamlConfig;
import net.elytrium.limboapi.thirdparty.commons.kyori.serialization.Serializers;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.Activity;

public class Settings
extends YamlConfig {
    @YamlConfig.Ignore
    public static final Settings IMP = new Settings();
    @YamlConfig.Final
    public String VERSION = "1.0.11-SNAPSHOT";
    @YamlConfig.Comment(value={"Available serializers:", "LEGACY_AMPERSAND - \"&c&lExample &c&9Text\".", "LEGACY_SECTION - \"\u00a7c\u00a7lExample \u00a7c\u00a79Text\".", "MINIMESSAGE - \"<bold><red>Example</red> <blue>Text</blue></bold>\". (https://webui.adventure.kyori.net/)", "GSON - \"[{\"text\":\"Example\",\"bold\":true,\"color\":\"red\"},{\"text\":\" \",\"bold\":true},{\"text\":\"Text\",\"bold\":true,\"color\":\"blue\"}]\". (https://minecraft.tools/en/json_text.php/)", "GSON_COLOR_DOWNSAMPLING - Same as GSON, but uses downsampling."})
    public Serializers SERIALIZER = Serializers.LEGACY_AMPERSAND;
    public String PREFIX = "LimboAuth &6>>&f";
    @YamlConfig.Create
    public MAIN MAIN;

    public static class MAIN {
        public List<String> SOCIAL_REGISTER_CMDS = List.of("!account register");
        public List<String> SOCIAL_LINK_CMDS = List.of("!account link");
        public List<String> FORCE_KEYBOARD_CMDS = List.of("!keyboard");
        public int CODE_LOWER_BOUND = 1000000;
        public int CODE_UPPER_BOUND = 10000000;
        public String LINKAGE_MAIN_CMD = "addsocial";
        public List<String> LINKAGE_ALIAS_CMD = List.of("addvk", "addtg", "addds");
        public String FORCE_UNLINK_MAIN_CMD = "forcesocialunlink";
        public List<String> FORCE_UNLINK_ALIAS_CMD = List.of("forceunlink");
        @YamlConfig.Comment(value={"Should we allow registration with premium usernames using social-register-cmds"})
        public boolean ALLOW_PREMIUM_NAMES_REGISTRATION = false;
        public boolean ENABLE_NOTIFY = true;
        @YamlConfig.Comment(value={"Will the unlink button unregister all socials at once?"})
        public boolean UNLINK_BTN_ALL = false;
        @YamlConfig.Comment(value={"Disable unlinking?"})
        public boolean DISABLE_UNLINK = false;
        @YamlConfig.Comment(value={"Disable commands like !account link <username>"})
        public boolean DISABLE_LINK_WITHOUT_PASSWORD = false;
        @YamlConfig.Comment(value={"Disable commands like !account link <username> <password>"})
        public boolean DISABLE_LINK_WITH_PASSWORD = true;
        @YamlConfig.Comment(value={"Default buttons state"})
        public boolean DEFAULT_BLOCKED = false;
        public boolean DEFAULT_TOTP_ENABLED = false;
        public boolean DEFAULT_NOTIFY_ENABLED = true;
        @YamlConfig.Comment(value={"Allow linking social to the player, who already has linked this type of social"})
        public boolean ALLOW_ACCOUNT_RELINK = true;
        public List<String> AFTER_LINKAGE_COMMANDS = List.of("alert {NICKNAME} has linked a social account");
        public List<String> AFTER_UNLINKAGE_COMMANDS = List.of();
        public List<String> START_MESSAGES = List.of("/start", "\u041d\u0430\u0447\u0430\u0442\u044c");
        public String START_REPLY = "Send '!account link <nickname>' to link your account";
        @YamlConfig.Comment(value={"Addon will print all exceptions if this parameter is set to true."})
        public boolean DEBUG = false;
        @YamlConfig.Comment(value={"Prohibit premium users from changing their password via the restore button."})
        public boolean PROHIBIT_PREMIUM_RESTORE = true;
        @YamlConfig.Comment(value={"NO | YES - with the option disabled", "YES | NO - with the option enabled"})
        public boolean REVERSE_YES_NO_BUTTONS = false;
        @YamlConfig.Comment(value={"false - players with social 2FA enabled should enter the password", "true - players with social 2FA enabled can login without the password"})
        public boolean AUTH_2FA_WITHOUT_PASSWORD = false;
        @YamlConfig.Comment(value={"How long in milliseconds the player should wait before registering new account"})
        public long PURGE_REGISTRATION_CACHE_MILLIS = 86400000L;
        @YamlConfig.Comment(value={"How many accounts can register the player per time (per purge-registration-cache-millis)"})
        public int MAX_REGISTRATION_COUNT_PER_TIME = 3;
        @YamlConfig.Create
        public VK VK;
        @YamlConfig.Create
        public DISCORD DISCORD;
        @YamlConfig.Create
        public TELEGRAM TELEGRAM;
        @YamlConfig.Create
        public GEOIP GEOIP;
        @YamlConfig.Create
        public STRINGS STRINGS;

        public static class STRINGS {
            @YamlConfig.Placeholders(value={"{NICKNAME}"})
            public String LINK_CMD_USAGE = "{PRFX} Send '!account link {NICKNAME}' to our Social Bot{NL} VK: vk.com/123{NL} DS: Bot#0000{NL} TG: @bot";
            @YamlConfig.Placeholders(value={"{NICKNAME}"})
            public String LINK_WRONG_CODE = "{PRFX} Wrong code, run '!account link {NICKNAME}' again";
            public String LINK_SUCCESS_GAME = "{PRFX} Social was successfully linked";
            public String LINK_SUCCESS = "\u2705 Social was successfully linked{NL}Use '!keyboard' to show keyboard";
            public String LINK_ALREADY = "Account is already linked";
            public String LINK_SOCIAL_REGISTER_CMD_USAGE = "You didn't specify a nickname. Enter '!account register <nickname>'";
            public String LINK_SOCIAL_CMD_USAGE = "You didn't specify a nickname. Enter '!account link <nickname>'";
            public String LINK_UNKNOWN_ACCOUNT = "There is no account with this nickname";
            @YamlConfig.Placeholders(value={"{CODE}"})
            public String LINK_CODE = "\ud83d\udd11 Enter '/addsocial {CODE}' in game to complete account linking";
            public String LINK_WRONG_PASSWORD = "Wrong password";
            public String REGISTER_INCORRECT_NICKNAME = "There is no account with this nickname";
            public String REGISTER_TAKEN_NICKNAME = "This nickname is already taken";
            public String REGISTER_PREMIUM_NICKNAME = "This nickname belongs to a premium player";
            public String REGISTER_LIMIT = "You've tried to registered numerous times!";
            @YamlConfig.Placeholders(value={"{PASSWORD}"})
            public String REGISTER_SUCCESS = "\u2705 Account was successfully registered{NL}Your password: {PASSWORD}{NL}Use '!keyboard' to show keyboard";
            public String FORCE_UNLINK_CMD_USAGE = "{PRFX} Usage: /forcesocialunregister <username>";
            public String NOTIFY_LEAVE = "\u2796 You've left the server";
            @YamlConfig.Placeholders(value={"{IP}", "{LOCATION}"})
            public String NOTIFY_JOIN = "\u2795 You've joined the server {NL}\ud83c\udf10 IP: {IP} {LOCATION}{NL}You can block your account if that is not you";
            public String NOTIFY_ASK_KICK_MESSAGE = "{PRFX} You were kicked by the Social";
            @YamlConfig.Placeholders(value={"{IP}", "{LOCATION}"})
            public String NOTIFY_ASK_VALIDATE = "\u2754 Someone tries to join the server.{NL}\ud83c\udf10 IP: {IP} {LOCATION}{NL}Is it you?";
            public String NOTIFY_ASK_VALIDATE_GAME = "{PRFX} You have 2FA enabled, check your social and validate your login!";
            public String NOTIFY_ASK_YES = "It's me";
            public String NOTIFY_ASK_NO = "It's not me";
            public String NOTIFY_THANKS = "Thanks for verifying your login";
            public String NOTIFY_WARN = "You can always change your password using the 'Restore' button";
            public String BLOCK_TOGGLE_BTN = "Toggle block";
            public String BLOCK_KICK_MESSAGE = "{PRFX} Your account was blocked by the Social";
            @YamlConfig.Placeholders(value={"{NICKNAME}"})
            public String BLOCK_SUCCESS = "Account {NICKNAME} was successfully blocked";
            @YamlConfig.Placeholders(value={"{NICKNAME}"})
            public String UNBLOCK_SUCCESS = "Account {NICKNAME} was successfully unblocked";
            @YamlConfig.Placeholders(value={"{NICKNAME}"})
            public String TOTP_ENABLE_SUCCESS = "Account {NICKNAME} now uses 2FA";
            @YamlConfig.Placeholders(value={"{NICKNAME}"})
            public String TOTP_DISABLE_SUCCESS = "Account {NICKNAME} doesn't use 2FA anymore";
            @YamlConfig.Placeholders(value={"{NICKNAME}"})
            public String NOTIFY_ENABLE_SUCCESS = "Account {NICKNAME} now receives notifications";
            @YamlConfig.Placeholders(value={"{NICKNAME}"})
            public String NOTIFY_DISABLE_SUCCESS = "Account {NICKNAME} doesn't receive notifications anymore";
            public String KICK_IS_OFFLINE = "Cannot kick player - player is offline";
            @YamlConfig.Placeholders(value={"{NICKNAME}"})
            public String KICK_SUCCESS = "Player {NICKNAME} was successfully kicked";
            public String KICK_GAME_MESSAGE = "{PRFX} You were kicked by the Social";
            public String RESTORE_BTN = "Restore";
            @YamlConfig.Placeholders(value={"{NICKNAME}", "{PASSWORD}"})
            public String RESTORE_MSG = "The new password for {NICKNAME} is: {PASSWORD}";
            @YamlConfig.Placeholders(value={"{NICKNAME}"})
            public String RESTORE_MSG_PREMIUM = "We can't change your password, {NICKNAME}, perhaps you are a premium player.";
            public String INFO_BTN = "Info";
            @YamlConfig.Placeholders(value={"{NICKNAME}", "{SERVER}", "{IP}", "{LOCATION}", "{NOTIFY_STATUS}", "{BLOCK_STATUS}", "{TOTP_STATUS}"})
            public String INFO_MSG = "\ud83d\udc64 IGN: {NICKNAME}{NL}\ud83c\udf0d Current status: {SERVER}{NL}\ud83c\udf10 IP: {IP} {LOCATION}{NL}\u23f0 Notifications: {NOTIFY_STATUS}{NL}\u274c Blocked: {BLOCK_STATUS}{NL}\ud83d\udd11 2FA: {TOTP_STATUS}";
            public String STATUS_OFFLINE = "OFFLINE";
            public String NOTIFY_ENABLED = "Enabled";
            public String NOTIFY_DISABLED = "Disabled";
            public String BLOCK_ENABLED = "Yes";
            public String BLOCK_DISABLED = "No";
            public String TOTP_ENABLED = "Enabled";
            public String TOTP_DISABLED = "Disabled";
            public String KICK_BTN = "Kick";
            public String TOGGLE_NOTIFICATION_BTN = "Toggle notifications";
            public String TOGGLE_2FA_BTN = "Toggle 2FA";
            public String UNLINK_BTN = "Unlink social";
            public String UNLINK_DISABLED = "Unlinking disabled";
            public String UNLINK_SUCCESS = "Unlink successful";
            public String UNLINK_SUCCESS_GAME = "{PRFX} Unlink successful";
            public String UNLINK_BLOCK_CONFLICT = "You cannot unlink the social while your account is blocked. Unblock it first";
            public String UNLINK_2FA_CONFLICT = "You cannot unlink the social while 2FA is enabled. Disable it first";
            public String KEYBOARD_RESTORED = "Keyboard was restored";
            @YamlConfig.Comment(value={"This message will be sent to the players without social-link right after their login"})
            public String LINK_ANNOUNCEMENT = "{PRFX} Hey! We recommend you to link a social network using the /addsocial command to secure your account";
            public String SOCIAL_EXCEPTION_CAUGHT = "An exception occurred while processing your request";
        }

        @YamlConfig.Comment(value={"GeoIP is an offline database providing approximate IP address locations", "In the SocialAddon's case, the IP location is displayed in notifications and alerts"})
        public static class GEOIP {
            public boolean ENABLED = false;
            @YamlConfig.Comment(value={"Available placeholders: {CITY}, {COUNTRY}, {LEAST_SPECIFIC_SUBDIVISION}, {MOST_SPECIFIC_SUBDIVISION}"})
            @YamlConfig.Placeholders(value={"{CITY}", "{COUNTRY}", "{LEAST_SPECIFIC_SUBDIVISION}", "{MOST_SPECIFIC_SUBDIVISION}"})
            public String FORMAT = "{CITY}, {COUNTRY}";
            @YamlConfig.Comment(value={"ISO 639-1"})
            public String LOCALE = "en";
            @YamlConfig.Comment(value={"MaxMind license key", "Regenerate if triggers an error"})
            public String LICENSE_KEY = "P5g0fVdAQIq8yQau";
            @YamlConfig.Comment(value={"The interval at which the database will be updated, in milliseconds", "Default value: 14 days"})
            public long UPDATE_INTERVAL = 1209600000L;
            public String DEFAULT_VALUE = "Unknown";
            @YamlConfig.Comment(value={"It is not necessary to change {LICENSE_KEY}"})
            @YamlConfig.Placeholders(value={"{LICENSE_KEY}"})
            public String MMDB_CITY_DOWNLOAD = "https://download.maxmind.com/app/geoip_download?edition_id=GeoLite2-City&license_key={LICENSE_KEY}&suffix=tar.gz";
            @YamlConfig.Placeholders(value={"{LICENSE_KEY}"})
            public String MMDB_COUNTRY_DOWNLOAD = "https://download.maxmind.com/app/geoip_download?edition_id=GeoLite2-Country&license_key={LICENSE_KEY}&suffix=tar.gz";
        }

        public static class TELEGRAM {
            public boolean ENABLED = false;
            public String TOKEN = "1234567890";
        }

        public static class DISCORD {
            public boolean ENABLED = false;
            public String TOKEN = "1234567890";
            @YamlConfig.Comment(value={"Available: ", "addrole <role id>", "remrole <role id>", "", "Example: ", "on-player-added: ", " - addrole 12345678", "on-player-removed: ", " - remrole 12345678"})
            public List<String> ON_PLAYER_ADDED = List.of();
            public List<String> ON_PLAYER_REMOVED = List.of();
            public boolean ACTIVITY_ENABLED = true;
            @YamlConfig.Comment(value={"Available values: PLAYING, STREAMING, LISTENING, WATCHING, COMPETING"})
            public Activity.ActivityType ACTIVITY_TYPE = Activity.ActivityType.PLAYING;
            @YamlConfig.Comment(value={"Activity URL. Supported only with activity-type: STREAMING"})
            public String ACTIVITY_URL = null;
            public String ACTIVITY_NAME = "LimboAuth Social Addon";
            @YamlConfig.Comment(value={"Which role ids a player must have on the Discord server to use the bot", "", "Example: ", "required-roles: ", " - 1234567890"})
            public List<Object> REQUIRED_ROLES = List.of();
            @YamlConfig.Comment(value={"It's better to keep this option enabled if you have set required-roles config option", "Requires SERVER MEMBERS INTENT to be enabled in the bot settings on the Discord Developer Portal"})
            public boolean GUILD_MEMBER_CACHE_ENABLED = false;
            public String NO_ROLES_MESSAGE = "You don't have permission to use commands";
        }

        public static class VK {
            public boolean ENABLED = false;
            public String TOKEN = "1234567890";
        }
    }
}

