/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.command;

import com.velocitypowered.api.command.CommandInvocation;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import net.elytrium.limboapi.thirdparty.commons.config.Placeholders;
import net.elytrium.limboauth.socialaddon.Addon;
import net.elytrium.limboauth.socialaddon.Settings;

public class ValidateLinkCommand
implements SimpleCommand {
    private final Addon addon;

    public ValidateLinkCommand(Addon addon) {
        this.addon = addon;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        String[] args = (String[])invocation.arguments();
        if (source instanceof Player) {
            Player player = (Player)source;
            if (args.length == 0) {
                this.sendUsage(player);
            } else {
                try {
                    String username = player.getUsername().toLowerCase(Locale.ROOT);
                    Integer validCode = this.addon.getCode(username);
                    if (validCode != null) {
                        if (validCode == Integer.parseInt(args[0])) {
                            Addon.TempAccount tempAccount = this.addon.getTempAccount(username);
                            this.addon.linkSocial(username, tempAccount.getDbField(), tempAccount.getId());
                            this.addon.getSocialManager().registerHook(tempAccount.getDbField(), tempAccount.getId());
                            this.addon.getSocialManager().broadcastMessage(tempAccount.getDbField(), tempAccount.getId(), Settings.IMP.MAIN.STRINGS.LINK_SUCCESS, this.addon.getKeyboard());
                            player.sendMessage(Addon.getSerializer().deserialize(Settings.IMP.MAIN.STRINGS.LINK_SUCCESS_GAME));
                        } else {
                            source.sendMessage(Addon.getSerializer().deserialize(Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.LINK_WRONG_CODE, (Object[])new Object[]{player.getUsername()})));
                        }
                        this.addon.removeCode(username);
                    } else {
                        this.sendUsage(player);
                    }
                }
                catch (NumberFormatException ignored) {
                    this.sendUsage(player);
                }
                catch (SQLException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
    }

    private void sendUsage(Player player) {
        player.sendMessage(Addon.getSerializer().deserialize(Placeholders.replace((String)Settings.IMP.MAIN.STRINGS.LINK_CMD_USAGE, (Object[])new Object[]{player.getUsername()})));
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        return super.suggest((CommandInvocation)invocation);
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return super.hasPermission((CommandInvocation)invocation);
    }
}

