/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.social;

import java.util.Collections;
import java.util.List;
import net.elytrium.limboauth.socialaddon.model.SocialPlayer;
import net.elytrium.limboauth.socialaddon.social.SocialButtonListener;
import net.elytrium.limboauth.socialaddon.social.SocialInitializationException;
import net.elytrium.limboauth.socialaddon.social.SocialMessageListener;

public abstract class AbstractSocial {
    private final SocialMessageListener onMessageReceived;
    private final SocialButtonListener onButtonClicked;

    protected AbstractSocial(SocialMessageListener onMessageReceived, SocialButtonListener onButtonClicked) {
        this.onMessageReceived = onMessageReceived;
        this.onButtonClicked = onButtonClicked;
    }

    protected void proceedMessage(String dbField, Long id, String message) {
        this.onMessageReceived.accept(dbField, id, message);
    }

    protected void proceedButton(String dbField, Long id, String message) {
        this.onButtonClicked.accept(dbField, id, message);
    }

    public abstract boolean isEnabled();

    public abstract void start() throws SocialInitializationException;

    public abstract void stop();

    public abstract String getDbField();

    public abstract void onPlayerAdded(Long var1);

    public abstract void onPlayerRemoved(SocialPlayer var1);

    public void sendMessage(Long id, String content) {
        this.sendMessage(id, content, Collections.emptyList(), ButtonVisibility.DEFAULT);
    }

    public abstract void sendMessage(Long var1, String var2, List<List<ButtonItem>> var3, ButtonVisibility var4);

    public void sendMessage(SocialPlayer player, String content) {
        this.sendMessage(player, content, Collections.emptyList(), ButtonVisibility.DEFAULT);
    }

    public abstract void sendMessage(SocialPlayer var1, String var2, List<List<ButtonItem>> var3, ButtonVisibility var4);

    public abstract boolean canSend(SocialPlayer var1);

    public static enum ButtonVisibility {
        DEFAULT,
        PREFER_INLINE,
        PREFER_KEYBOARD;

    }

    public static interface Constructor {
        public AbstractSocial newInstance(SocialMessageListener var1, SocialButtonListener var2) throws SocialInitializationException;
    }

    public static class ButtonItem {
        private final String id;
        private final String value;
        private final Color color;

        public ButtonItem(String id, String value, Color color) {
            this.id = id;
            this.value = value;
            this.color = color;
        }

        public String getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }

        public Color getColor() {
            return this.color;
        }

        public static enum Color {
            GREEN,
            RED,
            PRIMARY,
            SECONDARY,
            LINK;

        }
    }
}

