/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.social;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.security.auth.login.LoginException;
import net.elytrium.limboauth.socialaddon.Settings;
import net.elytrium.limboauth.socialaddon.model.SocialPlayer;
import net.elytrium.limboauth.socialaddon.social.AbstractSocial;
import net.elytrium.limboauth.socialaddon.social.SocialButtonListener;
import net.elytrium.limboauth.socialaddon.social.SocialInitializationException;
import net.elytrium.limboauth.socialaddon.social.SocialMessageListener;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.JDA;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.JDABuilder;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.Activity;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.Member;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.Role;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.User;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.components.ActionRow;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.requests.GatewayIntent;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.cache.CacheFlag;
import org.jetbrains.annotations.NotNull;

public class DiscordSocial
extends AbstractSocial {
    private JDA jda;
    private List<RoleAction> onPlayerAddedRoleActions;
    private List<RoleAction> onPlayerRemovedRoleActions;

    public DiscordSocial(SocialMessageListener onMessageReceived, SocialButtonListener onButtonClicked) {
        super(onMessageReceived, onButtonClicked);
    }

    @Override
    public void start() throws SocialInitializationException {
        try {
            JDABuilder jdaBuilder = Settings.IMP.MAIN.DISCORD.GUILD_MEMBER_CACHE_ENABLED ? JDABuilder.create(Settings.IMP.MAIN.DISCORD.TOKEN, GatewayIntent.DIRECT_MESSAGES, GatewayIntent.GUILD_MEMBERS) : JDABuilder.create(Settings.IMP.MAIN.DISCORD.TOKEN, GatewayIntent.DIRECT_MESSAGES, new GatewayIntent[0]);
            this.jda = jdaBuilder.disableCache(CacheFlag.ACTIVITY, CacheFlag.VOICE_STATE, CacheFlag.EMOTE, CacheFlag.CLIENT_STATUS, CacheFlag.ONLINE_STATUS).setActivity(Settings.IMP.MAIN.DISCORD.ACTIVITY_ENABLED ? Activity.of(Settings.IMP.MAIN.DISCORD.ACTIVITY_TYPE, Settings.IMP.MAIN.DISCORD.ACTIVITY_NAME, Settings.IMP.MAIN.DISCORD.ACTIVITY_URL) : null).build().awaitReady();
        }
        catch (InterruptedException | LoginException e2) {
            throw new SocialInitializationException(e2);
        }
        this.jda.addEventListener(new Listener(this.jda, this::proceedMessage, this::proceedButton));
        this.onPlayerAddedRoleActions = Settings.IMP.MAIN.DISCORD.ON_PLAYER_ADDED.stream().map(e -> e.split(" ")).map(x$0 -> new RoleAction((String[])x$0)).collect(Collectors.toList());
        this.onPlayerRemovedRoleActions = Settings.IMP.MAIN.DISCORD.ON_PLAYER_REMOVED.stream().map(e -> e.split(" ")).map(x$0 -> new RoleAction((String[])x$0)).collect(Collectors.toList());
    }

    @Override
    public boolean isEnabled() {
        return Settings.IMP.MAIN.DISCORD.ENABLED;
    }

    @Override
    public void stop() {
        if (this.jda != null) {
            this.jda.shutdown();
        }
    }

    @Override
    public String getDbField() {
        return "DISCORD_ID";
    }

    @Override
    public void onPlayerAdded(Long id) {
        this.onPlayerAddedRoleActions.forEach(action -> action.doAction(id));
    }

    @Override
    public void onPlayerRemoved(SocialPlayer player) {
        this.onPlayerRemovedRoleActions.forEach(action -> action.doAction(player.getDiscordID()));
    }

    @Override
    public void sendMessage(Long id, String content, List<List<AbstractSocial.ButtonItem>> buttons, AbstractSocial.ButtonVisibility visibility) {
        User user = this.jda.retrieveUserById(id).complete();
        if (user == null) {
            return;
        }
        List actionRowList = buttons.stream().map(row -> ActionRow.of(row.stream().map(e -> Button.of(switch (e.getColor()) {
            case AbstractSocial.ButtonItem.Color.RED -> ButtonStyle.DANGER;
            case AbstractSocial.ButtonItem.Color.GREEN -> ButtonStyle.SUCCESS;
            case AbstractSocial.ButtonItem.Color.LINK -> ButtonStyle.LINK;
            case AbstractSocial.ButtonItem.Color.PRIMARY -> ButtonStyle.PRIMARY;
            default -> ButtonStyle.SECONDARY;
        }, e.getId(), e.getValue())).collect(Collectors.toList()))).collect(Collectors.toList());
        ((CompletableFuture)user.openPrivateChannel().submit().thenAccept(privateChannel -> privateChannel.sendMessage(content).setActionRows(actionRowList).submit().exceptionally(e -> {
            if (Settings.IMP.MAIN.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }))).exceptionally(e -> {
            if (Settings.IMP.MAIN.DEBUG) {
                e.printStackTrace();
            }
            return null;
        });
    }

    @Override
    public void sendMessage(SocialPlayer player, String content, List<List<AbstractSocial.ButtonItem>> buttons, AbstractSocial.ButtonVisibility visibility) {
        this.sendMessage(player.getDiscordID(), content, buttons, visibility);
    }

    @Override
    public boolean canSend(SocialPlayer player) {
        return player.getDiscordID() != null;
    }

    private static class Listener
    extends ListenerAdapter {
        private final List<Role> requiredRoles;
        private final SocialMessageListener onMessageReceived;
        private final SocialButtonListener onButtonClicked;

        @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
        Listener(JDA jda, SocialMessageListener onMessageReceived, SocialButtonListener onButtonClicked) {
            ArrayList<Role> list = new ArrayList<Role>();
            for (Object requiredRole : Settings.IMP.MAIN.DISCORD.REQUIRED_ROLES) {
                Role roleById;
                if (requiredRole instanceof Long) {
                    roleById = jda.getRoleById((Long)requiredRole);
                } else if (requiredRole instanceof String) {
                    roleById = jda.getRoleById((String)requiredRole);
                } else {
                    throw new IllegalArgumentException("Required-roles entry cannot be of class " + requiredRole.getClass().getName());
                }
                if (roleById == null) continue;
                list.add(roleById);
            }
            this.requiredRoles = list;
            this.onMessageReceived = onMessageReceived;
            this.onButtonClicked = onButtonClicked;
        }

        @Override
        public void onMessageReceived(@NotNull MessageReceivedEvent event) {
            User user = event.getAuthor();
            if (user.getIdLong() == event.getJDA().getSelfUser().getIdLong()) {
                return;
            }
            for (Role role : this.requiredRoles) {
                Member member = role.getGuild().retrieveMember(user).complete();
                if (member != null && member.getRoles().contains(role)) continue;
                user.openPrivateChannel().submit().thenAccept(privateChannel -> privateChannel.sendMessage(Settings.IMP.MAIN.DISCORD.NO_ROLES_MESSAGE).queue());
                return;
            }
            this.onMessageReceived.accept("DISCORD_ID", event.getAuthor().getIdLong(), event.getMessage().getContentRaw());
        }

        @Override
        public void onButtonInteraction(@NotNull ButtonInteractionEvent event) {
            event.deferEdit().queue();
            this.onButtonClicked.accept("DISCORD_ID", event.getUser().getIdLong(), event.getButton().getId());
        }
    }

    private final class RoleAction {
        private final RoleActionType action;
        private final Role role;

        private RoleAction(String[] serializedAction) {
            this(RoleActionType.valueOf(serializedAction[0].toUpperCase(Locale.ROOT)), serializedAction[1]);
        }

        private RoleAction(RoleActionType action, String roleId) {
            this(action, discordSocial.jda.getRoleById(roleId));
        }

        private RoleAction(RoleActionType action, Role role) {
            this.action = action;
            this.role = role;
        }

        public void doAction(Long id) {
            this.action.doAction(this.role, id);
        }
    }

    private static enum RoleActionType {
        ADDROLE((role, id) -> role.getGuild().addRoleToMember((long)id, (Role)role).queue()),
        REMROLE((role, id) -> role.getGuild().removeRoleFromMember((long)id, (Role)role).queue());

        private final BiConsumer<Role, Long> doAction;

        private RoleActionType(BiConsumer<Role, Long> doAction) {
            this.doAction = doAction;
        }

        public void doAction(Role role, long userId) {
            this.doAction.accept(role, userId);
        }
    }
}

