/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.social;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.stream.Collectors;
import net.elytrium.limboauth.socialaddon.Settings;
import net.elytrium.limboauth.socialaddon.model.SocialPlayer;
import net.elytrium.limboauth.socialaddon.social.AbstractSocial;
import net.elytrium.limboauth.socialaddon.social.SocialButtonListener;
import net.elytrium.limboauth.socialaddon.social.SocialInitializationException;
import net.elytrium.limboauth.socialaddon.social.SocialMessageListener;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.bots.TelegramLongPollingBot;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.TelegramBotsApi;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.CallbackQuery;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.Message;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.Update;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboardMarkup;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardButton;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardRow;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.generics.BotSession;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.updatesreceivers.DefaultBotSession;

public class TelegramSocial
extends AbstractSocial {
    private final TelegramBotsApi api;
    private TGBot bot;
    private BotSession botSession;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public TelegramSocial(SocialMessageListener onMessageReceived, SocialButtonListener onButtonClicked) throws SocialInitializationException {
        super(onMessageReceived, onButtonClicked);
        try {
            this.api = new TelegramBotsApi(DefaultBotSession.class);
        }
        catch (TelegramApiException e) {
            throw new SocialInitializationException(e);
        }
    }

    @Override
    public boolean isEnabled() {
        return Settings.IMP.MAIN.TELEGRAM.ENABLED;
    }

    @Override
    public void start() throws SocialInitializationException {
        try {
            this.bot = new TGBot(Settings.IMP.MAIN.TELEGRAM.TOKEN, this::proceedMessage, this::proceedButton);
            this.botSession = this.api.registerBot(this.bot);
        }
        catch (TelegramApiException e) {
            throw new SocialInitializationException(e);
        }
    }

    @Override
    public void stop() {
        if (this.botSession != null) {
            this.botSession.stop();
        }
    }

    @Override
    public String getDbField() {
        return "TELEGRAM_ID";
    }

    @Override
    public void onPlayerAdded(Long id) {
    }

    @Override
    public void onPlayerRemoved(SocialPlayer player) {
    }

    @Override
    public void sendMessage(Long id, String content, List<List<AbstractSocial.ButtonItem>> buttons, AbstractSocial.ButtonVisibility visibility) {
        this.bot.sendMessage(id, content, switch (visibility) {
            case AbstractSocial.ButtonVisibility.PREFER_INLINE -> new InlineKeyboardMarkup(buttons.stream().map(row -> row.stream().map(e -> {
                InlineKeyboardButton button = new InlineKeyboardButton();
                button.setText(e.getValue());
                button.setCallbackData(e.getId());
                return button;
            }).collect(Collectors.toList())).collect(Collectors.toList()));
            default -> new ReplyKeyboardMarkup(buttons.stream().map(row -> new KeyboardRow(row.stream().map(e -> new KeyboardButton(e.getValue())).collect(Collectors.toList()))).collect(Collectors.toList()));
        });
    }

    @Override
    public void sendMessage(SocialPlayer player, String content, List<List<AbstractSocial.ButtonItem>> buttons, AbstractSocial.ButtonVisibility visibility) {
        this.sendMessage(player.getTelegramID(), content, buttons, visibility);
    }

    @Override
    public boolean canSend(SocialPlayer player) {
        return player.getTelegramID() != null;
    }

    private static final class TGBot
    extends TelegramLongPollingBot {
        private final String token;
        private final SocialMessageListener onMessageReceived;
        private final SocialButtonListener onButtonClicked;

        private TGBot(String token, SocialMessageListener onMessageReceived, SocialButtonListener onButtonClicked) {
            this.token = token;
            this.onMessageReceived = onMessageReceived;
            this.onButtonClicked = onButtonClicked;
        }

        @Override
        public String getBotUsername() {
            return "LimboAuth Social Addon";
        }

        @Override
        public String getBotToken() {
            return this.token;
        }

        public void sendMessage(Long id, String content, ReplyKeyboard keyboard) {
            SendMessage sendMessage = new SendMessage();
            sendMessage.setChatId(String.valueOf(id));
            sendMessage.setText(content);
            sendMessage.setReplyMarkup(keyboard);
            try {
                this.sendApiMethod(sendMessage);
            }
            catch (TelegramApiRequestException e) {
                if (Settings.IMP.MAIN.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (TelegramApiException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onUpdateReceived(Update update) {
            CallbackQuery query;
            Message message;
            if (update.hasMessage() && (message = update.getMessage()) != null && message.hasText()) {
                this.onMessageReceived.accept("TELEGRAM_ID", message.getChatId(), message.getText());
            }
            if (update.hasCallbackQuery() && (query = update.getCallbackQuery()) != null) {
                this.onButtonClicked.accept("TELEGRAM_ID", query.getFrom().getId(), query.getData());
            }
        }
    }
}

