/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.social;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.elytrium.limboauth.socialaddon.Settings;
import net.elytrium.limboauth.socialaddon.model.SocialPlayer;
import net.elytrium.limboauth.socialaddon.social.AbstractSocial;
import net.elytrium.limboauth.socialaddon.social.SocialButtonListener;
import net.elytrium.limboauth.socialaddon.social.SocialInitializationException;
import net.elytrium.limboauth.socialaddon.social.SocialMessageListener;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.actions.LongPoll;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.client.VkApiClient;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.client.actors.GroupActor;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.exceptions.ApiException;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.exceptions.ClientException;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.exceptions.LongPollServerKeyExpiredException;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.httpclient.HttpTransportClient;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.objects.callback.longpoll.responses.GetLongPollEventsResponse;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.objects.groups.responses.GetByIdObjectLegacyResponse;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.objects.groups.responses.GetLongPollServerResponse;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.objects.messages.Keyboard;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.objects.messages.KeyboardButton;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.objects.messages.KeyboardButtonAction;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.objects.messages.KeyboardButtonColor;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.objects.messages.TemplateActionTypeNames;

public class VKSocial
extends AbstractSocial {
    private final VkApiClient vk;
    private GroupActor actor;
    private boolean polling;

    public VKSocial(SocialMessageListener onMessageReceived, SocialButtonListener onButtonClicked) {
        super(onMessageReceived, onButtonClicked);
        HttpTransportClient transportClient = new HttpTransportClient();
        this.vk = new VkApiClient(transportClient);
    }

    @Override
    public boolean isEnabled() {
        return Settings.IMP.MAIN.VK.ENABLED;
    }

    @Override
    public void stop() {
        this.polling = false;
    }

    @Override
    public void start() throws SocialInitializationException {
        if (this.polling) {
            return;
        }
        this.polling = true;
        try {
            GroupActor tempActor = new GroupActor(0, Settings.IMP.MAIN.VK.TOKEN);
            int groupId = ((GetByIdObjectLegacyResponse)((List)this.vk.groups().getByIdObjectLegacy(tempActor).groupIds(Collections.emptyList()).execute()).get(0)).getId();
            this.actor = new GroupActor(groupId, Settings.IMP.MAIN.VK.TOKEN);
            this.vk.groups().setLongPollSettings(this.actor, groupId).enabled(true).messageEvent(true).messageNew(true).execute();
        }
        catch (ApiException | ClientException e) {
            throw new SocialInitializationException(e);
        }
        new Thread(() -> {
            while (this.polling) {
                try {
                    GetLongPollServerResponse serverInfo = (GetLongPollServerResponse)this.vk.groups().getLongPollServer(this.actor, (int)this.actor.getGroupId()).execute();
                    LongPoll longPoll = new LongPoll(this.vk);
                    String server = serverInfo.getServer();
                    String key = serverInfo.getKey();
                    String ts = serverInfo.getTs();
                    while (this.polling) {
                        GetLongPollEventsResponse longPollResponse = (GetLongPollEventsResponse)longPoll.getEvents(server, key, ts).waitTime(25).execute();
                        ts = longPollResponse.getTs();
                        longPollResponse.getUpdates().forEach(e -> {
                            if (e.has("type") && e.has("object")) {
                                String type = e.get("type").getAsString();
                                JsonObject object = e.get("object").getAsJsonObject();
                                if (object != null) {
                                    switch (type) {
                                        case "message_new": {
                                            this.onMessageNew(object);
                                            break;
                                        }
                                        case "message_event": {
                                            this.onMessageEvent(object);
                                            break;
                                        }
                                    }
                                }
                            }
                        });
                    }
                }
                catch (LongPollServerKeyExpiredException serverInfo) {
                }
                catch (ApiException | ClientException e2) {
                    e2.printStackTrace();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }).start();
    }

    @Override
    public String getDbField() {
        return "VK_ID";
    }

    @Override
    public void onPlayerAdded(Long id) {
    }

    @Override
    public void onPlayerRemoved(SocialPlayer player) {
    }

    @Override
    public void sendMessage(Long id, String content, List<List<AbstractSocial.ButtonItem>> buttons, AbstractSocial.ButtonVisibility visibility) {
        block4: {
            List<List<KeyboardButton>> vkButtons = buttons.stream().map(row -> row.stream().map(button -> {
                KeyboardButtonColor color = switch (button.getColor()) {
                    case AbstractSocial.ButtonItem.Color.RED -> KeyboardButtonColor.NEGATIVE;
                    case AbstractSocial.ButtonItem.Color.GREEN -> KeyboardButtonColor.POSITIVE;
                    case AbstractSocial.ButtonItem.Color.SECONDARY, AbstractSocial.ButtonItem.Color.LINK -> KeyboardButtonColor.DEFAULT;
                    default -> KeyboardButtonColor.PRIMARY;
                };
                JsonObject payload = new JsonObject();
                payload.addProperty("button", button.getId());
                return new KeyboardButton().setColor(color).setAction(new KeyboardButtonAction().setType(TemplateActionTypeNames.CALLBACK).setLabel(button.getValue()).setPayload(payload.toString()));
            }).collect(Collectors.toList())).collect(Collectors.toList());
            try {
                if (buttons.isEmpty()) {
                    this.vk.messages().send(this.actor).userId(id.intValue()).message(content).randomId(ThreadLocalRandom.current().nextInt()).execute();
                } else {
                    Keyboard keyboard = new Keyboard().setButtons(vkButtons).setInline(visibility == AbstractSocial.ButtonVisibility.PREFER_INLINE).setOneTime(false);
                    this.vk.messages().send(this.actor).userId(id.intValue()).message(content).keyboard(keyboard).randomId(ThreadLocalRandom.current().nextInt()).execute();
                }
            }
            catch (ApiException | ClientException e) {
                if (!Settings.IMP.MAIN.DEBUG) break block4;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void sendMessage(SocialPlayer player, String content, List<List<AbstractSocial.ButtonItem>> buttons, AbstractSocial.ButtonVisibility visibility) {
        this.sendMessage(player.getVkID(), content, buttons, visibility);
    }

    @Override
    public boolean canSend(SocialPlayer player) {
        return player.getVkID() != null;
    }

    public void onMessageNew(JsonObject messageNew) {
        JsonObject message;
        if (messageNew.has("message") && (message = messageNew.get("message").getAsJsonObject()).has("text")) {
            this.proceedMessage("VK_ID", message.get("from_id").getAsLong(), message.get("text").getAsString());
        }
    }

    public void onMessageEvent(JsonObject messageEvent) {
        if (messageEvent.has("payload")) {
            JsonObject payload = messageEvent.get("payload").getAsJsonObject();
            String eventId = messageEvent.get("event_id").getAsString();
            int userId = messageEvent.get("user_id").getAsInt();
            int peerId = messageEvent.get("peer_id").getAsInt();
            try {
                this.vk.messages().sendMessageEventAnswer(this.actor, eventId, userId, peerId).execute();
            }
            catch (ApiException | ClientException e) {
                e.printStackTrace();
            }
            if (payload.has("button")) {
                this.proceedButton("VK_ID", Long.valueOf(userId), payload.get("button").getAsString());
            }
        }
    }
}

