/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.deserializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.objects.GroupAuthResponse;

public class GroupAuthResponseDeserializer
implements JsonDeserializer {
    private static final String ACCESS_TOKEN_PREFIX = "access_token_";

    public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("invalid json");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        HashMap<Integer, String> accessTokens = new HashMap<Integer, String>();
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            if (!entry.getKey().startsWith(ACCESS_TOKEN_PREFIX)) continue;
            Integer groupId = Integer.parseInt(entry.getKey().substring(ACCESS_TOKEN_PREFIX.length()));
            accessTokens.put(groupId, entry.getValue().getAsString());
        }
        String error = null;
        if (jsonObject.has("error")) {
            error = jsonObject.get("error").getAsString();
        }
        return new GroupAuthResponse(accessTokens, jsonObject.get("expires_in").getAsInt(), error);
    }
}

