/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.httpclient;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.client.ClientResponse;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.client.TransportClient;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.httpclient.ConnectionsSupervisor;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.httpclient.HttpDeleteWithBody;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransportClient
implements TransportClient {
    protected static final Logger LOG = LoggerFactory.getLogger(HttpTransportClient.class);
    protected static final String ENCODING = "UTF-8";
    protected static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded";
    protected static final String CONTENT_TYPE_HEADER = "Content-Type";
    protected static final String USER_AGENT = "Java VK SDK/1.0";
    protected static final String EMPTY_PAYLOAD = "-";
    protected static final int MAX_SIMULTANEOUS_CONNECTIONS = 300;
    protected static final int DEFAULT_RETRY_ATTEMPTS_NETWORK_ERROR_COUNT = 3;
    protected static final int DEFAULT_RETRY_INVALID_STATUS_COUNT = 3;
    protected static final int FULL_CONNECTION_TIMEOUT_S = 60;
    protected static final int CONNECTION_TIMEOUT_MS = 5000;
    protected static final int SOCKET_TIMEOUT_MS = 60000;
    protected static final ConnectionsSupervisor SUPERVISOR = new ConnectionsSupervisor();
    protected static HttpTransportClient instance;
    protected static HttpClient httpClient;
    protected int retryAttemptsNetworkErrorCount;
    protected int retryAttemptsInvalidStatusCount;

    public HttpTransportClient() {
        this(3, 3);
    }

    public HttpTransportClient(int retryAttemptsNetworkErrorCount, int retryAttemptsInvalidStatusCount) {
        this.retryAttemptsNetworkErrorCount = retryAttemptsNetworkErrorCount;
        this.retryAttemptsInvalidStatusCount = retryAttemptsInvalidStatusCount;
        BasicCookieStore cookieStore = new BasicCookieStore();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).setCookieSpec("standard").build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(300);
        connectionManager.setDefaultMaxPerRoute(300);
        httpClient = HttpClients.custom().setConnectionManager(connectionManager).setDefaultRequestConfig(requestConfig).setDefaultCookieStore(cookieStore).setUserAgent(USER_AGENT).build();
    }

    public static HttpTransportClient getInstance() {
        if (instance == null) {
            instance = new HttpTransportClient();
        }
        return instance;
    }

    protected static Map<String, String> getHeaders(Header[] headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Header header : headers) {
            result.put(header.getName(), header.getValue());
        }
        return result;
    }

    protected ClientResponse callWithStatusCheck(HttpRequestBase request) throws IOException {
        ClientResponse response;
        int attempts = 0;
        do {
            response = this.call(request);
        } while (++attempts < this.retryAttemptsInvalidStatusCount && this.isInvalidGatewayStatus(response.getStatusCode()));
        return response;
    }

    protected boolean isInvalidGatewayStatus(int status) {
        return status == 502 || status == 504;
    }

    protected ClientResponse call(HttpRequestBase request) throws IOException {
        SocketException exception = null;
        int i = 0;
        while (i < this.retryAttemptsNetworkErrorCount) {
            ClientResponse clientResponse;
            block12: {
                SUPERVISOR.addRequest(request);
                long startTime = System.currentTimeMillis();
                HttpResponse response = httpClient.execute(request);
                long endTime = System.currentTimeMillis();
                long resultTime = endTime - startTime;
                InputStream content = response.getEntity().getContent();
                try {
                    String result = IOUtils.toString(content, ENCODING);
                    Map<String, String> responseHeaders = HttpTransportClient.getHeaders(response.getAllHeaders());
                    Map<String, String> requestHeaders = HttpTransportClient.getHeaders(request.getAllHeaders());
                    this.logRequest(request, requestHeaders, response, responseHeaders, result, resultTime);
                    clientResponse = new ClientResponse(response.getStatusLine().getStatusCode(), result, responseHeaders);
                    if (content == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (content != null) {
                                try {
                                    content.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            SUPERVISOR.removeRequest(request);
                            throw throwable3;
                        }
                    }
                    catch (SocketException e) {
                        this.logRequest(request);
                        LOG.warn("Network troubles", (Throwable)e);
                        exception = e;
                        ++i;
                    }
                }
                content.close();
            }
            SUPERVISOR.removeRequest(request);
            return clientResponse;
        }
        throw exception;
    }

    protected void logRequest(HttpRequestBase request) throws IOException {
        this.logRequest(request, null, null, null, null, null);
    }

    protected String getRequestPayload(HttpRequestBase request) throws IOException {
        String contentType;
        if (!(request instanceof HttpPost)) {
            return EMPTY_PAYLOAD;
        }
        HttpPost postRequest = (HttpPost)request;
        if (postRequest.getEntity() == null) {
            return EMPTY_PAYLOAD;
        }
        if (StringUtils.isNotEmpty(postRequest.getEntity().getContentType().getValue()) && (contentType = postRequest.getEntity().getContentType().getValue()).contains("multipart/form-data")) {
            return EMPTY_PAYLOAD;
        }
        return IOUtils.toString(postRequest.getEntity().getContent(), StandardCharsets.UTF_8);
    }

    protected void logRequest(HttpRequestBase request, Map<String, String> requestHeaders, HttpResponse response, Map<String, String> responseHeaders, String body, Long time) throws IOException {
        if (LOG.isDebugEnabled()) {
            String payload = this.getRequestPayload(request);
            StringBuilder builder = new StringBuilder("\n").append("Request:\n").append("\t").append("Headers: ").append(requestHeaders != null ? requestHeaders : EMPTY_PAYLOAD).append("\n").append("\t").append("Method: ").append(request.getMethod()).append("\n").append("\t").append("URI: ").append(request.getURI()).append("\n").append("\t").append("Payload: ").append(payload).append("\n").append("\t").append("Time: ").append(time != null ? time : EMPTY_PAYLOAD).append("\n");
            if (response != null) {
                builder.append("Response:\n").append("\t").append("Status: ").append(response.getStatusLine().toString()).append("\n").append("\t").append("Headers: ").append(responseHeaders != null ? responseHeaders : EMPTY_PAYLOAD).append("\n").append("\t").append("Body: ").append(body != null ? body : EMPTY_PAYLOAD).append("\n");
            }
            LOG.debug(builder.toString());
        } else if (LOG.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder().append("Request: ").append(request.getURI().toURL().toString());
            if (time != null) {
                builder.append("\t\t").append(time);
            }
            LOG.info(builder.toString());
        }
    }

    @Override
    public ClientResponse get(String url) throws IOException {
        return this.get(url, FORM_CONTENT_TYPE);
    }

    @Override
    public ClientResponse get(String url, String contentType) throws IOException {
        HttpGet request = new HttpGet(url);
        request.setHeader(CONTENT_TYPE_HEADER, contentType);
        return this.callWithStatusCheck(request);
    }

    @Override
    public ClientResponse get(String url, Header[] headers) throws IOException {
        HttpGet request = new HttpGet(url);
        request.setHeader(CONTENT_TYPE_HEADER, FORM_CONTENT_TYPE);
        for (Header header : headers) {
            request.setHeader(header);
        }
        return this.callWithStatusCheck(request);
    }

    @Override
    public ClientResponse post(String url) throws IOException {
        return this.post(url, null);
    }

    @Override
    public ClientResponse post(String url, String body) throws IOException {
        return this.post(url, body, FORM_CONTENT_TYPE);
    }

    @Override
    public ClientResponse post(String url, String body, String contentType) throws IOException {
        HttpPost request = new HttpPost(url);
        request.setHeader(CONTENT_TYPE_HEADER, contentType);
        if (body != null) {
            request.setEntity(new StringEntity(body, ENCODING));
        }
        return this.callWithStatusCheck(request);
    }

    @Override
    public ClientResponse post(String url, String body, Header[] headers) throws IOException {
        HttpPost request = new HttpPost(url);
        request.setHeader(CONTENT_TYPE_HEADER, FORM_CONTENT_TYPE);
        for (Header header : headers) {
            request.setHeader(header);
        }
        if (body != null) {
            request.setEntity(new StringEntity(body, ENCODING));
        }
        return this.callWithStatusCheck(request);
    }

    @Override
    public ClientResponse post(String url, String fileName, File file) throws IOException {
        HttpPost request = new HttpPost(url);
        FileBody fileBody = new FileBody(file);
        HttpEntity entity = MultipartEntityBuilder.create().addPart(fileName, fileBody).build();
        request.setEntity(entity);
        return this.callWithStatusCheck(request);
    }

    @Override
    public ClientResponse delete(String url) throws IOException {
        return this.delete(url, null, FORM_CONTENT_TYPE);
    }

    @Override
    public ClientResponse delete(String url, String body) throws IOException {
        return this.delete(url, body, FORM_CONTENT_TYPE);
    }

    @Override
    public ClientResponse delete(String url, String body, String contentType) throws IOException {
        HttpDeleteWithBody request = new HttpDeleteWithBody(url);
        request.setHeader(CONTENT_TYPE_HEADER, contentType);
        if (body != null) {
            request.setEntity(new StringEntity(body));
        }
        return this.callWithStatusCheck(request);
    }

    @Override
    public ClientResponse delete(String url, String body, Header[] headers) throws IOException {
        HttpDeleteWithBody request = new HttpDeleteWithBody(url);
        request.setHeader(CONTENT_TYPE_HEADER, FORM_CONTENT_TYPE);
        for (Header header : headers) {
            request.setHeader(header);
        }
        if (body != null) {
            request.setEntity(new StringEntity(body));
        }
        return this.callWithStatusCheck(request);
    }
}

