/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.queries.upload;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.client.ApiRequest;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.client.ClientResponse;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.client.VkApiClient;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.exceptions.ApiException;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.exceptions.ClientException;
import net.elytrium.limboauth.socialaddon.thirdparty.com.vk.api.sdk.exceptions.UploadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UploadQueryBuilder<T, R>
extends ApiRequest<R> {
    private static final Logger LOG = LoggerFactory.getLogger(UploadQueryBuilder.class);
    private String filename;
    private File file;

    public UploadQueryBuilder(VkApiClient client, String uploadUrl, String filename, Type type) {
        super(uploadUrl, client.getTransportClient(), client.getGson(), 0, type);
        this.filename = filename;
    }

    public T file(File value) {
        this.file = value;
        return this.getThis();
    }

    protected abstract T getThis();

    @Override
    public R execute() throws ApiException, ClientException {
        String textResponse = this.executeAsString();
        JsonReader jsonReader = new JsonReader(new StringReader(textResponse));
        JsonObject json = (JsonObject)new JsonParser().parse(jsonReader);
        if (json.has("error")) {
            UploadException uploadException = new UploadException(0, textResponse, "");
            LOG.error("API error", (Throwable)uploadException);
            throw uploadException;
        }
        if (json.has("response")) {
            json = json.get("response").getAsJsonObject();
        }
        try {
            return (R)this.getGson().fromJson((JsonElement)json, this.getResponseClass());
        }
        catch (JsonSyntaxException e) {
            LOG.error("Invalid JSON: " + textResponse, (Throwable)e);
            throw new ClientException("Can't parse json response");
        }
    }

    @Override
    public String executeAsString() throws ClientException {
        ClientResponse response;
        try {
            response = this.file != null ? this.getClient().post(this.getUrl(), this.filename, this.file) : this.getClient().post(this.getUrl());
        }
        catch (IOException e) {
            LOG.error("Problems with request: " + this.getUrl(), (Throwable)e);
            throw new ClientException("I/O exception");
        }
        if (response.getStatusCode() != 200) {
            LOG.error("Invalid HTTP status " + response.getStatusCode() + " from " + this.getUrl());
            throw new ClientException("Internal API server error");
        }
        return response.getContent();
    }

    @Override
    protected String getBody() {
        throw new UnsupportedOperationException("not supported");
    }
}

