/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.Guild;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.GuildChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.ICopyableChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.IMemberContainer;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.IPermissionContainer;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.IPositionableChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.Member;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.NewsChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.StageChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.TextChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.VoiceChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.managers.channel.concrete.CategoryManager;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.requests.restaction.ChannelAction;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.requests.restaction.order.CategoryOrderAction;

public interface Category
extends GuildChannel,
ICopyableChannel,
IPositionableChannel,
IPermissionContainer,
IMemberContainer {
    @Nonnull
    default public List<GuildChannel> getChannels() {
        ArrayList<ICopyableChannel> channels = new ArrayList<ICopyableChannel>();
        channels.addAll(this.getTextChannels());
        channels.addAll(this.getVoiceChannels());
        channels.addAll(this.getStageChannels());
        channels.addAll(this.getNewsChannels());
        Collections.sort(channels);
        return Collections.unmodifiableList(channels);
    }

    @Nonnull
    default public List<TextChannel> getTextChannels() {
        return Collections.unmodifiableList(this.getGuild().getTextChannelCache().stream().filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Collectors.toList()));
    }

    @Nonnull
    default public List<NewsChannel> getNewsChannels() {
        return Collections.unmodifiableList(this.getGuild().getNewsChannelCache().stream().filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Collectors.toList()));
    }

    @Nonnull
    default public List<VoiceChannel> getVoiceChannels() {
        return Collections.unmodifiableList(this.getGuild().getVoiceChannelCache().stream().filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Collectors.toList()));
    }

    @Nonnull
    default public List<StageChannel> getStageChannels() {
        return Collections.unmodifiableList(this.getGuild().getStageChannelCache().stream().filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Collectors.toList()));
    }

    @Nonnull
    @CheckReturnValue
    public ChannelAction<TextChannel> createTextChannel(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public ChannelAction<VoiceChannel> createVoiceChannel(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public ChannelAction<StageChannel> createStageChannel(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public CategoryOrderAction modifyTextChannelPositions();

    @Nonnull
    @CheckReturnValue
    public CategoryOrderAction modifyVoiceChannelPositions();

    @Override
    @Nonnull
    default public List<Member> getMembers() {
        return Collections.unmodifiableList(this.getChannels().stream().filter(IMemberContainer.class::isInstance).map(IMemberContainer.class::cast).map(IMemberContainer::getMembers).flatMap(Collection::stream).distinct().collect(Collectors.toList()));
    }

    @Nonnull
    public ChannelAction<Category> createCopy(@Nonnull Guild var1);

    @Nonnull
    public ChannelAction<Category> createCopy();

    @Override
    @Nonnull
    public CategoryManager getManager();
}

