/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities;

import java.util.EnumSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.Permission;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.AudioChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.Guild;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.GuildChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.ICategorizableChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.ICopyableChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.IInviteContainer;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.IMemberContainer;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.IPermissionContainer;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.IPositionableChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.Member;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.StageInstance;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.managers.channel.concrete.StageChannelManager;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.requests.RestAction;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.requests.restaction.ChannelAction;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.requests.restaction.StageInstanceAction;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.requests.restaction.StageInstanceActionImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.utils.Checks;

public interface StageChannel
extends GuildChannel,
AudioChannel,
ICategorizableChannel,
ICopyableChannel,
IPositionableChannel,
IPermissionContainer,
IMemberContainer,
IInviteContainer {
    @Nullable
    public StageInstance getStageInstance();

    @Nonnull
    @CheckReturnValue
    default public StageInstanceAction createStageInstance(@Nonnull String topic) {
        EnumSet<Permission> permissions = this.getGuild().getSelfMember().getPermissions(this);
        EnumSet<Permission> required = EnumSet.of(Permission.MANAGE_CHANNEL, Permission.VOICE_MUTE_OTHERS, Permission.VOICE_MOVE_OTHERS);
        for (Permission perm : required) {
            if (permissions.contains((Object)perm)) continue;
            throw new InsufficientPermissionException(this, perm, "You must be a stage moderator to create a stage instance! Missing Permission: " + (Object)((Object)perm));
        }
        return new StageInstanceActionImpl(this).setTopic(topic);
    }

    default public boolean isModerator(@Nonnull Member member) {
        Checks.notNull(member, "Member");
        return member.hasPermission((GuildChannel)this, Permission.MANAGE_CHANNEL, Permission.VOICE_MUTE_OTHERS, Permission.VOICE_MOVE_OTHERS);
    }

    @Nonnull
    public ChannelAction<StageChannel> createCopy(@Nonnull Guild var1);

    @Nonnull
    default public ChannelAction<StageChannel> createCopy() {
        return this.createCopy(this.getGuild());
    }

    @Override
    @Nonnull
    public StageChannelManager getManager();

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> requestToSpeak();

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> cancelRequestToSpeak();
}

