/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.events.message;

import javax.annotation.Nonnull;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.JDA;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.ChannelType;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.Guild;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.GuildChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.GuildMessageChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.MessageChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.NewsChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.PrivateChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.TextChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.ThreadChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.events.Event;

public abstract class GenericMessageEvent
extends Event {
    protected final long messageId;
    protected final MessageChannel channel;

    public GenericMessageEvent(@Nonnull JDA api, long responseNumber, long messageId, @Nonnull MessageChannel channel) {
        super(api, responseNumber);
        this.messageId = messageId;
        this.channel = channel;
    }

    @Nonnull
    public MessageChannel getChannel() {
        return this.channel;
    }

    @Nonnull
    public GuildMessageChannel getGuildChannel() {
        if (!this.isFromGuild()) {
            throw new IllegalStateException("This message event did not happen in a guild");
        }
        return (GuildMessageChannel)this.channel;
    }

    @Nonnull
    public String getMessageId() {
        return Long.toUnsignedString(this.messageId);
    }

    public long getMessageIdLong() {
        return this.messageId;
    }

    public boolean isFromType(@Nonnull ChannelType type) {
        return this.channel.getType() == type;
    }

    public boolean isFromGuild() {
        return this.getChannelType().isGuild();
    }

    @Nonnull
    public ChannelType getChannelType() {
        return this.channel.getType();
    }

    @Nonnull
    public Guild getGuild() {
        if (!this.isFromGuild()) {
            throw new IllegalStateException("This message event did not happen in a guild");
        }
        return ((GuildChannel)((Object)this.channel)).getGuild();
    }

    @Nonnull
    public TextChannel getTextChannel() {
        if (!this.isFromType(ChannelType.TEXT)) {
            throw new IllegalStateException("This message event did not happen in a text channel");
        }
        return (TextChannel)this.channel;
    }

    @Nonnull
    public NewsChannel getNewsChannel() {
        if (!this.isFromType(ChannelType.NEWS)) {
            throw new IllegalStateException("This message event did not happen in a news channel");
        }
        return (NewsChannel)this.channel;
    }

    @Nonnull
    public PrivateChannel getPrivateChannel() {
        if (!this.isFromType(ChannelType.PRIVATE)) {
            throw new IllegalStateException("This message event did not happen in a private channel");
        }
        return (PrivateChannel)this.channel;
    }

    @Nonnull
    public ThreadChannel getThreadChannel() {
        if (!this.isFromThread()) {
            throw new IllegalStateException("This message event did not happen in a thread channel");
        }
        return (ThreadChannel)this.channel;
    }

    public boolean isFromThread() {
        return this.getChannelType().isThread();
    }
}

