/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.commands.build;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.ChannelType;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.commands.Command;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.commands.OptionType;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.data.DataArray;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.data.DataObject;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.data.DataType;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.data.SerializableData;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.utils.Checks;

public class OptionData
implements SerializableData {
    public static final double MAX_POSITIVE_NUMBER = 9.007199254740991E15;
    public static final double MIN_NEGATIVE_NUMBER = -9.007199254740991E15;
    public static final int MAX_NAME_LENGTH = 32;
    public static final int MAX_CHOICE_NAME_LENGTH = 100;
    public static final int MAX_DESCRIPTION_LENGTH = 100;
    public static final int MAX_CHOICE_VALUE_LENGTH = 100;
    public static final int MAX_CHOICES = 25;
    private final OptionType type;
    private String name;
    private String description;
    private boolean isRequired;
    private boolean isAutoComplete;
    private final EnumSet<ChannelType> channelTypes = EnumSet.noneOf(ChannelType.class);
    private Number minValue;
    private Number maxValue;
    private Map<String, Object> choices;

    public OptionData(@Nonnull OptionType type, @Nonnull String name, @Nonnull String description) {
        this(type, name, description, false);
    }

    public OptionData(@Nonnull OptionType type, @Nonnull String name, @Nonnull String description, boolean isRequired) {
        this(type, name, description, isRequired, false);
    }

    public OptionData(@Nonnull OptionType type, @Nonnull String name, @Nonnull String description, boolean isRequired, boolean isAutoComplete) {
        Checks.notNull((Object)type, "Type");
        this.type = type;
        this.setName(name);
        this.setDescription(description);
        this.setRequired(isRequired);
        if (type.canSupportChoices()) {
            this.choices = new LinkedHashMap<String, Object>();
        }
        this.setAutoComplete(isAutoComplete);
    }

    @Nonnull
    public OptionType getType() {
        return this.type;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isAutoComplete() {
        return this.isAutoComplete;
    }

    @Nonnull
    public EnumSet<ChannelType> getChannelTypes() {
        return this.channelTypes;
    }

    @Nullable
    public Number getMinValue() {
        return this.minValue;
    }

    @Nullable
    public Number getMaxValue() {
        return this.maxValue;
    }

    @Nonnull
    public List<Command.Choice> getChoices() {
        if (this.choices == null || this.choices.isEmpty()) {
            return Collections.emptyList();
        }
        return this.choices.entrySet().stream().map(entry -> {
            if (entry.getValue() instanceof String) {
                return new Command.Choice((String)entry.getKey(), entry.getValue().toString());
            }
            if (entry.getValue() instanceof Double) {
                return new Command.Choice((String)entry.getKey(), ((Number)entry.getValue()).doubleValue());
            }
            return new Command.Choice((String)entry.getKey(), ((Number)entry.getValue()).longValue());
        }).collect(Collectors.toList());
    }

    @Nonnull
    public OptionData setName(@Nonnull String name) {
        Checks.notEmpty(name, "Name");
        Checks.notLonger(name, 32, "Name");
        Checks.isLowercase(name, "Name");
        Checks.matches(name, Checks.ALPHANUMERIC_WITH_DASH, "Name");
        this.name = name;
        return this;
    }

    @Nonnull
    public OptionData setDescription(@Nonnull String description) {
        Checks.notEmpty(description, "Description");
        Checks.notLonger(description, 100, "Description");
        this.description = description;
        return this;
    }

    @Nonnull
    public OptionData setRequired(boolean required) {
        this.isRequired = required;
        return this;
    }

    @Nonnull
    public OptionData setAutoComplete(boolean autoComplete) {
        if (autoComplete) {
            if (this.choices == null || !this.type.canSupportChoices()) {
                throw new IllegalStateException("Cannot enable auto-complete for options of type " + (Object)((Object)this.type));
            }
            if (!this.choices.isEmpty()) {
                throw new IllegalStateException("Cannot enable auto-complete for options with choices");
            }
        }
        this.isAutoComplete = autoComplete;
        return this;
    }

    @Nonnull
    public OptionData setChannelTypes(ChannelType ... channelTypes) {
        Checks.noneNull((Object[])channelTypes, "ChannelTypes");
        return this.setChannelTypes(Arrays.asList(channelTypes));
    }

    @Nonnull
    public OptionData setChannelTypes(@Nonnull Collection<ChannelType> channelTypes) {
        if (this.type != OptionType.CHANNEL) {
            throw new IllegalArgumentException("Can only apply channel type restriction to options of type CHANNEL");
        }
        Checks.notNull(channelTypes, "ChannelType collection");
        Checks.noneNull(channelTypes, "ChannelType");
        for (ChannelType channelType : channelTypes) {
            if (channelType.isGuild()) continue;
            throw new IllegalArgumentException("Provided channel type is not a guild channel type. Provided: " + (Object)((Object)channelType));
        }
        this.channelTypes.clear();
        this.channelTypes.addAll(channelTypes);
        return this;
    }

    @Nonnull
    public OptionData setMinValue(long value) {
        if (this.type != OptionType.INTEGER && this.type != OptionType.NUMBER) {
            throw new IllegalArgumentException("Can only set min and max long value for options of type INTEGER or NUMBER");
        }
        Checks.check((double)value >= -9.007199254740991E15, "Long value may not be lower than %f", (Object)-9.007199254740991E15);
        this.minValue = value;
        return this;
    }

    @Nonnull
    public OptionData setMinValue(double value) {
        if (this.type != OptionType.NUMBER) {
            throw new IllegalArgumentException("Can only set min double value for options of type NUMBER");
        }
        Checks.check(value >= -9.007199254740991E15, "Double value may not be lower than %f", (Object)-9.007199254740991E15);
        this.minValue = value;
        return this;
    }

    @Nonnull
    public OptionData setMaxValue(long value) {
        if (this.type != OptionType.INTEGER && this.type != OptionType.NUMBER) {
            throw new IllegalArgumentException("Can only set min and max long value for options of type INTEGER or NUMBER");
        }
        Checks.check((double)value <= 9.007199254740991E15, "Long value may not be larger than %f", (Object)9.007199254740991E15);
        this.maxValue = value;
        return this;
    }

    @Nonnull
    public OptionData setMaxValue(double value) {
        if (this.type != OptionType.NUMBER) {
            throw new IllegalArgumentException("Can only set max double value for options of type NUMBER");
        }
        Checks.check(value <= 9.007199254740991E15, "Double value may not be larger than %f", (Object)9.007199254740991E15);
        this.maxValue = value;
        return this;
    }

    @Nonnull
    public OptionData setRequiredRange(long minValue, long maxValue) {
        if (this.type != OptionType.INTEGER && this.type != OptionType.NUMBER) {
            throw new IllegalArgumentException("Can only set min and max long value for options of type INTEGER or NUMBER");
        }
        Checks.check((double)minValue >= -9.007199254740991E15, "Long value may not be lower than %f", (Object)-9.007199254740991E15);
        Checks.check((double)maxValue <= 9.007199254740991E15, "Long value may not be larger than %f", (Object)9.007199254740991E15);
        this.minValue = minValue;
        this.maxValue = maxValue;
        return this;
    }

    @Nonnull
    public OptionData setRequiredRange(double minValue, double maxValue) {
        if (this.type != OptionType.NUMBER) {
            throw new IllegalArgumentException("Can only set min and max double value for options of type NUMBER");
        }
        Checks.check(minValue >= -9.007199254740991E15, "Double value may not be lower than %f", (Object)-9.007199254740991E15);
        Checks.check(maxValue <= 9.007199254740991E15, "Double value may not be larger than %f", (Object)9.007199254740991E15);
        this.minValue = minValue;
        this.maxValue = maxValue;
        return this;
    }

    @Nonnull
    public OptionData addChoice(@Nonnull String name, double value) {
        Checks.notEmpty(name, "Name");
        Checks.notLonger(name, 100, "Name");
        Checks.check(value >= -9.007199254740991E15, "Double value may not be lower than %f", (Object)-9.007199254740991E15);
        Checks.check(value <= 9.007199254740991E15, "Double value may not be larger than %f", (Object)9.007199254740991E15);
        Checks.check(this.choices.size() < 25, "Cannot have more than 25 choices for an option!");
        if (this.isAutoComplete) {
            throw new IllegalStateException("Cannot add choices to auto-complete options");
        }
        if (this.type != OptionType.NUMBER) {
            throw new IllegalArgumentException("Cannot add double choice for OptionType." + (Object)((Object)this.type));
        }
        this.choices.put(name, value);
        return this;
    }

    @Nonnull
    public OptionData addChoice(@Nonnull String name, long value) {
        Checks.notEmpty(name, "Name");
        Checks.notLonger(name, 100, "Name");
        Checks.check((double)value >= -9.007199254740991E15, "Long value may not be lower than %f", (Object)-9.007199254740991E15);
        Checks.check((double)value <= 9.007199254740991E15, "Long value may not be larger than %f", (Object)9.007199254740991E15);
        Checks.check(this.choices.size() < 25, "Cannot have more than 25 choices for an option!");
        if (this.isAutoComplete) {
            throw new IllegalStateException("Cannot add choices to auto-complete options");
        }
        if (this.type != OptionType.INTEGER) {
            throw new IllegalArgumentException("Cannot add long choice for OptionType." + (Object)((Object)this.type));
        }
        this.choices.put(name, value);
        return this;
    }

    @Nonnull
    public OptionData addChoice(@Nonnull String name, @Nonnull String value) {
        Checks.notEmpty(name, "Name");
        Checks.notEmpty(value, "Value");
        Checks.notLonger(name, 100, "Name");
        Checks.notLonger(value, 100, "Value");
        Checks.check(this.choices.size() < 25, "Cannot have more than 25 choices for an option!");
        if (this.isAutoComplete) {
            throw new IllegalStateException("Cannot add choices to auto-complete options");
        }
        if (this.type != OptionType.STRING) {
            throw new IllegalArgumentException("Cannot add string choice for OptionType." + (Object)((Object)this.type));
        }
        this.choices.put(name, value);
        return this;
    }

    @Nonnull
    public OptionData addChoices(Command.Choice ... choices) {
        if (choices.length == 0) {
            return this;
        }
        if (this.choices == null || !this.type.canSupportChoices()) {
            throw new IllegalStateException("Cannot add choices for an option of type " + (Object)((Object)this.type));
        }
        Checks.noneNull(choices, "Choices");
        if (this.isAutoComplete) {
            throw new IllegalStateException("Cannot add choices to auto-complete options");
        }
        Checks.check(choices.length + this.choices.size() <= 25, "Cannot have more than 25 choices for one option!");
        for (Command.Choice choice : choices) {
            if (this.type == OptionType.INTEGER) {
                this.addChoice(choice.getName(), choice.getAsLong());
                continue;
            }
            if (this.type == OptionType.STRING) {
                this.addChoice(choice.getName(), choice.getAsString());
                continue;
            }
            if (this.type == OptionType.NUMBER) {
                this.addChoice(choice.getName(), choice.getAsDouble());
                continue;
            }
            throw new IllegalArgumentException("Cannot add choice for type " + (Object)((Object)this.type));
        }
        return this;
    }

    @Nonnull
    public OptionData addChoices(@Nonnull Collection<? extends Command.Choice> choices) {
        Checks.noneNull(choices, "Choices");
        return this.addChoices(choices.toArray(new Command.Choice[0]));
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject json = DataObject.empty().put("type", this.type.getKey()).put("name", this.name).put("description", this.description);
        if (this.type != OptionType.SUB_COMMAND && this.type != OptionType.SUB_COMMAND_GROUP) {
            json.put("required", this.isRequired);
            json.put("autocomplete", this.isAutoComplete);
        }
        if (this.choices != null && !this.choices.isEmpty()) {
            json.put("choices", DataArray.fromCollection(this.choices.entrySet().stream().map(entry -> DataObject.empty().put("name", entry.getKey()).put("value", entry.getValue())).collect(Collectors.toList())));
        }
        if (this.type == OptionType.CHANNEL && !this.channelTypes.isEmpty()) {
            json.put("channel_types", this.channelTypes.stream().map(ChannelType::getId).collect(Collectors.toList()));
        }
        if (this.type == OptionType.INTEGER || this.type == OptionType.NUMBER) {
            if (this.minValue != null) {
                json.put("min_value", this.minValue);
            }
            if (this.maxValue != null) {
                json.put("max_value", this.maxValue);
            }
        }
        return json;
    }

    @Nonnull
    public static OptionData fromData(@Nonnull DataObject json) {
        String name = json.getString("name");
        String description = json.getString("description");
        OptionType type = OptionType.fromKey(json.getInt("type"));
        OptionData option = new OptionData(type, name, description);
        option.setRequired(json.getBoolean("required"));
        option.setAutoComplete(json.getBoolean("autocomplete"));
        if (type == OptionType.INTEGER || type == OptionType.NUMBER) {
            if (!json.isNull("min_value")) {
                if (json.isType("min_value", DataType.INT)) {
                    option.setMinValue(json.getLong("min_value"));
                } else if (json.isType("min_value", DataType.FLOAT)) {
                    option.setMinValue(json.getDouble("min_value"));
                }
            }
            if (!json.isNull("max_value")) {
                if (json.isType("max_value", DataType.INT)) {
                    option.setMaxValue(json.getLong("max_value"));
                } else if (json.isType("max_value", DataType.FLOAT)) {
                    option.setMaxValue(json.getDouble("max_value"));
                }
            }
        }
        if (type == OptionType.CHANNEL) {
            option.setChannelTypes(json.optArray("channel_types").map(it -> it.stream(DataArray::getInt).map(ChannelType::fromId).collect(Collectors.toSet())).orElse(Collections.emptySet()));
        }
        json.optArray("choices").ifPresent(choices1 -> choices1.stream(DataArray::getObject).forEach(o -> {
            if (o.isType("value", DataType.FLOAT)) {
                option.addChoice(o.getString("name"), o.getDouble("value"));
            } else if (o.isType("value", DataType.INT)) {
                option.addChoice(o.getString("name"), o.getLong("value"));
            } else {
                option.addChoice(o.getString("name"), o.get("value").toString());
            }
        }));
        return option;
    }

    @Nonnull
    public static OptionData fromOption(@Nonnull Command.Option option) {
        Checks.notNull(option, "Option");
        OptionData data = new OptionData(option.getType(), option.getName(), option.getDescription());
        data.setRequired(option.isRequired());
        data.setAutoComplete(option.isAutoComplete());
        data.addChoices(option.getChoices());
        Number min = option.getMinValue();
        Number max = option.getMaxValue();
        switch (option.getType()) {
            case CHANNEL: {
                data.setChannelTypes(option.getChannelTypes());
                break;
            }
            case NUMBER: {
                if (min != null) {
                    data.setMinValue(min.doubleValue());
                }
                if (max == null) break;
                data.setMaxValue(max.doubleValue());
                break;
            }
            case INTEGER: {
                if (min != null) {
                    data.setMinValue(min.longValue());
                }
                if (max == null) break;
                data.setMaxValue(max.longValue());
            }
        }
        return data;
    }
}

