/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.commands.build;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.commands.Command;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.commands.OptionType;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.data.DataArray;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.data.DataObject;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.data.SerializableData;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.utils.Checks;

public class SubcommandData
implements SerializableData {
    protected final DataArray options = DataArray.empty();
    protected String name;
    protected String description;
    private boolean allowRequired = true;

    public SubcommandData(@Nonnull String name, @Nonnull String description) {
        this.setName(name);
        this.setDescription(description);
    }

    @Nonnull
    public SubcommandData setName(@Nonnull String name) {
        Checks.inRange(name, 1, 32, "Name");
        Checks.matches(name, Checks.ALPHANUMERIC_WITH_DASH, "Name");
        Checks.isLowercase(name, "Name");
        this.name = name;
        return this;
    }

    @Nonnull
    public SubcommandData setDescription(@Nonnull String description) {
        Checks.notEmpty(description, "Description");
        Checks.notLonger(description, 100, "Description");
        this.description = description;
        return this;
    }

    @Nonnull
    public SubcommandData addOptions(OptionData ... options) {
        Checks.noneNull(options, "Option");
        Checks.check(options.length + this.options.length() <= 25, "Cannot have more than 25 options for a subcommand!");
        boolean allowRequired = this.allowRequired;
        for (OptionData option : options) {
            Checks.check(option.getType() != OptionType.SUB_COMMAND, "Cannot add a subcommand to a subcommand!");
            Checks.check(option.getType() != OptionType.SUB_COMMAND_GROUP, "Cannot add a subcommand group to a subcommand!");
            Checks.check(allowRequired || !option.isRequired(), "Cannot add required options after non-required options!");
            allowRequired = option.isRequired();
        }
        Checks.checkUnique(Stream.concat(this.getOptions().stream(), Arrays.stream(options)).map(OptionData::getName), "Cannot have multiple options with the same name. Name: \"%s\" appeared %d times!", (count, value) -> new Object[]{value, count});
        this.allowRequired = allowRequired;
        for (OptionData option : options) {
            this.options.add(option);
        }
        return this;
    }

    @Nonnull
    public SubcommandData addOptions(@Nonnull Collection<? extends OptionData> options) {
        Checks.noneNull(options, "Options");
        return this.addOptions(options.toArray(new OptionData[0]));
    }

    @Nonnull
    public SubcommandData addOption(@Nonnull OptionType type, @Nonnull String name, @Nonnull String description, boolean required, boolean autoComplete) {
        return this.addOptions(new OptionData(type, name, description).setRequired(required).setAutoComplete(autoComplete));
    }

    @Nonnull
    public SubcommandData addOption(@Nonnull OptionType type, @Nonnull String name, @Nonnull String description, boolean required) {
        return this.addOption(type, name, description, required, false);
    }

    @Nonnull
    public SubcommandData addOption(@Nonnull OptionType type, @Nonnull String name, @Nonnull String description) {
        return this.addOption(type, name, description, false);
    }

    @Nonnull
    public List<OptionData> getOptions() {
        return this.options.stream(DataArray::getObject).map(OptionData::fromData).filter(it -> it.getType().getKey() > OptionType.SUB_COMMAND_GROUP.getKey()).collect(Collectors.toList());
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        return DataObject.empty().put("type", OptionType.SUB_COMMAND.getKey()).put("name", this.name).put("description", this.description).put("options", this.options);
    }

    @Nonnull
    public static SubcommandData fromData(@Nonnull DataObject json) {
        String name = json.getString("name");
        String description = json.getString("description");
        SubcommandData sub = new SubcommandData(name, description);
        json.optArray("options").ifPresent(arr -> arr.stream(DataArray::getObject).map(OptionData::fromData).forEach(xva$0 -> sub.addOptions((OptionData)xva$0)));
        return sub;
    }

    @Nonnull
    public static SubcommandData fromSubcommand(@Nonnull Command.Subcommand subcommand) {
        Checks.notNull(subcommand, "Subcommand");
        SubcommandData data = new SubcommandData(subcommand.getName(), subcommand.getDescription());
        subcommand.getOptions().stream().map(OptionData::fromOption).forEach(xva$0 -> data.addOptions((OptionData)xva$0));
        return data;
    }
}

