/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.entities.mixin.channel.middleman;

import java.util.Collection;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.Permission;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.GuildMessageChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.User;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.requests.RestAction;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.MiscUtil;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.TimeUtil;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.entities.mixin.channel.middleman.GuildChannelMixin;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.entities.mixin.channel.middleman.MessageChannelMixin;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.requests.RestActionImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.requests.Route;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.utils.Checks;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.utils.EncodingUtil;

public interface GuildMessageChannelMixin<T extends GuildMessageChannelMixin<T>>
extends GuildMessageChannel,
GuildChannelMixin<T>,
MessageChannelMixin<T> {
    @Override
    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> deleteMessagesByIds(@Nonnull Collection<String> messageIds) {
        this.checkPermission(Permission.MESSAGE_MANAGE, "Must have MESSAGE_MANAGE in order to bulk delete messages in this channel regardless of author.");
        if (messageIds.size() < 2 || messageIds.size() > 100) {
            throw new IllegalArgumentException("Must provide at least 2 or at most 100 messages to be deleted.");
        }
        long twoWeeksAgo = TimeUtil.getDiscordTimestamp(System.currentTimeMillis() - 1209600000L);
        for (String id : messageIds) {
            Checks.check(MiscUtil.parseSnowflake(id) > twoWeeksAgo, "Message Id provided was older than 2 weeks. Id: " + id);
        }
        return this.bulkDeleteMessages(messageIds);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> removeReactionById(@Nonnull String messageId, @Nonnull String unicode, @Nonnull User user) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.notNull(unicode, "Provided Unicode");
        unicode = unicode.trim();
        Checks.notEmpty(unicode, "Provided Unicode");
        Checks.notNull(user, "User");
        if (!this.getJDA().getSelfUser().equals(user)) {
            this.checkPermission(Permission.MESSAGE_MANAGE);
        }
        String encoded = EncodingUtil.encodeReaction(unicode);
        String targetUser = user.equals(this.getJDA().getSelfUser()) ? "@me" : user.getId();
        Route.CompiledRoute route = Route.Messages.REMOVE_REACTION.compile(this.getId(), messageId, encoded, targetUser);
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    @Nonnull
    default public RestAction<Void> clearReactionsById(@Nonnull String messageId) {
        Checks.isSnowflake(messageId, "Message ID");
        this.checkPermission(Permission.MESSAGE_MANAGE);
        Route.CompiledRoute route = Route.Messages.REMOVE_ALL_REACTIONS.compile(this.getId(), messageId);
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    @Nonnull
    default public RestAction<Void> clearReactionsById(@Nonnull String messageId, @Nonnull String unicode) {
        Checks.notNull(messageId, "Message ID");
        Checks.notNull(unicode, "Emote Name");
        this.checkPermission(Permission.MESSAGE_MANAGE);
        String code = EncodingUtil.encodeReaction(unicode);
        Route.CompiledRoute route = Route.Messages.CLEAR_EMOTE_REACTIONS.compile(this.getId(), messageId, code);
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    default public void checkCanAccessChannel() {
        this.checkPermission(Permission.VIEW_CHANNEL);
    }

    @Override
    default public void checkCanSendMessage() {
        if (this.getType().isThread()) {
            this.checkPermission(Permission.MESSAGE_SEND_IN_THREADS);
        } else {
            this.checkPermission(Permission.MESSAGE_SEND);
        }
    }

    @Override
    default public void checkCanSendMessageEmbeds() {
        this.checkPermission(Permission.MESSAGE_EMBED_LINKS);
    }

    @Override
    default public void checkCanSendFiles() {
        this.checkPermission(Permission.MESSAGE_ATTACH_FILES);
    }

    @Override
    default public void checkCanViewHistory() {
        this.checkPermission(Permission.MESSAGE_HISTORY);
    }

    @Override
    default public void checkCanAddReactions() {
        this.checkPermission(Permission.MESSAGE_ADD_REACTION);
        this.checkPermission(Permission.MESSAGE_HISTORY, "You need MESSAGE_HISTORY to add reactions to a message");
    }

    @Override
    default public void checkCanRemoveReactions() {
        this.checkPermission(Permission.MESSAGE_HISTORY, "You need MESSAGE_HISTORY to remove reactions from a message");
    }

    @Override
    default public void checkCanControlMessagePins() {
        this.checkPermission(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE to pin or unpin messages.");
    }

    @Override
    default public boolean canDeleteOtherUsersMessages() {
        return this.hasPermission(Permission.MESSAGE_MANAGE);
    }
}

