/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.handle;

import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.JDA;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.events.interaction.GenericInteractionCreateEvent;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.events.interaction.command.MessageContextInteractionEvent;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.events.interaction.command.UserContextInteractionEvent;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.events.interaction.component.SelectMenuInteractionEvent;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.InteractionType;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.commands.Command;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.components.Component;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.data.DataObject;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.JDAImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.handle.SocketHandler;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.interactions.InteractionImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.interactions.command.CommandAutoCompleteInteractionImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.interactions.command.MessageContextInteractionImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.interactions.command.SlashCommandInteractionImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.interactions.command.UserContextInteractionImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.interactions.component.ButtonInteractionImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.interactions.component.SelectMenuInteractionImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.requests.WebSocketClient;

public class InteractionCreateHandler
extends SocketHandler {
    public InteractionCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        int type = content.getInt("type");
        if (content.getInt("version", 1) != 1) {
            WebSocketClient.LOG.debug("Received interaction with version {}. This version is currently unsupported by this version of JDA. Consider updating!", (Object)content.getInt("version", 1));
            return null;
        }
        long guildId = content.getUnsignedLong("guild_id", 0L);
        if (this.api.getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        if (guildId != 0L && this.api.getGuildById(guildId) == null) {
            return null;
        }
        switch (InteractionType.fromKey(type)) {
            case COMMAND: {
                this.handleCommand(content);
                break;
            }
            case COMPONENT: {
                this.handleAction(content);
                break;
            }
            case COMMAND_AUTOCOMPLETE: {
                this.api.handleEvent(new CommandAutoCompleteInteractionEvent((JDA)this.api, this.responseNumber, new CommandAutoCompleteInteractionImpl(this.api, content)));
                break;
            }
            default: {
                this.api.handleEvent(new GenericInteractionCreateEvent(this.api, this.responseNumber, new InteractionImpl(this.api, content)));
            }
        }
        return null;
    }

    private void handleCommand(DataObject content) {
        switch (Command.Type.fromId(content.getObject("data").getInt("type"))) {
            case SLASH: {
                this.api.handleEvent(new SlashCommandInteractionEvent((JDA)this.api, this.responseNumber, new SlashCommandInteractionImpl(this.api, content)));
                break;
            }
            case MESSAGE: {
                this.api.handleEvent(new MessageContextInteractionEvent((JDA)this.api, this.responseNumber, new MessageContextInteractionImpl(this.api, content)));
                break;
            }
            case USER: {
                this.api.handleEvent(new UserContextInteractionEvent((JDA)this.api, this.responseNumber, new UserContextInteractionImpl(this.api, content)));
            }
        }
    }

    private void handleAction(DataObject content) {
        switch (Component.Type.fromKey(content.getObject("data").getInt("component_type"))) {
            case BUTTON: {
                this.api.handleEvent(new ButtonInteractionEvent((JDA)this.api, this.responseNumber, new ButtonInteractionImpl(this.api, content)));
                break;
            }
            case SELECT_MENU: {
                this.api.handleEvent(new SelectMenuInteractionEvent((JDA)this.api, this.responseNumber, new SelectMenuInteractionImpl(this.api, content)));
            }
        }
    }
}

