/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.handle;

import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.MessageChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.events.message.MessageDeleteEvent;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.data.DataObject;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.JDAImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.entities.ThreadChannelImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.handle.EventCache;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.handle.SocketHandler;

public class MessageDeleteHandler
extends SocketHandler {
    public MessageDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        ThreadChannelImpl gThread;
        int messageCount;
        if (!content.isNull("guild_id")) {
            long guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        long messageId = content.getLong("id");
        long channelId = content.getLong("channel_id");
        MessageChannel channel = this.getJDA().getTextChannelById(channelId);
        if (channel == null) {
            channel = this.getJDA().getNewsChannelById(channelId);
        }
        if (channel == null) {
            channel = this.getJDA().getThreadChannelById(channelId);
        }
        if (channel == null) {
            channel = this.getJDA().getPrivateChannelById(channelId);
        }
        if (channel == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Got message delete for a channel/group that is not yet cached. ChannelId: {}", (Object)channelId);
            return null;
        }
        if (channel.getType().isThread() && (messageCount = (gThread = (ThreadChannelImpl)channel).getMessageCount()) < 50 && messageCount > 0) {
            gThread.setMessageCount(messageCount - 1);
        }
        this.getJDA().handleEvent(new MessageDeleteEvent(this.getJDA(), this.responseNumber, messageId, channel));
        return null;
    }
}

