/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.handle;

import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.GuildMessageChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.events.message.react.MessageReactionRemoveAllEvent;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.data.DataObject;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.JDAImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.handle.EventCache;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.handle.SocketHandler;

public class MessageReactionBulkRemoveHandler
extends SocketHandler {
    public MessageReactionBulkRemoveHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        GuildMessageChannel channel;
        long messageId = content.getLong("message_id");
        long channelId = content.getLong("channel_id");
        JDAImpl jda = this.getJDA();
        if (!content.isNull("guild_id")) {
            long guildId = content.getUnsignedLong("guild_id");
            if (this.api.getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        if ((channel = jda.getTextChannelById(channelId)) == null) {
            channel = jda.getNewsChannelById(channelId);
        }
        if (channel == null) {
            channel = jda.getThreadChannelById(channelId);
        }
        if (channel == null) {
            jda.getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received a reaction for a channel that JDA does not currently have cached channel_id: {} message_id: {}", (Object)channelId, (Object)messageId);
            return null;
        }
        jda.handleEvent(new MessageReactionRemoveAllEvent(jda, this.responseNumber, messageId, channel));
        return null;
    }
}

