/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.interactions;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.JDA;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.Channel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.Guild;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.Member;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.PrivateChannel;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.User;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.Interaction;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.data.DataObject;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.JDAImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.entities.GuildImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.entities.MemberImpl;

public class InteractionImpl
implements Interaction {
    protected final long id;
    protected final int type;
    protected final String token;
    protected final Guild guild;
    protected final Member member;
    protected final User user;
    protected final Channel channel;
    protected final Locale userLocale;
    protected final JDAImpl api;
    private boolean isAck;

    public InteractionImpl(JDAImpl jda, DataObject data) {
        this.api = jda;
        this.id = data.getUnsignedLong("id");
        this.token = data.getString("token");
        this.type = data.getInt("type");
        this.guild = jda.getGuildById(data.getUnsignedLong("guild_id", 0L));
        this.userLocale = Locale.forLanguageTag(data.getString("locale", "en-US"));
        if (this.guild != null) {
            this.member = jda.getEntityBuilder().createMember((GuildImpl)this.guild, data.getObject("member"));
            jda.getEntityBuilder().updateMemberCache((MemberImpl)this.member);
            this.user = this.member.getUser();
            this.channel = this.guild.getGuildChannelById(data.getUnsignedLong("channel_id"));
        } else {
            this.member = null;
            long channelId = data.getUnsignedLong("channel_id");
            PrivateChannel channel = jda.getPrivateChannelById(channelId);
            if (channel == null) {
                channel = jda.getEntityBuilder().createPrivateChannel(DataObject.empty().put("id", channelId).put("recipient", data.getObject("user")));
            }
            this.channel = channel;
            this.user = channel.getUser();
        }
    }

    public synchronized boolean ack() {
        boolean wasAck = this.isAck;
        this.isAck = true;
        return wasAck;
    }

    @Override
    public synchronized boolean isAcknowledged() {
        return this.isAck;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    public int getTypeRaw() {
        return this.type;
    }

    @Override
    @Nonnull
    public String getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    @Nullable
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    @Nonnull
    public Locale getUserLocale() {
        return this.userLocale;
    }

    @Override
    @Nonnull
    public User getUser() {
        return this.user;
    }

    @Override
    @Nullable
    public Member getMember() {
        return this.member;
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.api;
    }
}

