/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.interactions.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.JDA;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.entities.Guild;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.commands.Command;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.commands.OptionType;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.interactions.commands.privileges.CommandPrivilege;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.requests.RestAction;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.requests.restaction.CommandEditAction;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.data.DataArray;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.api.utils.data.DataObject;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.JDAImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.requests.RestActionImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.requests.Route;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.requests.restaction.CommandEditActionImpl;
import net.elytrium.limboauth.socialaddon.thirdparty.net.dv8tion.jda.internal.utils.Checks;

public class CommandImpl
implements Command {
    public static final EnumSet<OptionType> OPTIONS = EnumSet.complementOf(EnumSet.of(OptionType.SUB_COMMAND, OptionType.SUB_COMMAND_GROUP));
    public static final Predicate<DataObject> OPTION_TEST = it -> OPTIONS.contains((Object)OptionType.fromKey(it.getInt("type")));
    public static final Predicate<DataObject> SUBCOMMAND_TEST = it -> OptionType.fromKey(it.getInt("type")) == OptionType.SUB_COMMAND;
    public static final Predicate<DataObject> GROUP_TEST = it -> OptionType.fromKey(it.getInt("type")) == OptionType.SUB_COMMAND_GROUP;
    private final JDAImpl api;
    private final Guild guild;
    private final String name;
    private final String description;
    private final List<Command.Option> options;
    private final List<Command.SubcommandGroup> groups;
    private final List<Command.Subcommand> subcommands;
    private final long id;
    private final long guildId;
    private final long applicationId;
    private final long version;
    private final boolean defaultEnabled;
    private final Command.Type type;

    public CommandImpl(JDAImpl api, Guild guild, DataObject json) {
        this.api = api;
        this.guild = guild;
        this.name = json.getString("name");
        this.description = json.getString("description", "");
        this.type = Command.Type.fromId(json.getInt("type", 1));
        this.id = json.getUnsignedLong("id");
        this.defaultEnabled = json.getBoolean("default_permission");
        this.guildId = guild != null ? guild.getIdLong() : 0L;
        this.applicationId = json.getUnsignedLong("application_id", api.getSelfUser().getApplicationIdLong());
        this.options = CommandImpl.parseOptions(json, OPTION_TEST, Command.Option::new);
        this.groups = CommandImpl.parseOptions(json, GROUP_TEST, Command.SubcommandGroup::new);
        this.subcommands = CommandImpl.parseOptions(json, SUBCOMMAND_TEST, Command.Subcommand::new);
        this.version = json.getUnsignedLong("version", this.id);
    }

    public static <T> List<T> parseOptions(DataObject json, Predicate<DataObject> test, Function<DataObject, T> transform) {
        return json.optArray("options").map(arr -> arr.stream(DataArray::getObject).filter(test).map(transform).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    @Nonnull
    public RestAction<Void> delete() {
        this.checkSelfUser("Cannot delete a command from another bot!");
        String appId = this.getJDA().getSelfUser().getApplicationId();
        Route.CompiledRoute route = this.guildId != 0L ? Route.Interactions.DELETE_GUILD_COMMAND.compile(appId, Long.toUnsignedString(this.guildId), this.getId()) : Route.Interactions.DELETE_COMMAND.compile(appId, this.getId());
        return new RestActionImpl<Void>(this.api, route);
    }

    @Override
    @Nonnull
    public CommandEditAction editCommand() {
        this.checkSelfUser("Cannot edit a command from another bot!");
        return this.guild == null ? new CommandEditActionImpl((JDA)this.api, this.getId()) : new CommandEditActionImpl(this.guild, this.getId());
    }

    @Override
    @Nonnull
    public RestAction<List<CommandPrivilege>> retrievePrivileges(@Nonnull Guild guild) {
        this.checkSelfUser("Cannot retrieve privileges for a command from another bot!");
        Checks.notNull(guild, "Guild");
        return guild.retrieveCommandPrivilegesById(this.id);
    }

    @Override
    @Nonnull
    public RestAction<List<CommandPrivilege>> updatePrivileges(@Nonnull Guild guild, @Nonnull Collection<? extends CommandPrivilege> privileges) {
        this.checkSelfUser("Cannot update privileges for a command from another bot!");
        Checks.notNull(guild, "Guild");
        return guild.updateCommandPrivilegesById(this.id, privileges);
    }

    @Override
    @Nonnull
    public RestAction<List<CommandPrivilege>> updatePrivileges(@Nonnull Guild guild, CommandPrivilege ... privileges) {
        Checks.noneNull(privileges, "CommandPrivileges");
        return this.updatePrivileges(guild, Arrays.asList(privileges));
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.api;
    }

    @Override
    @Nonnull
    public Command.Type getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isDefaultEnabled() {
        return this.defaultEnabled;
    }

    @Override
    @Nonnull
    public List<Command.Option> getOptions() {
        return this.options;
    }

    @Override
    @Nonnull
    public List<Command.Subcommand> getSubcommands() {
        return this.subcommands;
    }

    @Override
    @Nonnull
    public List<Command.SubcommandGroup> getSubcommandGroups() {
        return this.groups;
    }

    @Override
    public long getApplicationIdLong() {
        return this.applicationId;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    public String toString() {
        return "Command[" + (Object)((Object)this.getType()) + "](" + this.getId() + ":" + this.getName() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        return this.id == ((Command)obj).getIdLong();
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    private void checkSelfUser(String s) {
        if (this.applicationId != this.api.getSelfUser().getApplicationIdLong()) {
            throw new IllegalStateException(s);
        }
    }
}

