/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta;

import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.methods.updates.SetWebhook;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.generics.BotSession;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.generics.LongPollingBot;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.generics.TelegramBot;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.generics.Webhook;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.generics.WebhookBot;

public class TelegramBotsApi {
    Class<? extends BotSession> botSessionClass;
    private boolean useWebhook;
    private Webhook webhook;

    public TelegramBotsApi(Class<? extends BotSession> botSessionClass) throws TelegramApiException {
        if (botSessionClass == null) {
            throw new TelegramApiException("Parameter botSessionClass can not be null or empty");
        }
        this.botSessionClass = botSessionClass;
    }

    public TelegramBotsApi(Class<? extends BotSession> botSessionClass, Webhook webhook) throws TelegramApiException {
        if (botSessionClass == null) {
            throw new TelegramApiException("Parameter botSessionClass can not be null or empty");
        }
        if (webhook == null) {
            throw new TelegramApiException("Parameter webhook can not be null or empty");
        }
        this.botSessionClass = botSessionClass;
        this.useWebhook = true;
        this.webhook = webhook;
        this.webhook.startServer();
    }

    public BotSession registerBot(LongPollingBot bot) throws TelegramApiException {
        BotSession session;
        if (bot == null) {
            throw new TelegramApiException("Parameter bot can not be null");
        }
        if (!this.validateBotUsernameAndToken(bot)) {
            throw new TelegramApiException("Bot token and username can't be empty");
        }
        bot.onRegister();
        bot.clearWebhook();
        try {
            session = this.botSessionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TelegramApiException(e);
        }
        session.setToken(bot.getBotToken());
        session.setOptions(bot.getOptions());
        session.setCallback(bot);
        session.start();
        return session;
    }

    public void registerBot(WebhookBot bot, SetWebhook setWebhook) throws TelegramApiException {
        if (setWebhook == null) {
            throw new TelegramApiException("Parameter setWebhook can not be null");
        }
        if (this.useWebhook) {
            if (this.webhook == null) {
                throw new TelegramApiException("This instance doesn't support Webhook bot, use correct constructor");
            }
            if (!this.validateBotUsernameAndToken(bot)) {
                throw new TelegramApiException("Bot token and username can't be empty");
            }
            bot.onRegister();
            this.webhook.registerWebhook(bot);
            bot.setWebhook(setWebhook);
        }
    }

    private boolean validateBotUsernameAndToken(TelegramBot telegramBot) {
        return !Strings.isNullOrEmpty(telegramBot.getBotToken()) && !Strings.isNullOrEmpty(telegramBot.getBotUsername());
    }
}

