/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.methods.updatingmessages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.Serializable;
import lombok.NonNull;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.ApiResponse;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.Message;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class EditMessageMedia
extends PartialBotApiMethod<Serializable> {
    public static final String PATH = "editMessageMedia";
    public static final String CHATID_FIELD = "chat_id";
    public static final String MESSAGEID_FIELD = "message_id";
    public static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    public static final String MEDIA_FIELD = "media";
    public static final String REPLYMARKUP_FIELD = "reply_markup";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="inline_message_id")
    private String inlineMessageId;
    @JsonProperty(value="media")
    @NonNull
    private InputMedia media;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;

    public void setChatId(Long chatId) {
        this.chatId = chatId == null ? null : chatId.toString();
    }

    @Override
    public Serializable deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Message> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error editing message text", result);
        }
        catch (IOException e) {
            try {
                ApiResponse<Boolean> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Boolean>>(){});
                if (result.getOk().booleanValue()) {
                    return result.getResult();
                }
                throw new TelegramApiRequestException("Error editing message text", result);
            }
            catch (IOException e2) {
                throw new TelegramApiRequestException("Unable to deserialize response", e);
            }
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineMessageId == null) {
            if (this.chatId == null || this.chatId.isEmpty()) {
                throw new TelegramApiValidationException("ChatId parameter can't be empty if inlineMessageId is not present", this);
            }
            if (this.messageId == null) {
                throw new TelegramApiValidationException("MessageId parameter can't be empty if inlineMessageId is not present", this);
            }
        } else {
            if (this.chatId != null) {
                throw new TelegramApiValidationException("ChatId parameter must be empty if inlineMessageId is provided", this);
            }
            if (this.messageId != null) {
                throw new TelegramApiValidationException("MessageId parameter must be empty if inlineMessageId is provided", this);
            }
        }
        this.media.validate();
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public static EditMessageMediaBuilder builder() {
        return new EditMessageMediaBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditMessageMedia)) {
            return false;
        }
        EditMessageMedia other = (EditMessageMedia)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$inlineMessageId = this.getInlineMessageId();
        String other$inlineMessageId = other.getInlineMessageId();
        if (this$inlineMessageId == null ? other$inlineMessageId != null : !this$inlineMessageId.equals(other$inlineMessageId)) {
            return false;
        }
        InputMedia this$media = this.getMedia();
        InputMedia other$media = other.getMedia();
        if (this$media == null ? other$media != null : !((Object)this$media).equals(other$media)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        return !(this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EditMessageMedia;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $inlineMessageId = this.getInlineMessageId();
        result = result * 59 + ($inlineMessageId == null ? 43 : $inlineMessageId.hashCode());
        InputMedia $media = this.getMedia();
        result = result * 59 + ($media == null ? 43 : ((Object)$media).hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        return result;
    }

    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    @NonNull
    public InputMedia getMedia() {
        return this.media;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    @JsonProperty(value="inline_message_id")
    public void setInlineMessageId(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
    }

    @JsonProperty(value="media")
    public void setMedia(@NonNull InputMedia media) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.media = media;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    public String toString() {
        return "EditMessageMedia(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", inlineMessageId=" + this.getInlineMessageId() + ", media=" + this.getMedia() + ", replyMarkup=" + this.getReplyMarkup() + ")";
    }

    public EditMessageMedia(@NonNull InputMedia media) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.media = media;
    }

    public EditMessageMedia() {
    }

    public EditMessageMedia(String chatId, Integer messageId, String inlineMessageId, @NonNull InputMedia media, InlineKeyboardMarkup replyMarkup) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
        this.inlineMessageId = inlineMessageId;
        this.media = media;
        this.replyMarkup = replyMarkup;
    }

    public static class EditMessageMediaBuilder {
        private String chatId;
        private Integer messageId;
        private String inlineMessageId;
        private InputMedia media;
        private InlineKeyboardMarkup replyMarkup;

        public EditMessageMediaBuilder chatId(Long chatId) {
            this.chatId = chatId == null ? null : chatId.toString();
            return this;
        }

        EditMessageMediaBuilder() {
        }

        @JsonProperty(value="chat_id")
        public EditMessageMediaBuilder chatId(String chatId) {
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="message_id")
        public EditMessageMediaBuilder messageId(Integer messageId) {
            this.messageId = messageId;
            return this;
        }

        @JsonProperty(value="inline_message_id")
        public EditMessageMediaBuilder inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            return this;
        }

        @JsonProperty(value="media")
        public EditMessageMediaBuilder media(@NonNull InputMedia media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return this;
        }

        @JsonProperty(value="reply_markup")
        public EditMessageMediaBuilder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public EditMessageMedia build() {
            return new EditMessageMedia(this.chatId, this.messageId, this.inlineMessageId, this.media, this.replyMarkup);
        }

        public String toString() {
            return "EditMessageMedia.EditMessageMediaBuilder(chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ", media=" + this.media + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }
}

