/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.media;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import lombok.NonNull;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.InputFile;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.MessageEntity;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import net.elytrium.limboauth.socialaddon.thirdparty.org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InputMediaDocument
extends InputMedia {
    private static final String TYPE = "document";
    public static final String THUMB_FIELD = "thumb";
    public static final String DISABLECONTENTTYPEDETECTION_FIELD = "disable_content_type_detection";
    private InputFile thumb;
    @JsonProperty(value="disable_content_type_detection")
    private Boolean disableContentTypeDetection;

    public InputMediaDocument() {
    }

    public InputMediaDocument(@NonNull String media) {
        super(media);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
    }

    public InputMediaDocument(@NonNull String media, String caption, String parseMode, List<MessageEntity> entities, boolean isNewMedia, String mediaName, File newMediaFile, InputStream newMediaStream, InputFile thumb, Boolean disableContentTypeDetection) {
        super(media, caption, parseMode, entities, isNewMedia, mediaName, newMediaFile, newMediaStream);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.thumb = thumb;
        this.disableContentTypeDetection = disableContentTypeDetection;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        super.validate();
    }

    public static InputMediaDocumentBuilder builder() {
        return new InputMediaDocumentBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputMediaDocument)) {
            return false;
        }
        InputMediaDocument other = (InputMediaDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$disableContentTypeDetection = this.getDisableContentTypeDetection();
        Boolean other$disableContentTypeDetection = other.getDisableContentTypeDetection();
        if (this$disableContentTypeDetection == null ? other$disableContentTypeDetection != null : !((Object)this$disableContentTypeDetection).equals(other$disableContentTypeDetection)) {
            return false;
        }
        InputFile this$thumb = this.getThumb();
        InputFile other$thumb = other.getThumb();
        return !(this$thumb == null ? other$thumb != null : !((Object)this$thumb).equals(other$thumb));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InputMediaDocument;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $disableContentTypeDetection = this.getDisableContentTypeDetection();
        result = result * 59 + ($disableContentTypeDetection == null ? 43 : ((Object)$disableContentTypeDetection).hashCode());
        InputFile $thumb = this.getThumb();
        result = result * 59 + ($thumb == null ? 43 : ((Object)$thumb).hashCode());
        return result;
    }

    public InputFile getThumb() {
        return this.thumb;
    }

    public Boolean getDisableContentTypeDetection() {
        return this.disableContentTypeDetection;
    }

    public void setThumb(InputFile thumb) {
        this.thumb = thumb;
    }

    @JsonProperty(value="disable_content_type_detection")
    public void setDisableContentTypeDetection(Boolean disableContentTypeDetection) {
        this.disableContentTypeDetection = disableContentTypeDetection;
    }

    @Override
    public String toString() {
        return "InputMediaDocument(thumb=" + this.getThumb() + ", disableContentTypeDetection=" + this.getDisableContentTypeDetection() + ")";
    }

    public static class InputMediaDocumentBuilder {
        private String media;
        private String caption;
        private String parseMode;
        private List<MessageEntity> entities;
        private boolean isNewMedia;
        private String mediaName;
        private File newMediaFile;
        private InputStream newMediaStream;
        private InputFile thumb;
        private Boolean disableContentTypeDetection;

        InputMediaDocumentBuilder() {
        }

        public InputMediaDocumentBuilder media(@NonNull String media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return this;
        }

        public InputMediaDocumentBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InputMediaDocumentBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public InputMediaDocumentBuilder entities(List<MessageEntity> entities) {
            this.entities = entities;
            return this;
        }

        public InputMediaDocumentBuilder isNewMedia(boolean isNewMedia) {
            this.isNewMedia = isNewMedia;
            return this;
        }

        public InputMediaDocumentBuilder mediaName(String mediaName) {
            this.mediaName = mediaName;
            return this;
        }

        public InputMediaDocumentBuilder newMediaFile(File newMediaFile) {
            this.newMediaFile = newMediaFile;
            return this;
        }

        public InputMediaDocumentBuilder newMediaStream(InputStream newMediaStream) {
            this.newMediaStream = newMediaStream;
            return this;
        }

        public InputMediaDocumentBuilder thumb(InputFile thumb) {
            this.thumb = thumb;
            return this;
        }

        public InputMediaDocumentBuilder disableContentTypeDetection(Boolean disableContentTypeDetection) {
            this.disableContentTypeDetection = disableContentTypeDetection;
            return this;
        }

        public InputMediaDocument build() {
            return new InputMediaDocument(this.media, this.caption, this.parseMode, this.entities, this.isNewMedia, this.mediaName, this.newMediaFile, this.newMediaStream, this.thumb, this.disableContentTypeDetection);
        }

        public String toString() {
            return "InputMediaDocument.InputMediaDocumentBuilder(media=" + this.media + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", entities=" + this.entities + ", isNewMedia=" + this.isNewMedia + ", mediaName=" + this.mediaName + ", newMediaFile=" + this.newMediaFile + ", newMediaStream=" + this.newMediaStream + ", thumb=" + this.thumb + ", disableContentTypeDetection=" + this.disableContentTypeDetection + ")";
        }
    }
}

