/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.socialaddon.utils;

import com.maxmind.db.CHMCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.record.AbstractNamedRecord;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import net.elytrium.limboapi.thirdparty.commons.config.Placeholders;
import net.elytrium.limboauth.socialaddon.Settings;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;

public class GeoIp {
    private final DatabaseReader reader;
    private final boolean cityEnabled;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public GeoIp(Path dataPath) {
        this.cityEnabled = Settings.IMP.MAIN.GEOIP.FORMAT.contains("{CITY}");
        try {
            Path path = dataPath.resolve(this.cityEnabled ? "city.mmdb" : "country.mmdb");
            if (!Files.exists(path, new LinkOption[0]) || System.currentTimeMillis() - path.toFile().lastModified() > Settings.IMP.MAIN.GEOIP.UPDATE_INTERVAL) {
                String uri = Placeholders.replace((String)(this.cityEnabled ? Settings.IMP.MAIN.GEOIP.MMDB_CITY_DOWNLOAD : Settings.IMP.MAIN.GEOIP.MMDB_COUNTRY_DOWNLOAD), (Object[])new Object[]{Settings.IMP.MAIN.GEOIP.LICENSE_KEY});
                ByteArrayInputStream byteStream = new ByteArrayInputStream(IOUtils.toByteArray(new URL(uri).openStream()));
                try (GZIPInputStream gzip = new GZIPInputStream(byteStream);
                     TarArchiveInputStream tarInputStream = new TarArchiveInputStream(gzip);){
                    TarArchiveEntry entry;
                    byte[] b = new byte[4096];
                    while ((entry = tarInputStream.getNextTarEntry()) != null) {
                        if (!entry.getName().endsWith("mmdb")) continue;
                        Files.deleteIfExists(path);
                        try (FileOutputStream fos = new FileOutputStream(path.toFile());){
                            int r;
                            while ((r = tarInputStream.read(b)) != -1) {
                                fos.write(b, 0, r);
                            }
                        }
                    }
                }
            }
            this.reader = new DatabaseReader.Builder(path.toFile()).withCache(new CHMCache(16384)).build();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getLocation(String ip) {
        try {
            InetAddress address = InetAddress.getByName(ip);
            String city = "";
            String country = "";
            String leastSpecificSubdivision = "";
            String mostSpecificSubdivision = "";
            if (this.cityEnabled) {
                CityResponse response = this.reader.city(address);
                city = GeoIp.getName(response.getCity());
                country = GeoIp.getName(response.getCountry());
                leastSpecificSubdivision = GeoIp.getName(response.getLeastSpecificSubdivision());
                mostSpecificSubdivision = GeoIp.getName(response.getMostSpecificSubdivision());
            } else {
                CountryResponse response = this.reader.country(address);
                country = GeoIp.getName(response.getCountry());
            }
            return Placeholders.replace((String)Settings.IMP.MAIN.GEOIP.FORMAT, (Object[])new Object[]{city, country, leastSpecificSubdivision, mostSpecificSubdivision});
        }
        catch (GeoIp2Exception | IOException e) {
            e.printStackTrace();
            return Settings.IMP.MAIN.GEOIP.DEFAULT_VALUE;
        }
    }

    private static String getName(AbstractNamedRecord response) {
        return response.getNames().getOrDefault(Settings.IMP.MAIN.GEOIP.LOCALE, Settings.IMP.MAIN.GEOIP.DEFAULT_VALUE);
    }
}

