/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.api;

import com.google.gson.annotations.SerializedName;
import com.stereowalker.tiered.Reforged;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9274;

public class AttributeTemplate {
    @SerializedName(value="type")
    private final String attributeTypeID;
    @SerializedName(value="modifier")
    private final class_1322 attributeModifier;
    @SerializedName(value="required_equipment_slots")
    private final class_9274[] requiredEquipmentSlotTypes;
    @SerializedName(value="optional_equipment_slots")
    private final class_9274[] optionalEquipmentSlotTypes;
    @SerializedName(value="required_accessory_slots")
    private final AccessorySlot[] requiredAccessorySlotTypes;
    @SerializedName(value="optional_accessory_slots")
    private final AccessorySlot[] optionalAccessorySlotTypes;
    @SerializedName(value="required_accessory_groups")
    private final AccessorySlot.Group[] requiredAccessoryGroupTypes;
    @SerializedName(value="optional_accessory_groups")
    private final AccessorySlot.Group[] optionalAccessoryGroupTypes;
    @SerializedName(value="required_curio_slots")
    private final String[] requiredCurioSlotTypes;
    @SerializedName(value="optional_curio_slots")
    private final String[] optionalCurioSlotTypes;

    public AttributeTemplate(String attributeTypeID, class_1322 AttributeModifier, class_9274[] requiredEquipmentSlotTypes, class_9274[] optionalEquipmentSlotTypes, AccessorySlot[] requiredAccessorySlotTypes, AccessorySlot[] optionalAccessorySlotTypes, AccessorySlot.Group[] requiredAccessoryGroupTypes, AccessorySlot.Group[] optionalAccessoryGroupTypes, String[] requiredCurioSlotTypes, String[] optionalCurioSlotTypes) {
        this.attributeTypeID = attributeTypeID;
        this.attributeModifier = AttributeModifier;
        this.requiredEquipmentSlotTypes = requiredEquipmentSlotTypes;
        this.optionalEquipmentSlotTypes = optionalEquipmentSlotTypes;
        this.requiredAccessorySlotTypes = requiredAccessorySlotTypes;
        this.optionalAccessorySlotTypes = optionalAccessorySlotTypes;
        this.requiredAccessoryGroupTypes = requiredAccessoryGroupTypes;
        this.optionalAccessoryGroupTypes = optionalAccessoryGroupTypes;
        this.requiredCurioSlotTypes = requiredCurioSlotTypes;
        this.optionalCurioSlotTypes = optionalCurioSlotTypes;
    }

    public class_9274[] getRequiredEquipmentSlot() {
        return this.requiredEquipmentSlotTypes;
    }

    public class_9274[] getOptionalEquipmentSlot() {
        return this.optionalEquipmentSlotTypes;
    }

    public class_1304[] getRequiredLiteralEquipmentSlot() {
        ArrayList<class_1304> slots = new ArrayList<class_1304>();
        if (this.requiredEquipmentSlotTypes != null) {
            for (class_1304 slot : class_1304.values()) {
                if (slots.contains(slot)) continue;
                for (class_9274 group : this.requiredEquipmentSlotTypes) {
                    if (!group.method_57286(slot)) continue;
                    slots.add(slot);
                }
            }
        }
        return slots.toArray(new class_1304[0]);
    }

    public class_1304[] getOptionalLiteralEquipmentSlot() {
        ArrayList<class_1304> slots = new ArrayList<class_1304>();
        if (this.optionalEquipmentSlotTypes != null) {
            for (class_1304 slot : class_1304.values()) {
                if (slots.contains(slot)) continue;
                for (class_9274 group : this.optionalEquipmentSlotTypes) {
                    if (!group.method_57286(slot)) continue;
                    slots.add(slot);
                }
            }
        }
        return slots.toArray(new class_1304[0]);
    }

    public AccessorySlot[] getRequiredAccessorySlot() {
        return this.requiredAccessorySlotTypes;
    }

    public AccessorySlot[] getOptionalAccessorySlot() {
        return this.optionalAccessorySlotTypes;
    }

    public AccessorySlot.Group[] getRequiredAccessoryGroup() {
        return this.requiredAccessoryGroupTypes;
    }

    public AccessorySlot.Group[] getOptionalAccessoryGroup() {
        return this.optionalAccessoryGroupTypes;
    }

    public String[] getRequiredCurioSlot() {
        return this.requiredCurioSlotTypes;
    }

    public String[] getOptionalCurioSlot() {
        return this.optionalCurioSlotTypes;
    }

    public void realize(BiConsumer<class_6880<class_1320>, class_1322> actions, class_9274 slot) {
        this.realize(actions, Reforged.MODIFIERS[slot.ordinal()]);
    }

    public void realize(BiConsumer<class_6880<class_1320>, class_1322> actions, class_1304 slot) {
        this.realize(actions, Reforged.MODIFIERS[slot.ordinal()]);
    }

    public void realize(BiConsumer<class_6880<class_1320>, class_1322> actions, AccessorySlot slot) {
        this.realize(actions, Reforged.MODIFIERS[slot.getIndex() + 6]);
    }

    public void realize(BiConsumer<class_6880<class_1320>, class_1322> actions, AccessorySlot.Group slot) {
        this.realize(actions, Reforged.MODIFIERS[slot.ordinal() + 15]);
    }

    public void realize(BiConsumer<class_6880<class_1320>, class_1322> actions, String slot, int index) {
        this.realize(actions, Reforged.CURIO_MODIFIERS.getOrDefault(slot, VersionHelper.toLoc((String)"tiered", (String)slot).method_48331("_" + index)));
    }

    private void realize(BiConsumer<class_6880<class_1320>, class_1322> actions, class_2960 id) {
        class_1322 cloneModifier = new class_1322(id.method_45138("tiered_" + this.attributeModifier.comp_2447().method_12832()), this.attributeModifier.comp_2449(), this.attributeModifier.comp_2450());
        Optional key = class_7923.field_41190.method_55841(VersionHelper.toLoc((String)this.attributeTypeID));
        if (key == null || key.isEmpty()) {
            Reforged.LOGGER.warn(String.format("%s was referenced as an attribute type, but it does not exist! A data file in /tiered/item_attributes/ has an invalid type property.", this.attributeTypeID));
        } else {
            actions.accept((class_6880<class_1320>)((class_6880)key.get()), cloneModifier);
        }
    }
}

