/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.stereowalker.tiered.api.TierPool;
import com.stereowalker.unionlib.resource.ReloadListener;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PoolDataLoader
extends class_4309
implements ReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String PARSING_ERROR_MESSAGE = "Parsing error loading recipe {}";
    private static final String LOADED_RECIPES_MESSAGE = "Loaded {} item pools";
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<class_2960, TierPool> itemPools = new HashMap<class_2960, TierPool>();

    public PoolDataLoader() {
        super(GSON, "tiered_modifiers/pools");
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        HashMap readItemPools = Maps.newHashMap();
        for (Map.Entry<class_2960, JsonElement> entry : loader.entrySet()) {
            class_2960 identifier = entry.getKey();
            try {
                TierPool itemPool = (TierPool)GSON.fromJson(entry.getValue(), TierPool.class);
                if (itemPool.getTiers().isEmpty()) continue;
                readItemPools.put(identifier, itemPool);
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error(PARSING_ERROR_MESSAGE, (Object)identifier, (Object)exception);
            }
        }
        this.itemPools = readItemPools;
        LOGGER.info(LOADED_RECIPES_MESSAGE, (Object)readItemPools.size());
    }

    public Map<class_2960, TierPool> getPools() {
        return this.itemPools;
    }

    public void clear() {
        this.itemPools.clear();
    }

    public void replace(Map<class_2960, TierPool> i) {
        this.itemPools = i;
    }

    public class_2960 id() {
        return VersionHelper.toLoc((String)"tiered", (String)"pool_data");
    }
}

