/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.stereowalker.tiered.api.PotentialAttribute;
import com.stereowalker.tiered.gson.AccessoryGroupDeserializer;
import com.stereowalker.tiered.gson.AccessorySlotDeserializer;
import com.stereowalker.tiered.gson.EntityAttributeModifierDeserializer;
import com.stereowalker.tiered.gson.EntityAttributeModifierSerializer;
import com.stereowalker.tiered.gson.EquipmentSlotDeserializer;
import com.stereowalker.tiered.gson.StyleSerializer;
import com.stereowalker.unionlib.resource.ReloadListener;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1322;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_9274;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TierDataLoader
extends class_4309
implements ReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(class_1322.class, (Object)new EntityAttributeModifierDeserializer()).registerTypeAdapter(class_1322.class, (Object)new EntityAttributeModifierSerializer()).registerTypeAdapter(class_9274.class, (Object)new EquipmentSlotDeserializer()).registerTypeAdapter(AccessorySlot.class, (Object)new AccessorySlotDeserializer()).registerTypeAdapter(AccessorySlot.Group.class, (Object)new AccessoryGroupDeserializer()).registerTypeHierarchyAdapter(class_2583.class, (Object)new StyleSerializer()).create();
    private static final String PARSING_ERROR_MESSAGE = "Parsing error loading recipe {}";
    private static final String LOADED_RECIPES_MESSAGE = "Loaded {} item tiers";
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<class_2960, PotentialAttribute> itemAttributes = new HashMap<class_2960, PotentialAttribute>();

    public TierDataLoader() {
        super(GSON, "tiered_modifiers/tiers");
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        HashMap readItemAttributes = Maps.newHashMap();
        for (Map.Entry<class_2960, JsonElement> entry : loader.entrySet()) {
            class_2960 identifier = entry.getKey();
            try {
                PotentialAttribute itemAttribute = (PotentialAttribute)GSON.fromJson(entry.getValue(), PotentialAttribute.class);
                readItemAttributes.put(identifier, itemAttribute);
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error(PARSING_ERROR_MESSAGE, (Object)identifier, (Object)exception);
            }
        }
        this.itemAttributes = readItemAttributes;
        LOGGER.info(LOADED_RECIPES_MESSAGE, (Object)readItemAttributes.size());
    }

    public Map<class_2960, PotentialAttribute> getTiers() {
        return this.itemAttributes;
    }

    public void clear() {
        this.itemAttributes.clear();
    }

    public void replace(Map<class_2960, PotentialAttribute> i) {
        this.itemAttributes = i;
    }

    public class_2960 id() {
        return VersionHelper.toLoc((String)"tiered", (String)"data_loader");
    }
}

