/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.api;

import com.google.gson.annotations.SerializedName;
import com.stereowalker.tiered.Reforged;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class AttributeTemplate {
    @SerializedName(value="type")
    private final String attributeTypeID;
    @SerializedName(value="modifier")
    private final class_1322 attributeModifier;
    @SerializedName(value="required_equipment_slots")
    private final class_1304[] requiredEquipmentSlotTypes;
    @SerializedName(value="optional_equipment_slots")
    private final class_1304[] optionalEquipmentSlotTypes;
    @SerializedName(value="required_accessory_slots")
    private final AccessorySlot[] requiredAccessorySlotTypes;
    @SerializedName(value="optional_accessory_slots")
    private final AccessorySlot[] optionalAccessorySlotTypes;
    @SerializedName(value="required_accessory_groups")
    private final AccessorySlot.Group[] requiredAccessoryGroupTypes;
    @SerializedName(value="optional_accessory_groups")
    private final AccessorySlot.Group[] optionalAccessoryGroupTypes;
    @SerializedName(value="required_curio_slots")
    private final String[] requiredCurioSlotTypes;
    @SerializedName(value="optional_curio_slots")
    private final String[] optionalCurioSlotTypes;

    public AttributeTemplate(String attributeTypeID, class_1322 AttributeModifier, class_1304[] requiredEquipmentSlotTypes, class_1304[] optionalEquipmentSlotTypes, AccessorySlot[] requiredAccessorySlotTypes, AccessorySlot[] optionalAccessorySlotTypes, AccessorySlot.Group[] requiredAccessoryGroupTypes, AccessorySlot.Group[] optionalAccessoryGroupTypes, String[] requiredCurioSlotTypes, String[] optionalCurioSlotTypes) {
        this.attributeTypeID = attributeTypeID;
        this.attributeModifier = AttributeModifier;
        this.requiredEquipmentSlotTypes = requiredEquipmentSlotTypes;
        this.optionalEquipmentSlotTypes = optionalEquipmentSlotTypes;
        this.requiredAccessorySlotTypes = requiredAccessorySlotTypes;
        this.optionalAccessorySlotTypes = optionalAccessorySlotTypes;
        this.requiredAccessoryGroupTypes = requiredAccessoryGroupTypes;
        this.optionalAccessoryGroupTypes = optionalAccessoryGroupTypes;
        this.requiredCurioSlotTypes = requiredCurioSlotTypes;
        this.optionalCurioSlotTypes = optionalCurioSlotTypes;
    }

    public class_1304[] getRequiredEquipmentSlot() {
        return this.requiredEquipmentSlotTypes;
    }

    public class_1304[] getOptionalEquipmentSlot() {
        return this.optionalEquipmentSlotTypes;
    }

    public AccessorySlot[] getRequiredAccessorySlot() {
        return this.requiredAccessorySlotTypes;
    }

    public AccessorySlot[] getOptionalAccessorySlot() {
        return this.optionalAccessorySlotTypes;
    }

    public AccessorySlot.Group[] getRequiredAccessoryGroup() {
        return this.requiredAccessoryGroupTypes;
    }

    public AccessorySlot.Group[] getOptionalAccessoryGroup() {
        return this.optionalAccessoryGroupTypes;
    }

    public String[] getRequiredCurioSlot() {
        return this.requiredCurioSlotTypes;
    }

    public String[] getOptionalCurioSlot() {
        return this.optionalCurioSlotTypes;
    }

    public void realize(BiConsumer<class_6880<class_1320>, class_1322> actions, class_1304 slot) {
        this.realize(actions, Reforged.MODIFIERS[slot.method_5926()], slot.method_5923());
    }

    public void realize(BiConsumer<class_6880<class_1320>, class_1322> actions, AccessorySlot slot) {
        this.realize(actions, Reforged.MODIFIERS[slot.getIndex() + 6], slot.getName());
    }

    public void realize(BiConsumer<class_6880<class_1320>, class_1322> actions, AccessorySlot.Group slot) {
        this.realize(actions, Reforged.MODIFIERS[slot.ordinal() + 15], slot.getName());
    }

    public void realize(BiConsumer<class_6880<class_1320>, class_1322> actions, String slot, int index) {
        this.realize(actions, Reforged.CURIO_MODIFIERS.getOrDefault(slot, UUID.nameUUIDFromBytes((slot + index).getBytes())), slot);
    }

    private void realize(BiConsumer<class_6880<class_1320>, class_1322> actions, UUID id, String name) {
        class_1322 cloneModifier = new class_1322(id, this.attributeModifier.comp_2448() + "_tiered_" + name, this.attributeModifier.comp_2449(), this.attributeModifier.comp_2450());
        Optional key = class_7923.field_41190.method_55841(VersionHelper.toLoc((String)this.attributeTypeID));
        if (key == null || key.isEmpty()) {
            Reforged.LOGGER.warn(String.format("%s was referenced as an attribute type, but it does not exist! A data file in /tiered/item_attributes/ has an invalid type property.", this.attributeTypeID));
        } else {
            actions.accept((class_6880<class_1320>)((class_6880)key.get()), cloneModifier);
        }
    }
}

