/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.stereowalker.reforged.config.Config;
import com.stereowalker.tiered.ReforgedClientSegment;
import com.stereowalker.tiered.api.AttributeTemplate;
import com.stereowalker.tiered.api.ModifierUtils;
import com.stereowalker.tiered.api.PotentialAttribute;
import com.stereowalker.tiered.compat.CuriosCompat;
import com.stereowalker.tiered.data.PoolDataLoader;
import com.stereowalker.tiered.data.TierAffixer;
import com.stereowalker.tiered.data.TierDataLoader;
import com.stereowalker.tiered.network.protocol.game.ClientboundTierSyncerPacket;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.collectors.ConfigCollector;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.PacketCollector;
import com.stereowalker.unionlib.api.collectors.ReloadListeners;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabPopulator;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.core.registries.RegistryHolder;
import com.stereowalker.unionlib.core.registries.RegistryObject;
import com.stereowalker.unionlib.insert.InsertHandler;
import com.stereowalker.unionlib.insert.Inserts;
import com.stereowalker.unionlib.insert.ServerInserts;
import com.stereowalker.unionlib.insert.handler.item.ItemAttributeModifierHandler;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.PacketHolder;
import com.stereowalker.unionlib.mod.ServerSegment;
import com.stereowalker.unionlib.resource.ReloadListener;
import com.stereowalker.unionlib.util.ModHelper;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import com.stereowalker.unionlib.world.item.AccessoryItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.neoforged.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tiered")
public class Reforged
extends MinecraftMod
implements PacketHolder {
    public static final TierDataLoader TIER_DATA = new TierDataLoader();
    public static final PoolDataLoader POOL_DATA = new PoolDataLoader();
    public static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6C"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0E"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48F"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB151"), UUID.fromString("4a88bc27-9563-4eeb-96d5-fe50917cc24f"), UUID.fromString("fee48d8c-1b51-4c46-9f4b-c58162623a7a"), UUID.fromString("3ac44786-fd3d-43db-8283-6822f7d62ea4"), UUID.fromString("2671f9f5-4ca6-4d09-b4bb-b958ac6d31e7"), UUID.fromString("31a9945e-2c8d-4894-86b6-87ba416c2e18"), UUID.fromString("63360860-88b6-4395-a561-151cd51dc91b"), UUID.fromString("7ec914a0-7b1d-4bec-ba17-d435ffa49eb4"), UUID.fromString("2dcd3ee4-cadb-4fa4-9bd4-b90b67ab77ff"), UUID.fromString("031de3a3-4368-4021-a6b1-42e8c454cfc1"), UUID.fromString("62c90c65-0f18-4d8d-afb2-340e5ff17fc5"), UUID.fromString("b8c433d5-1ae0-4ab1-9a40-000a6aab3f29"), UUID.fromString("b340cc35-ef8e-4fa6-b21f-9a60e5d4e4b3"), UUID.fromString("24cf925c-bfac-4729-9bad-57e1dc4502f7"), UUID.fromString("1732e8f1-8c5e-4f1f-aa34-b2489b4259c9")};
    public static final Map<String, UUID> CURIO_MODIFIERS = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put("back", UUID.fromString("fee48d8c-1b51-4c46-9f4b-c58162623a7a"));
        map.put("ring", UUID.fromString("fee48d8c-1b51-4c46-9f4b-c58162623a7b"));
    });
    public static final Logger LOGGER = LogManager.getLogger();
    public static Reforged instance;

    public static ResourceLocation getKey(PotentialAttribute tier) {
        return TIER_DATA.getTiers().entrySet().stream().filter(entry -> tier.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().get();
    }

    public Reforged() {
        super("tiered", () -> new ReforgedClientSegment(), () -> new ServerSegment());
        instance = this;
        UnionLib.Modulo.Default_Bow_Draw_Speed.enable();
    }

    public void setupConfigs(ConfigCollector collector) {
        collector.registerConfig(Config.class);
    }

    public static boolean hasModifier(ItemStack stack) {
        return ComponentsRegistry.MODIFIER_D.hasData(stack) && ComponentsRegistry.MODIFIER_D.getData(stack) != ModifierUtils.BLANK;
    }

    public void onModConstruct() {
        if (ModHelper.isCuriosLoaded()) {
            boolean useCurios = false;
            try {
                Class.forName("top.theillusivec4.curios.api.event.CurioAttributeModifierEvent");
                useCurios = true;
            }
            catch (Exception e) {
                System.err.println("Curios support was disabled because the modifier event was not present");
            }
            if (useCurios) {
                CuriosCompat.load();
            }
        }
    }

    public void registerServerRelaodableResources(ReloadListeners reloadListener) {
        reloadListener.listenTo((ReloadListener)TIER_DATA);
        reloadListener.listenTo((ReloadListener)POOL_DATA);
    }

    public void registerInserts(InsertCollector collector) {
        collector.addInsert((InsertHandler)Inserts.LOGGED_IN, insert -> {
            if (insert.player().level().isClientSide) {
                return;
            }
            new ClientboundTierSyncerPacket(TIER_DATA.getTiers()).send((ServerPlayer)insert.player());
        });
        collector.addInsert((InsertHandler)Inserts.MENU_OPEN, insert -> insert.menu().getItems().forEach(Reforged::attemptToAffixTier));
        collector.addInsert((InsertHandler)Inserts.ITEM_CRAFTED, insert -> {
            if (!Config.canCraftedReceiveTier) {
                insert.craftingStack().set(ComponentsRegistry.MODIFIER, (Object)ModifierUtils.getBlankAttributeIDFor(insert.craftingStack().getItem()));
            }
        });
        collector.addInsert((InsertHandler)ServerInserts.VILLAGER_TRADES, insert -> {
            if (insert.profession() == VillagerProfession.ARMORER) {
                ((List)insert.trades().get(3)).add(new VillagerTrades.ItemsForEmeralds(ItemRegistries.ARMORERS_HAMMER, 64, 1, 1, 10));
            }
            if (insert.profession() == VillagerProfession.TOOLSMITH) {
                ((List)insert.trades().get(3)).add(new VillagerTrades.ItemsForEmeralds(ItemRegistries.TOOLSMITHS_HAMMER, 64, 1, 1, 10));
            }
            if (insert.profession() == VillagerProfession.WEAPONSMITH) {
                ((List)insert.trades().get(4)).add(new VillagerTrades.ItemsForEmeralds(ItemRegistries.WEAPONSMITHS_HAMMER, 64, 1, 1, 10));
            }
        });
        collector.addInsert((InsertHandler)Inserts.LIVING_TICK, insert -> {
            LivingEntity patt0$temp = insert.living();
            if (patt0$temp instanceof TierAffixer) {
                TierAffixer affixer = (TierAffixer)patt0$temp;
                if (affixer.InvCopy() == null) {
                    affixer.SetInvCopy(affixer.copyDefaultedList((NonNullList<ItemStack>)affixer.player().inventory.items));
                    affixer.player().inventory.items.forEach(Reforged::attemptToAffixTier);
                }
                if (!affixer.player().inventory.items.equals(affixer.InvCopy())) {
                    affixer.SetInvCopy(affixer.copyDefaultedList((NonNullList<ItemStack>)affixer.player().inventory.items));
                    affixer.player().inventory.items.forEach(Reforged::attemptToAffixTier);
                }
            }
        });
        collector.addInsert((InsertHandler)Inserts.ANVIL_CONTENT_CHANGE, insert -> {
            if ((Config.canReforgeBroken || !insert.left().isDamaged()) && Reforged.hasModifier(insert.left())) {
                PotentialAttribute reforgedAttribute = TIER_DATA.getTiers().get(insert.left().get(ComponentsRegistry.MODIFIER));
                if (reforgedAttribute.getReforgeItem() != null) {
                    if (RegistryHelper.getItemKey((Item)insert.right().getItem()).equals((Object)VersionHelper.toLoc((String)reforgedAttribute.getReforgeItem())) && insert.right().getMaxDamage() - insert.right().getDamageValue() >= reforgedAttribute.getReforgeDurabilityCost()) {
                        ItemStack copy = insert.left().copy();
                        copy.remove(ComponentsRegistry.MODIFIER);
                        insert.output().set((Object)copy);
                        if (Config.enableReforgeExpCost) {
                            insert.cost().set((Object)reforgedAttribute.getReforgeExperienceCost());
                        } else {
                            insert.canTakeOnZeroExp().set((Object)true);
                            insert.cost().set((Object)0L);
                        }
                    }
                } else {
                    LOGGER.info(String.valueOf(Reforged.getKey(reforgedAttribute)) + " cannot be reforged because it either does not provide any reforging info or the info it provides is not complete");
                }
            }
        });
        collector.addInsert((InsertHandler)Inserts.ITEM_ATTRIBUTE_MODIFIER, insert -> Reforged.AppendAttributesToOriginal(insert.itemStack(), insert.slot(), Reforged.isPreferredEquipmentSlot(insert.itemStack(), insert.slot()), "AttributeModifiers", (Function<AttributeTemplate, T[]>)((Function)template -> template.getRequiredEquipmentSlot()), (Function<AttributeTemplate, T[]>)((Function)template -> template.getOptionalEquipmentSlot()), template -> template.realize((arg_0, arg_1) -> ((ItemAttributeModifierHandler.AttributeModification)insert.attributes()).add(arg_0, arg_1), insert.slot())));
    }

    public void setupRegistries(RegistryCollector collector) {
        collector.addRegistryHolder(Registries.DATA_COMPONENT_TYPE, ComponentsRegistry.class);
        collector.addRegistryHolder(Registries.ITEM, ItemRegistries.class);
    }

    public void populateCreativeTabs(CreativeTabPopulator populator) {
        if (populator.isToolTab()) {
            populator.addItems(new Item[]{ItemRegistries.ARMORERS_HAMMER});
            populator.addItems(new Item[]{ItemRegistries.TOOLSMITHS_HAMMER});
            populator.addItems(new Item[]{ItemRegistries.WEAPONSMITHS_HAMMER});
        }
    }

    public static void attemptToAffixTier(ItemStack stack) {
        ResourceLocation potentialAttributeID;
        if (!Reforged.hasModifier(stack) && !stack.isEmpty() && (potentialAttributeID = ModifierUtils.getRandomAttributeIDFor(stack.getItem())) != null) {
            stack.set(ComponentsRegistry.MODIFIER, (Object)potentialAttributeID);
        }
    }

    public static ResourceLocation id(String path) {
        return VersionHelper.toLoc((String)"tiered", (String)path);
    }

    public static boolean isPreferredEquipmentSlot(ItemStack stack, EquipmentSlot slot) {
        if (stack.getItem() instanceof ArmorItem) {
            ArmorItem item = (ArmorItem)stack.getItem();
            return VersionHelper.isEquippableInSlot((ArmorItem)item, (EquipmentSlot)slot);
        }
        if (stack.getItem() instanceof ShieldItem) {
            return slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND;
        }
        return slot == EquipmentSlot.MAINHAND;
    }

    public static boolean isPreferredAccessorySlot(ItemStack stack, AccessorySlot slot) {
        if (stack.getItem() instanceof AccessoryItem) {
            AccessoryItem item = (AccessoryItem)stack.getItem();
            return item.getAccessorySlots().contains(slot);
        }
        return false;
    }

    public static boolean isPreferredAccessorySlot(ItemStack stack, AccessorySlot.Group group) {
        for (AccessorySlot slot : AccessorySlot.values()) {
            if (slot.getGroup() != group || Reforged.isPreferredAccessorySlot(stack, slot)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPreferredCurioSlot(ItemStack stack, String slot) {
        return stack.is(TagKey.create((ResourceKey)RegistryHelper.itemKey(), (ResourceLocation)VersionHelper.toLoc((String)"curios", (String)slot)));
    }

    public void registerPackets(PacketCollector collector) {
        collector.registerClientboundPacket(ClientboundTierSyncerPacket.id, ClientboundTierSyncerPacket.class, ClientboundTierSyncerPacket::new);
    }

    public static <T> void AppendAttributesToOriginal(ItemStack stack, T slot, boolean isPreferredSlot, String customAttributes, Function<AttributeTemplate, T[]> requiredSlotsArray, Function<AttributeTemplate, T[]> optionalSlotsArray, Consumer<AttributeTemplate> realize) {
        if (Reforged.hasModifier(stack)) {
            ResourceLocation tier = (ResourceLocation)stack.get(ComponentsRegistry.MODIFIER);
            PotentialAttribute potentialAttribute = TIER_DATA.getTiers().get(tier);
            if (potentialAttribute != null) {
                potentialAttribute.getAttributes().forEach(template -> {
                    ArrayList<Object> optionalSlots;
                    ArrayList<Object> requiredSlots;
                    if (requiredSlotsArray.apply(template) != null && (requiredSlots = new ArrayList<Object>(Arrays.asList((Object[])requiredSlotsArray.apply(template)))).contains(slot)) {
                        realize.accept((AttributeTemplate)template);
                    }
                    if (optionalSlotsArray.apply(template) != null && (optionalSlots = new ArrayList<Object>(Arrays.asList((Object[])optionalSlotsArray.apply(template)))).contains(slot) && isPreferredSlot) {
                        realize.accept((AttributeTemplate)template);
                    }
                });
            }
        }
    }

    @RegistryHolder(namespace="tiered")
    public class ComponentsRegistry {
        @RegistryObject(value="tiered_modifier")
        public static final DataComponentType<ResourceLocation> MODIFIER = ComponentsRegistry.register(p_333150_ -> p_333150_.persistent(ResourceLocation.CODEC).networkSynchronized(ResourceLocation.STREAM_CODEC));
        public static final VersionHelper.Data<ResourceLocation> MODIFIER_D = new VersionHelper.Data(stack -> stack.has(MODIFIER), stack -> (ResourceLocation)stack.get(MODIFIER), (stack, dat) -> stack.set(MODIFIER, dat), stack -> stack.remove(MODIFIER));

        public ComponentsRegistry(Reforged this$0) {
        }

        private static <T> DataComponentType<T> register(UnaryOperator<DataComponentType.Builder<T>> pBuilder) {
            return ((DataComponentType.Builder)pBuilder.apply(DataComponentType.builder())).build();
        }
    }

    @RegistryHolder(namespace="tiered")
    public class ItemRegistries {
        @RegistryObject(value="armorers_hammer")
        public static final Item ARMORERS_HAMMER = new Item(new Item.Properties().durability(20));
        @RegistryObject(value="toolsmiths_hammer")
        public static final Item TOOLSMITHS_HAMMER = new Item(new Item.Properties().durability(20));
        @RegistryObject(value="weaponsmiths_hammer")
        public static final Item WEAPONSMITHS_HAMMER = new Item(new Item.Properties().durability(20));

        public ItemRegistries(Reforged this$0) {
        }
    }
}

