/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.api;

import com.google.gson.annotations.SerializedName;
import com.stereowalker.tiered.Reforged;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeTemplate {
    @SerializedName(value="type")
    private final String attributeTypeID;
    @SerializedName(value="modifier")
    private final AttributeModifier attributeModifier;
    @SerializedName(value="required_equipment_slots")
    private final EquipmentSlot[] requiredEquipmentSlotTypes;
    @SerializedName(value="optional_equipment_slots")
    private final EquipmentSlot[] optionalEquipmentSlotTypes;
    @SerializedName(value="required_accessory_slots")
    private final AccessorySlot[] requiredAccessorySlotTypes;
    @SerializedName(value="optional_accessory_slots")
    private final AccessorySlot[] optionalAccessorySlotTypes;
    @SerializedName(value="required_accessory_groups")
    private final AccessorySlot.Group[] requiredAccessoryGroupTypes;
    @SerializedName(value="optional_accessory_groups")
    private final AccessorySlot.Group[] optionalAccessoryGroupTypes;
    @SerializedName(value="required_curio_slots")
    private final String[] requiredCurioSlotTypes;
    @SerializedName(value="optional_curio_slots")
    private final String[] optionalCurioSlotTypes;

    public AttributeTemplate(String attributeTypeID, AttributeModifier AttributeModifier2, EquipmentSlot[] requiredEquipmentSlotTypes, EquipmentSlot[] optionalEquipmentSlotTypes, AccessorySlot[] requiredAccessorySlotTypes, AccessorySlot[] optionalAccessorySlotTypes, AccessorySlot.Group[] requiredAccessoryGroupTypes, AccessorySlot.Group[] optionalAccessoryGroupTypes, String[] requiredCurioSlotTypes, String[] optionalCurioSlotTypes) {
        this.attributeTypeID = attributeTypeID;
        this.attributeModifier = AttributeModifier2;
        this.requiredEquipmentSlotTypes = requiredEquipmentSlotTypes;
        this.optionalEquipmentSlotTypes = optionalEquipmentSlotTypes;
        this.requiredAccessorySlotTypes = requiredAccessorySlotTypes;
        this.optionalAccessorySlotTypes = optionalAccessorySlotTypes;
        this.requiredAccessoryGroupTypes = requiredAccessoryGroupTypes;
        this.optionalAccessoryGroupTypes = optionalAccessoryGroupTypes;
        this.requiredCurioSlotTypes = requiredCurioSlotTypes;
        this.optionalCurioSlotTypes = optionalCurioSlotTypes;
    }

    public EquipmentSlot[] getRequiredEquipmentSlot() {
        return this.requiredEquipmentSlotTypes;
    }

    public EquipmentSlot[] getOptionalEquipmentSlot() {
        return this.optionalEquipmentSlotTypes;
    }

    public AccessorySlot[] getRequiredAccessorySlot() {
        return this.requiredAccessorySlotTypes;
    }

    public AccessorySlot[] getOptionalAccessorySlot() {
        return this.optionalAccessorySlotTypes;
    }

    public AccessorySlot.Group[] getRequiredAccessoryGroup() {
        return this.requiredAccessoryGroupTypes;
    }

    public AccessorySlot.Group[] getOptionalAccessoryGroup() {
        return this.optionalAccessoryGroupTypes;
    }

    public String[] getRequiredCurioSlot() {
        return this.requiredCurioSlotTypes;
    }

    public String[] getOptionalCurioSlot() {
        return this.optionalCurioSlotTypes;
    }

    public void realize(BiConsumer<Holder<Attribute>, AttributeModifier> actions, EquipmentSlot slot) {
        this.realize(actions, Reforged.MODIFIERS[slot.getFilterFlag()], slot.getName());
    }

    public void realize(BiConsumer<Holder<Attribute>, AttributeModifier> actions, AccessorySlot slot) {
        this.realize(actions, Reforged.MODIFIERS[slot.getIndex() + 6], slot.getName());
    }

    public void realize(BiConsumer<Holder<Attribute>, AttributeModifier> actions, AccessorySlot.Group slot) {
        this.realize(actions, Reforged.MODIFIERS[slot.ordinal() + 15], slot.getName());
    }

    public void realize(BiConsumer<Holder<Attribute>, AttributeModifier> actions, String slot, int index) {
        this.realize(actions, Reforged.CURIO_MODIFIERS.getOrDefault(slot, UUID.nameUUIDFromBytes((slot + index).getBytes())), slot);
    }

    private void realize(BiConsumer<Holder<Attribute>, AttributeModifier> actions, UUID id, String name) {
        AttributeModifier cloneModifier = new AttributeModifier(id, this.attributeModifier.name() + "_tiered_" + name, this.attributeModifier.amount(), this.attributeModifier.operation());
        Optional key = BuiltInRegistries.ATTRIBUTE.getHolder(VersionHelper.toLoc((String)this.attributeTypeID));
        if (key == null || key.isEmpty()) {
            Reforged.LOGGER.warn(String.format("%s was referenced as an attribute type, but it does not exist! A data file in /tiered/item_attributes/ has an invalid type property.", this.attributeTypeID));
        } else {
            actions.accept((Holder<Attribute>)((Holder)key.get()), cloneModifier);
        }
    }
}

