/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.stereowalker.reforged.config.Config;
import com.stereowalker.tiered.ReforgedClientSegment;
import com.stereowalker.tiered.api.AttributeTemplate;
import com.stereowalker.tiered.api.ModifierUtils;
import com.stereowalker.tiered.api.PotentialAttribute;
import com.stereowalker.tiered.compat.CuriosCompat;
import com.stereowalker.tiered.data.PoolDataLoader;
import com.stereowalker.tiered.data.TierAffixer;
import com.stereowalker.tiered.data.TierDataLoader;
import com.stereowalker.tiered.network.protocol.game.ClientboundTierSyncerPacket;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.collectors.ConfigCollector;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.PacketCollector;
import com.stereowalker.unionlib.api.collectors.ReloadListeners;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabPopulator;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.core.registries.RegistryHolder;
import com.stereowalker.unionlib.core.registries.RegistryObject;
import com.stereowalker.unionlib.insert.InsertHandler;
import com.stereowalker.unionlib.insert.Inserts;
import com.stereowalker.unionlib.insert.ServerInserts;
import com.stereowalker.unionlib.insert.handler.item.ItemAttributeModifierHandler;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.PacketHolder;
import com.stereowalker.unionlib.mod.ServerSegment;
import com.stereowalker.unionlib.resource.ReloadListener;
import com.stereowalker.unionlib.util.ModHelper;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import com.stereowalker.unionlib.world.item.AccessoryItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.neoforged.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tiered")
public class Reforged
extends MinecraftMod
implements PacketHolder {
    public static final TierDataLoader TIER_DATA = new TierDataLoader();
    public static final PoolDataLoader POOL_DATA = new PoolDataLoader();
    public static final ResourceLocation[] MODIFIERS = new ResourceLocation[]{VersionHelper.toLoc((String)"tiered", (String)"any"), VersionHelper.toLoc((String)"tiered", (String)"mainhand"), VersionHelper.toLoc((String)"tiered", (String)"offhand"), VersionHelper.toLoc((String)"tiered", (String)"hand"), VersionHelper.toLoc((String)"tiered", (String)"boots"), VersionHelper.toLoc((String)"tiered", (String)"leggings"), VersionHelper.toLoc((String)"tiered", (String)"chestplates"), VersionHelper.toLoc((String)"tiered", (String)"helmets"), VersionHelper.toLoc((String)"tiered", (String)"armor"), VersionHelper.toLoc((String)"tiered", (String)"body"), VersionHelper.toLoc((String)"tiered", (String)"accessory1"), VersionHelper.toLoc((String)"tiered", (String)"accessory2"), VersionHelper.toLoc((String)"tiered", (String)"accessory3"), VersionHelper.toLoc((String)"tiered", (String)"accessory4"), VersionHelper.toLoc((String)"tiered", (String)"accessory5"), VersionHelper.toLoc((String)"tiered", (String)"accessory6"), VersionHelper.toLoc((String)"tiered", (String)"accessory7"), VersionHelper.toLoc((String)"tiered", (String)"accessory8"), VersionHelper.toLoc((String)"tiered", (String)"accessory9"), VersionHelper.toLoc((String)"tiered", (String)"neclaces"), VersionHelper.toLoc((String)"tiered", (String)"backs"), VersionHelper.toLoc((String)"tiered", (String)"rings")};
    public static final Map<String, ResourceLocation> CURIO_MODIFIERS = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put("back", VersionHelper.toLoc((String)"tiered", (String)"curio_back"));
        map.put("ring", VersionHelper.toLoc((String)"tiered", (String)"curio_rings"));
    });
    public static final Logger LOGGER = LogManager.getLogger();
    public static Reforged instance;
    static boolean hasComplainedAboutCurios;

    public static ResourceLocation getKey(PotentialAttribute tier) {
        return TIER_DATA.getTiers().entrySet().stream().filter(entry -> tier.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().get();
    }

    public Reforged() {
        super("tiered", () -> new ReforgedClientSegment(), () -> new ServerSegment());
        instance = this;
        UnionLib.Modulo.Default_Bow_Draw_Speed.enable();
    }

    public void setupConfigs(ConfigCollector collector) {
        collector.registerConfig(Config.class);
    }

    public static boolean hasModifier(ItemStack stack) {
        return ComponentsRegistry.MODIFIER_D.hasData(stack) && ComponentsRegistry.MODIFIER_D.getData(stack) != ModifierUtils.BLANK;
    }

    public static void doCurio(Runnable onCurioLoaded) {
        if (ModHelper.isCuriosLoaded()) {
            boolean useCurios = false;
            try {
                Class.forName("top.theillusivec4.curios.api.event.CurioAttributeModifierEvent");
                useCurios = true;
            }
            catch (Exception e) {
                if (hasComplainedAboutCurios) {
                    System.err.println("Curios support was disabled because the modifier event was not present");
                }
                hasComplainedAboutCurios = true;
            }
            if (useCurios) {
                onCurioLoaded.run();
            }
        }
    }

    public void onModConstruct() {
        Reforged.doCurio(() -> CuriosCompat.load());
    }

    public void registerServerRelaodableResources(ReloadListeners reloadListener) {
        reloadListener.listenTo((ReloadListener)TIER_DATA);
        reloadListener.listenTo((ReloadListener)POOL_DATA);
    }

    public void registerInserts(InsertCollector collector) {
        collector.addInsert((InsertHandler)Inserts.LOGGED_IN, insert -> {
            if (insert.player().level().isClientSide) {
                return;
            }
            new ClientboundTierSyncerPacket(TIER_DATA.getTiers()).send((ServerPlayer)insert.player());
        });
        collector.addInsert((InsertHandler)Inserts.MENU_OPEN, insert -> insert.menu().getItems().forEach(Reforged::attemptToAffixTier));
        collector.addInsert((InsertHandler)Inserts.ITEM_CRAFTED, insert -> {
            if (!Config.canCraftedReceiveTier) {
                insert.craftingStack().set(ComponentsRegistry.MODIFIER, (Object)ModifierUtils.getBlankAttributeIDFor(insert.craftingStack().getItem()));
            }
        });
        collector.addInsert((InsertHandler)ServerInserts.VILLAGER_TRADES, insert -> {
            if (insert.profession() == VillagerProfession.ARMORER) {
                ((List)insert.trades().get(3)).add(new VillagerTrades.ItemsForEmeralds(ItemRegistries.ARMORERS_HAMMER, 64, 1, 1, 10));
            }
            if (insert.profession() == VillagerProfession.TOOLSMITH) {
                ((List)insert.trades().get(3)).add(new VillagerTrades.ItemsForEmeralds(ItemRegistries.TOOLSMITHS_HAMMER, 64, 1, 1, 10));
            }
            if (insert.profession() == VillagerProfession.WEAPONSMITH) {
                ((List)insert.trades().get(4)).add(new VillagerTrades.ItemsForEmeralds(ItemRegistries.WEAPONSMITHS_HAMMER, 64, 1, 1, 10));
            }
        });
        collector.addInsert((InsertHandler)Inserts.LIVING_TICK, insert -> {
            LivingEntity patt0$temp = insert.living();
            if (patt0$temp instanceof TierAffixer) {
                TierAffixer affixer = (TierAffixer)patt0$temp;
                if (affixer.InvCopy() == null) {
                    affixer.SetInvCopy(affixer.copyDefaultedList((NonNullList<ItemStack>)affixer.player().inventory.items));
                    affixer.player().inventory.items.forEach(Reforged::attemptToAffixTier);
                }
                if (!affixer.player().inventory.items.equals(affixer.InvCopy())) {
                    affixer.SetInvCopy(affixer.copyDefaultedList((NonNullList<ItemStack>)affixer.player().inventory.items));
                    affixer.player().inventory.items.forEach(Reforged::attemptToAffixTier);
                }
            }
        });
        collector.addInsert((InsertHandler)Inserts.ANVIL_CONTENT_CHANGE, insert -> {
            if ((Config.canReforgeBroken || !insert.left().isDamaged()) && Reforged.hasModifier(insert.left())) {
                PotentialAttribute reforgedAttribute = TIER_DATA.getTiers().get(insert.left().get(ComponentsRegistry.MODIFIER));
                if (reforgedAttribute.getReforgeItem() != null) {
                    if (RegistryHelper.getItemKey((Item)insert.right().getItem()).equals((Object)VersionHelper.toLoc((String)reforgedAttribute.getReforgeItem())) && insert.right().getMaxDamage() - insert.right().getDamageValue() >= reforgedAttribute.getReforgeDurabilityCost()) {
                        ItemStack copy = insert.left().copy();
                        copy.remove(ComponentsRegistry.MODIFIER);
                        insert.output().set((Object)copy);
                        if (Config.enableReforgeExpCost) {
                            insert.cost().set((Object)reforgedAttribute.getReforgeExperienceCost());
                        } else {
                            insert.canTakeOnZeroExp().set((Object)true);
                            insert.cost().set((Object)0L);
                        }
                    }
                } else {
                    LOGGER.info(String.valueOf(Reforged.getKey(reforgedAttribute)) + " cannot be reforged because it either does not provide any reforging info or the info it provides is not complete");
                }
            }
        });
        collector.addInsert((InsertHandler)Inserts.ITEM_ATTRIBUTE_MODIFIER, insert -> Reforged.AppendAttributesToOriginal(insert.itemStack(), insert.slot(), Reforged.isPreferredEquipmentSlot(insert.itemStack(), insert.slot()), "AttributeModifiers", (Function<AttributeTemplate, T[]>)((Function)template -> template.getRequiredLiteralEquipmentSlot()), (Function<AttributeTemplate, T[]>)((Function)template -> template.getOptionalLiteralEquipmentSlot()), template -> template.realize((arg_0, arg_1) -> ((ItemAttributeModifierHandler.AttributeModification)insert.attributes()).add(arg_0, arg_1), insert.slot())));
    }

    public void setupRegistries(RegistryCollector collector) {
        collector.addRegistryHolder(Registries.DATA_COMPONENT_TYPE, ComponentsRegistry.class);
        collector.addRegistryHolder(Registries.ITEM, ItemRegistries.class);
    }

    public void populateCreativeTabs(CreativeTabPopulator populator) {
        if (populator.isToolTab()) {
            populator.addItems(new Item[]{ItemRegistries.ARMORERS_HAMMER});
            populator.addItems(new Item[]{ItemRegistries.TOOLSMITHS_HAMMER});
            populator.addItems(new Item[]{ItemRegistries.WEAPONSMITHS_HAMMER});
        }
    }

    public static void attemptToAffixTier(ItemStack stack) {
        ResourceLocation potentialAttributeID;
        if (!Reforged.hasModifier(stack) && !stack.isEmpty() && (potentialAttributeID = ModifierUtils.getRandomAttributeIDFor(stack.getItem())) != ModifierUtils.BLANK) {
            ComponentsRegistry.MODIFIER_D.setData(stack, (Object)potentialAttributeID);
        }
    }

    public static ResourceLocation id(String path) {
        return VersionHelper.toLoc((String)"tiered", (String)path);
    }

    public static boolean isPreferredEquipmentSlot(ItemStack stack, EquipmentSlotGroup slot) {
        if (stack.getItem() instanceof ArmorItem) {
            ArmorItem item = (ArmorItem)stack.getItem();
            return slot.test(item.getEquipmentSlot());
        }
        if (stack.getItem() instanceof ShieldItem) {
            return slot.test(EquipmentSlot.MAINHAND) || slot.test(EquipmentSlot.OFFHAND);
        }
        return slot.test(EquipmentSlot.MAINHAND);
    }

    public static boolean isPreferredEquipmentSlot(ItemStack stack, EquipmentSlot slot) {
        if (stack.getItem() instanceof ArmorItem) {
            ArmorItem item = (ArmorItem)stack.getItem();
            return VersionHelper.isEquippableInSlot((ArmorItem)item, (EquipmentSlot)slot);
        }
        if (stack.getItem() instanceof ShieldItem) {
            return slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND;
        }
        return slot == EquipmentSlot.MAINHAND;
    }

    public static boolean isPreferredAccessorySlot(ItemStack stack, AccessorySlot slot) {
        if (stack.getItem() instanceof AccessoryItem) {
            AccessoryItem item = (AccessoryItem)stack.getItem();
            return item.getAccessorySlots().contains(slot);
        }
        return false;
    }

    public static boolean isPreferredAccessorySlot(ItemStack stack, AccessorySlot.Group group) {
        for (AccessorySlot slot : AccessorySlot.values()) {
            if (slot.getGroup() != group || Reforged.isPreferredAccessorySlot(stack, slot)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPreferredCurioSlot(ItemStack stack, String slot) {
        MutableBoolean isPreferred = new MutableBoolean();
        Reforged.doCurio(() -> isPreferred.setValue(stack.is(CuriosCompat.createCurioTag(slot))));
        return isPreferred.booleanValue();
    }

    public void registerPackets(PacketCollector collector) {
        collector.registerClientboundPacket(ClientboundTierSyncerPacket.id, ClientboundTierSyncerPacket.class, ClientboundTierSyncerPacket::new);
    }

    public static <T> void AppendAttributesToOriginal(ItemStack stack, T slot, boolean isPreferredSlot, String customAttributes, Function<AttributeTemplate, T[]> requiredSlotsArray, Function<AttributeTemplate, T[]> optionalSlotsArray, Consumer<AttributeTemplate> realize) {
        if (Reforged.hasModifier(stack)) {
            ResourceLocation tier = (ResourceLocation)stack.get(ComponentsRegistry.MODIFIER);
            PotentialAttribute potentialAttribute = TIER_DATA.getTiers().get(tier);
            if (potentialAttribute != null) {
                potentialAttribute.getAttributes().forEach(template -> {
                    ArrayList<Object> optionalSlots;
                    ArrayList<Object> requiredSlots;
                    if (requiredSlotsArray.apply(template) != null && (requiredSlots = new ArrayList<Object>(Arrays.asList((Object[])requiredSlotsArray.apply(template)))).contains(slot)) {
                        realize.accept((AttributeTemplate)template);
                    }
                    if (optionalSlotsArray.apply(template) != null && (optionalSlots = new ArrayList<Object>(Arrays.asList((Object[])optionalSlotsArray.apply(template)))).contains(slot) && isPreferredSlot) {
                        realize.accept((AttributeTemplate)template);
                    }
                });
            }
        }
    }

    static {
        hasComplainedAboutCurios = false;
    }

    @RegistryHolder(namespace="tiered")
    public class ComponentsRegistry {
        @RegistryObject(value="tiered_modifier")
        public static final DataComponentType<ResourceLocation> MODIFIER = ComponentsRegistry.register(p_333150_ -> p_333150_.persistent(ResourceLocation.CODEC).networkSynchronized(ResourceLocation.STREAM_CODEC));
        public static final VersionHelper.Data<ResourceLocation> MODIFIER_D = new VersionHelper.Data(stack -> stack.has(MODIFIER), stack -> (ResourceLocation)stack.get(MODIFIER), (stack, dat) -> stack.set(MODIFIER, dat), stack -> stack.remove(MODIFIER));

        public ComponentsRegistry(Reforged this$0) {
        }

        private static <T> DataComponentType<T> register(UnaryOperator<DataComponentType.Builder<T>> pBuilder) {
            return ((DataComponentType.Builder)pBuilder.apply(DataComponentType.builder())).build();
        }
    }

    @RegistryHolder(namespace="tiered")
    public class ItemRegistries {
        @RegistryObject(value="armorers_hammer")
        public static final Item ARMORERS_HAMMER = new Item(new Item.Properties().durability(20));
        @RegistryObject(value="toolsmiths_hammer")
        public static final Item TOOLSMITHS_HAMMER = new Item(new Item.Properties().durability(20));
        @RegistryObject(value="weaponsmiths_hammer")
        public static final Item WEAPONSMITHS_HAMMER = new Item(new Item.Properties().durability(20));

        public ItemRegistries(Reforged this$0) {
        }
    }
}

