/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.api;

import com.google.gson.annotations.SerializedName;
import com.stereowalker.tiered.Reforged;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeTemplate {
    @SerializedName(value="type")
    private final String attributeTypeID;
    @SerializedName(value="modifier")
    private final AttributeModifier attributeModifier;
    @SerializedName(value="required_equipment_slots")
    private final EquipmentSlotGroup[] requiredEquipmentSlotTypes;
    @SerializedName(value="optional_equipment_slots")
    private final EquipmentSlotGroup[] optionalEquipmentSlotTypes;
    @SerializedName(value="required_accessory_slots")
    private final AccessorySlot[] requiredAccessorySlotTypes;
    @SerializedName(value="optional_accessory_slots")
    private final AccessorySlot[] optionalAccessorySlotTypes;
    @SerializedName(value="required_accessory_groups")
    private final AccessorySlot.Group[] requiredAccessoryGroupTypes;
    @SerializedName(value="optional_accessory_groups")
    private final AccessorySlot.Group[] optionalAccessoryGroupTypes;
    @SerializedName(value="required_curio_slots")
    private final String[] requiredCurioSlotTypes;
    @SerializedName(value="optional_curio_slots")
    private final String[] optionalCurioSlotTypes;

    public AttributeTemplate(String attributeTypeID, AttributeModifier AttributeModifier2, EquipmentSlotGroup[] requiredEquipmentSlotTypes, EquipmentSlotGroup[] optionalEquipmentSlotTypes, AccessorySlot[] requiredAccessorySlotTypes, AccessorySlot[] optionalAccessorySlotTypes, AccessorySlot.Group[] requiredAccessoryGroupTypes, AccessorySlot.Group[] optionalAccessoryGroupTypes, String[] requiredCurioSlotTypes, String[] optionalCurioSlotTypes) {
        this.attributeTypeID = attributeTypeID;
        this.attributeModifier = AttributeModifier2;
        this.requiredEquipmentSlotTypes = requiredEquipmentSlotTypes;
        this.optionalEquipmentSlotTypes = optionalEquipmentSlotTypes;
        this.requiredAccessorySlotTypes = requiredAccessorySlotTypes;
        this.optionalAccessorySlotTypes = optionalAccessorySlotTypes;
        this.requiredAccessoryGroupTypes = requiredAccessoryGroupTypes;
        this.optionalAccessoryGroupTypes = optionalAccessoryGroupTypes;
        this.requiredCurioSlotTypes = requiredCurioSlotTypes;
        this.optionalCurioSlotTypes = optionalCurioSlotTypes;
    }

    public EquipmentSlotGroup[] getRequiredEquipmentSlot() {
        return this.requiredEquipmentSlotTypes;
    }

    public EquipmentSlotGroup[] getOptionalEquipmentSlot() {
        return this.optionalEquipmentSlotTypes;
    }

    public EquipmentSlot[] getRequiredLiteralEquipmentSlot() {
        ArrayList<EquipmentSlot> slots = new ArrayList<EquipmentSlot>();
        if (this.requiredEquipmentSlotTypes != null) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slots.contains(slot)) continue;
                for (EquipmentSlotGroup group : this.requiredEquipmentSlotTypes) {
                    if (!group.test(slot)) continue;
                    slots.add(slot);
                }
            }
        }
        return slots.toArray(new EquipmentSlot[0]);
    }

    public EquipmentSlot[] getOptionalLiteralEquipmentSlot() {
        ArrayList<EquipmentSlot> slots = new ArrayList<EquipmentSlot>();
        if (this.optionalEquipmentSlotTypes != null) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slots.contains(slot)) continue;
                for (EquipmentSlotGroup group : this.optionalEquipmentSlotTypes) {
                    if (!group.test(slot)) continue;
                    slots.add(slot);
                }
            }
        }
        return slots.toArray(new EquipmentSlot[0]);
    }

    public AccessorySlot[] getRequiredAccessorySlot() {
        return this.requiredAccessorySlotTypes;
    }

    public AccessorySlot[] getOptionalAccessorySlot() {
        return this.optionalAccessorySlotTypes;
    }

    public AccessorySlot.Group[] getRequiredAccessoryGroup() {
        return this.requiredAccessoryGroupTypes;
    }

    public AccessorySlot.Group[] getOptionalAccessoryGroup() {
        return this.optionalAccessoryGroupTypes;
    }

    public String[] getRequiredCurioSlot() {
        return this.requiredCurioSlotTypes;
    }

    public String[] getOptionalCurioSlot() {
        return this.optionalCurioSlotTypes;
    }

    public void realize(BiConsumer<Holder<Attribute>, AttributeModifier> actions, EquipmentSlotGroup slot) {
        this.realize(actions, Reforged.MODIFIERS[slot.ordinal()]);
    }

    public void realize(BiConsumer<Holder<Attribute>, AttributeModifier> actions, EquipmentSlot slot) {
        this.realize(actions, Reforged.MODIFIERS[slot.ordinal()]);
    }

    public void realize(BiConsumer<Holder<Attribute>, AttributeModifier> actions, AccessorySlot slot) {
        this.realize(actions, Reforged.MODIFIERS[slot.getIndex() + 6]);
    }

    public void realize(BiConsumer<Holder<Attribute>, AttributeModifier> actions, AccessorySlot.Group slot) {
        this.realize(actions, Reforged.MODIFIERS[slot.ordinal() + 15]);
    }

    public void realize(BiConsumer<Holder<Attribute>, AttributeModifier> actions, String slot, int index) {
        this.realize(actions, Reforged.CURIO_MODIFIERS.getOrDefault(slot, VersionHelper.toLoc((String)"tiered", (String)slot).withSuffix("_" + index)));
    }

    private void realize(BiConsumer<Holder<Attribute>, AttributeModifier> actions, ResourceLocation id) {
        AttributeModifier cloneModifier = new AttributeModifier(id.withPrefix("tiered_" + this.attributeModifier.id().getPath()), this.attributeModifier.amount(), this.attributeModifier.operation());
        Optional key = BuiltInRegistries.ATTRIBUTE.getHolder(VersionHelper.toLoc((String)this.attributeTypeID));
        if (key == null || key.isEmpty()) {
            Reforged.LOGGER.warn(String.format("%s was referenced as an attribute type, but it does not exist! A data file in /tiered/item_attributes/ has an invalid type property.", this.attributeTypeID));
        } else {
            actions.accept((Holder<Attribute>)((Holder)key.get()), cloneModifier);
        }
    }
}

