/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.network.protocol.game;

import com.google.common.collect.Maps;
import com.stereowalker.tiered.Reforged;
import com.stereowalker.tiered.api.PotentialAttribute;
import com.stereowalker.tiered.data.TierDataLoader;
import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ClientboundTierSyncerPacket
extends ClientboundUnionPacket {
    public int size;
    public Map<ResourceLocation, PotentialAttribute> attribute;
    public static final Map<ResourceLocation, PotentialAttribute> CACHED_ATTRIBUTES = new HashMap<ResourceLocation, PotentialAttribute>();
    public static ResourceLocation id = VersionHelper.toLoc((String)"tiered", (String)"tier_sync");

    public ClientboundTierSyncerPacket(Map<ResourceLocation, PotentialAttribute> attribute) {
        super(null);
        this.attribute = attribute;
        this.size = attribute.size();
    }

    public ClientboundTierSyncerPacket(RegistryFriendlyByteBuf buf) {
        super(buf);
        this.size = buf.readInt();
        this.attribute = Maps.newHashMap();
        for (int i = 0; i < this.size; ++i) {
            ResourceLocation id = buf.readResourceLocation();
            PotentialAttribute pa = (PotentialAttribute)TierDataLoader.GSON.fromJson(buf.readUtf(), PotentialAttribute.class);
            this.attribute.put(id, pa);
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.size);
        this.attribute.forEach((id, attribute) -> {
            buf.writeResourceLocation(id);
            buf.writeUtf(TierDataLoader.GSON.toJson(attribute));
        });
    }

    public boolean handleOnClient(LocalPlayer player) {
        CACHED_ATTRIBUTES.putAll(Reforged.TIER_DATA.getTiers());
        Reforged.TIER_DATA.clear();
        Reforged.TIER_DATA.replace(this.attribute);
        if (Reforged.TIER_DATA.getTiers().size() == 0) {
            Reforged.TIER_DATA.replace(CACHED_ATTRIBUTES);
        }
        return true;
    }

    public ResourceLocation id() {
        return id;
    }
}

