/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.stereowalker.unionlib.util.VersionHelper;
import java.lang.reflect.Type;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public class StyleSerializer
implements JsonDeserializer<Style>,
JsonSerializer<Style> {
    @Nullable
    public Style deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject == null) {
                return null;
            }
            Boolean boolean_ = StyleSerializer.getOptionalFlag(jsonObject, "bold");
            Boolean boolean2 = StyleSerializer.getOptionalFlag(jsonObject, "italic");
            Boolean boolean3 = StyleSerializer.getOptionalFlag(jsonObject, "underlined");
            Boolean boolean4 = StyleSerializer.getOptionalFlag(jsonObject, "strikethrough");
            Boolean boolean5 = StyleSerializer.getOptionalFlag(jsonObject, "obfuscated");
            TextColor textColor = StyleSerializer.getTextColor(jsonObject);
            String string = StyleSerializer.getInsertion(jsonObject);
            ResourceLocation resourceLocation = StyleSerializer.getFont(jsonObject);
            return Style.EMPTY.withColor(textColor).withBold(boolean_).withItalic(boolean2).withUnderlined(boolean3).withStrikethrough(boolean4).withObfuscated(boolean5).withInsertion(string).withFont(resourceLocation);
        }
        return null;
    }

    @Nullable
    private static ResourceLocation getFont(JsonObject json) {
        if (json.has("font")) {
            String string = GsonHelper.getAsString((JsonObject)json, (String)"font");
            try {
                return VersionHelper.toLoc((String)string);
            }
            catch (ResourceLocationException resourceLocationException) {
                throw new JsonSyntaxException("Invalid font name: " + string);
            }
        }
        return null;
    }

    @Nullable
    private static String getInsertion(JsonObject json) {
        return GsonHelper.getAsString((JsonObject)json, (String)"insertion", null);
    }

    @Nullable
    private static TextColor getTextColor(JsonObject json) {
        if (json.has("color")) {
            String string = GsonHelper.getAsString((JsonObject)json, (String)"color");
            return (TextColor)TextColor.parseColor((String)string).getOrThrow();
        }
        return null;
    }

    @Nullable
    private static Boolean getOptionalFlag(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return json.get(memberName).getAsBoolean();
        }
        return null;
    }

    @Nullable
    public JsonElement serialize(Style style, Type type, JsonSerializationContext jsonSerializationContext) {
        if (style.isEmpty()) {
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        if (style.getColor() != null) {
            jsonObject.addProperty("color", style.getColor().serialize());
        }
        return jsonObject;
    }
}

