/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.api;

import com.stereowalker.tiered.api.ItemVerifier;
import com.stereowalker.unionlib.util.GeneralUtilities;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class TierPool
implements GeneralUtilities.WeightedObject {
    private final int weight;
    private final List<ItemVerifier> verifiers;
    private final List<ItemVerifier> exclusions;
    private final List<String> tiers;

    public TierPool(String id, int weight, List<ItemVerifier> verifiers, List<ItemVerifier> exclusions, List<String> tiers) {
        this.weight = weight;
        this.verifiers = verifiers;
        this.exclusions = exclusions;
        this.tiers = tiers;
    }

    public int getWeight() {
        return this.weight;
    }

    public List<ItemVerifier> getVerifiers() {
        return this.verifiers;
    }

    public List<ItemVerifier> getExclusions() {
        return this.exclusions;
    }

    public boolean isValid(ResourceLocation id) {
        if (this.exclusions != null) {
            for (ItemVerifier exclusion : this.exclusions) {
                if (!exclusion.isValid(id)) continue;
                return false;
            }
        }
        for (ItemVerifier verifier : this.verifiers) {
            if (!verifier.isValid(id)) continue;
            return true;
        }
        return false;
    }

    public List<String> getTiers() {
        return this.tiers;
    }
}

