/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.stereowalker.tiered.api.PotentialAttribute;
import com.stereowalker.tiered.gson.AccessoryGroupDeserializer;
import com.stereowalker.tiered.gson.AccessorySlotDeserializer;
import com.stereowalker.tiered.gson.EntityAttributeModifierDeserializer;
import com.stereowalker.tiered.gson.EntityAttributeModifierSerializer;
import com.stereowalker.tiered.gson.EquipmentSlotDeserializer;
import com.stereowalker.tiered.gson.StyleSerializer;
import com.stereowalker.unionlib.resource.ReloadListener;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TierDataLoader
extends SimpleJsonResourceReloadListener
implements ReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(AttributeModifier.class, (Object)new EntityAttributeModifierDeserializer()).registerTypeAdapter(AttributeModifier.class, (Object)new EntityAttributeModifierSerializer()).registerTypeAdapter(EquipmentSlotGroup.class, (Object)new EquipmentSlotDeserializer()).registerTypeAdapter(AccessorySlot.class, (Object)new AccessorySlotDeserializer()).registerTypeAdapter(AccessorySlot.Group.class, (Object)new AccessoryGroupDeserializer()).registerTypeHierarchyAdapter(Style.class, (Object)new StyleSerializer()).create();
    private static final String PARSING_ERROR_MESSAGE = "Parsing error loading recipe {}";
    private static final String LOADED_RECIPES_MESSAGE = "Loaded {} item tiers";
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<ResourceLocation, PotentialAttribute> itemAttributes = new HashMap<ResourceLocation, PotentialAttribute>();

    public TierDataLoader() {
        super(GSON, "tiered_modifiers/tiers");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        HashMap readItemAttributes = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : loader.entrySet()) {
            ResourceLocation identifier = entry.getKey();
            try {
                PotentialAttribute itemAttribute = (PotentialAttribute)GSON.fromJson(entry.getValue(), PotentialAttribute.class);
                readItemAttributes.put(identifier, itemAttribute);
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error(PARSING_ERROR_MESSAGE, (Object)identifier, (Object)exception);
            }
        }
        this.itemAttributes = readItemAttributes;
        LOGGER.info(LOADED_RECIPES_MESSAGE, (Object)readItemAttributes.size());
    }

    public Map<ResourceLocation, PotentialAttribute> getTiers() {
        return this.itemAttributes;
    }

    public void clear() {
        this.itemAttributes.clear();
    }

    public void replace(Map<ResourceLocation, PotentialAttribute> i) {
        this.itemAttributes = i;
    }

    public ResourceLocation id() {
        return VersionHelper.toLoc((String)"tiered", (String)"data_loader");
    }
}

