/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered;

import com.google.common.base.Function;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.stereowalker.reforged.config.Config;
import com.stereowalker.tiered.ReforgedClientSegment;
import com.stereowalker.tiered.api.AttributeTemplate;
import com.stereowalker.tiered.api.ModifierUtils;
import com.stereowalker.tiered.api.PotentialAttribute;
import com.stereowalker.tiered.compat.CuriosCompat;
import com.stereowalker.tiered.data.PoolDataLoader;
import com.stereowalker.tiered.data.TierAffixer;
import com.stereowalker.tiered.data.TierDataLoader;
import com.stereowalker.tiered.network.protocol.game.ClientboundTierSyncerPacket;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.collectors.ConfigCollector;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.PacketCollector;
import com.stereowalker.unionlib.api.collectors.ReloadListeners;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabPopulator;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.core.registries.RegistryHolder;
import com.stereowalker.unionlib.core.registries.RegistryObject;
import com.stereowalker.unionlib.insert.InsertHandler;
import com.stereowalker.unionlib.insert.Inserts;
import com.stereowalker.unionlib.insert.ServerInserts;
import com.stereowalker.unionlib.insert.handler.item.ItemAttributeModifierHandler;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.PacketHolder;
import com.stereowalker.unionlib.mod.ServerSegment;
import com.stereowalker.unionlib.resource.ReloadListener;
import com.stereowalker.unionlib.util.ModHelper;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import com.stereowalker.unionlib.world.item.AccessoryItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tiered")
public class Reforged
extends MinecraftMod
implements PacketHolder {
    public static final TierDataLoader TIER_DATA = new TierDataLoader();
    public static final PoolDataLoader POOL_DATA = new PoolDataLoader();
    public static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6C"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0E"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48F"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB151"), UUID.fromString("4a88bc27-9563-4eeb-96d5-fe50917cc24f"), UUID.fromString("fee48d8c-1b51-4c46-9f4b-c58162623a7a"), UUID.fromString("3ac44786-fd3d-43db-8283-6822f7d62ea4"), UUID.fromString("2671f9f5-4ca6-4d09-b4bb-b958ac6d31e7"), UUID.fromString("31a9945e-2c8d-4894-86b6-87ba416c2e18"), UUID.fromString("63360860-88b6-4395-a561-151cd51dc91b"), UUID.fromString("7ec914a0-7b1d-4bec-ba17-d435ffa49eb4"), UUID.fromString("2dcd3ee4-cadb-4fa4-9bd4-b90b67ab77ff"), UUID.fromString("031de3a3-4368-4021-a6b1-42e8c454cfc1"), UUID.fromString("62c90c65-0f18-4d8d-afb2-340e5ff17fc5"), UUID.fromString("b8c433d5-1ae0-4ab1-9a40-000a6aab3f29"), UUID.fromString("b340cc35-ef8e-4fa6-b21f-9a60e5d4e4b3"), UUID.fromString("24cf925c-bfac-4729-9bad-57e1dc4502f7"), UUID.fromString("1732e8f1-8c5e-4f1f-aa34-b2489b4259c9")};
    public static final Map<String, UUID> CURIO_MODIFIERS = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put("back", UUID.fromString("fee48d8c-1b51-4c46-9f4b-c58162623a7a"));
        map.put("ring", UUID.fromString("fee48d8c-1b51-4c46-9f4b-c58162623a7b"));
    });
    public static final Logger LOGGER = LogManager.getLogger();
    public static Reforged instance;

    public static ResourceLocation getKey(PotentialAttribute tier) {
        return TIER_DATA.getTiers().entrySet().stream().filter(entry -> tier.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().get();
    }

    public Reforged() {
        super("tiered", () -> new ReforgedClientSegment(), () -> new ServerSegment());
        instance = this;
        UnionLib.Modulo.Default_Bow_Draw_Speed.enable();
    }

    public void setupConfigs(ConfigCollector collector) {
        collector.registerConfig(Config.class);
    }

    public static boolean hasModifier(ItemStack stack) {
        return ComponentsRegistry.MODIFIER_D.hasData(stack) && ComponentsRegistry.MODIFIER_D.getData(stack) != ModifierUtils.BLANK;
    }

    public void onModConstruct() {
        if (ModHelper.isCuriosLoaded()) {
            boolean useCurios = false;
            try {
                Class.forName("top.theillusivec4.curios.api.event.CurioAttributeModifierEvent");
                useCurios = true;
            }
            catch (Exception e) {
                System.err.println("Curios support was disabled because the modifier event was not present");
            }
            if (useCurios) {
                CuriosCompat.load();
            }
        }
    }

    public void registerServerRelaodableResources(ReloadListeners reloadListener) {
        reloadListener.listenTo((ReloadListener)TIER_DATA);
        reloadListener.listenTo((ReloadListener)POOL_DATA);
    }

    public void registerInserts(InsertCollector collector) {
        collector.addInsert((InsertHandler)Inserts.LOGGED_IN, insert -> {
            if (insert.player().m_9236_().f_46443_) {
                return;
            }
            new ClientboundTierSyncerPacket(TIER_DATA.getTiers()).send((ServerPlayer)insert.player());
        });
        collector.addInsert((InsertHandler)Inserts.MENU_OPEN, insert -> insert.menu().m_38927_().forEach(Reforged::attemptToAffixTier));
        collector.addInsert((InsertHandler)Inserts.ITEM_CRAFTED, insert -> {
            if (!Config.canCraftedReceiveTier) {
                insert.craftingStack().m_41698_("Reforged").m_128359_("Tier", ModifierUtils.getBlankAttributeIDFor(insert.craftingStack().m_41720_()).toString());
            }
        });
        collector.addInsert((InsertHandler)ServerInserts.VILLAGER_TRADES, insert -> {
            if (insert.profession() == VillagerProfession.f_35586_) {
                ((List)insert.trades().get(3)).add(new VillagerTrades.ItemsForEmeralds(ItemRegistries.ARMORERS_HAMMER, 64, 1, 1, 10));
            }
            if (insert.profession() == VillagerProfession.f_35598_) {
                ((List)insert.trades().get(3)).add(new VillagerTrades.ItemsForEmeralds(ItemRegistries.TOOLSMITHS_HAMMER, 64, 1, 1, 10));
            }
            if (insert.profession() == VillagerProfession.f_35599_) {
                ((List)insert.trades().get(4)).add(new VillagerTrades.ItemsForEmeralds(ItemRegistries.WEAPONSMITHS_HAMMER, 64, 1, 1, 10));
            }
        });
        collector.addInsert((InsertHandler)Inserts.LIVING_TICK, insert -> {
            LivingEntity patt7593$temp = insert.living();
            if (patt7593$temp instanceof TierAffixer) {
                TierAffixer affixer = (TierAffixer)patt7593$temp;
                if (affixer.InvCopy() == null) {
                    affixer.SetInvCopy(affixer.copyDefaultedList((NonNullList<ItemStack>)affixer.player().f_36093_.f_35974_));
                    affixer.player().f_36093_.f_35974_.forEach(Reforged::attemptToAffixTier);
                }
                if (!affixer.player().f_36093_.f_35974_.equals(affixer.InvCopy())) {
                    affixer.SetInvCopy(affixer.copyDefaultedList((NonNullList<ItemStack>)affixer.player().f_36093_.f_35974_));
                    affixer.player().f_36093_.f_35974_.forEach(Reforged::attemptToAffixTier);
                }
            }
        });
        collector.addInsert((InsertHandler)Inserts.ANVIL_CONTENT_CHANGE, insert -> {
            if ((Config.canReforgeBroken || !insert.left().m_41768_()) && Reforged.hasModifier(insert.left())) {
                PotentialAttribute reforgedAttribute = TIER_DATA.getTiers().get(new ResourceLocation(insert.left().m_41737_("Reforged").m_128461_("Tier")));
                if (reforgedAttribute.getReforgeItem() != null) {
                    if (RegistryHelper.getItemKey((Item)insert.right().m_41720_()).equals((Object)VersionHelper.toLoc((String)reforgedAttribute.getReforgeItem())) && insert.right().m_41776_() - insert.right().m_41773_() >= reforgedAttribute.getReforgeDurabilityCost()) {
                        ItemStack copy = insert.left().m_41777_();
                        copy.m_41749_("Reforged");
                        insert.output().set((Object)copy);
                        if (Config.enableReforgeExpCost) {
                            insert.cost().set((Object)reforgedAttribute.getReforgeExperienceCost());
                        } else {
                            insert.canTakeOnZeroExp().set((Object)true);
                            insert.cost().set((Object)0L);
                        }
                    }
                } else {
                    LOGGER.info(Reforged.getKey(reforgedAttribute) + " cannot be reforged because it either does not provide any reforging info or the info it provides is not complete");
                }
            }
        });
        collector.addInsert((InsertHandler)Inserts.ITEM_ATTRIBUTE_MODIFIER, insert -> Reforged.AppendAttributesToOriginal(insert.itemStack(), insert.slot(), Reforged.isPreferredEquipmentSlot(insert.itemStack(), insert.slot()), "AttributeModifiers", (Function<AttributeTemplate, T[]>)((Function)template -> template.getRequiredEquipmentSlot()), (Function<AttributeTemplate, T[]>)((Function)template -> template.getOptionalEquipmentSlot()), template -> template.realize((arg_0, arg_1) -> ((ItemAttributeModifierHandler.AttributeModification)insert.attributes()).add(arg_0, arg_1), insert.slot())));
    }

    public void setupRegistries(RegistryCollector collector) {
        collector.addRegistryHolder(Registries.f_256913_, ItemRegistries.class);
    }

    public void populateCreativeTabs(CreativeTabPopulator populator) {
        if (populator.isToolTab()) {
            populator.addItems(new Item[]{ItemRegistries.ARMORERS_HAMMER});
            populator.addItems(new Item[]{ItemRegistries.TOOLSMITHS_HAMMER});
            populator.addItems(new Item[]{ItemRegistries.WEAPONSMITHS_HAMMER});
        }
    }

    public static void attemptToAffixTier(ItemStack stack) {
        ResourceLocation potentialAttributeID;
        if (!Reforged.hasModifier(stack) && !stack.m_41619_() && (potentialAttributeID = ModifierUtils.getRandomAttributeIDFor(stack.m_41720_())) != ModifierUtils.BLANK) {
            ComponentsRegistry.MODIFIER_D.setData(stack, (Object)potentialAttributeID);
        }
    }

    public static ResourceLocation id(String path) {
        return VersionHelper.toLoc((String)"tiered", (String)path);
    }

    public static boolean isPreferredEquipmentSlot(ItemStack stack, EquipmentSlot slot) {
        if (stack.m_41720_() instanceof ArmorItem) {
            ArmorItem item = (ArmorItem)stack.m_41720_();
            return VersionHelper.isEquippableInSlot((ArmorItem)item, (EquipmentSlot)slot);
        }
        if (stack.m_41720_() instanceof ShieldItem) {
            return slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND;
        }
        return slot == EquipmentSlot.MAINHAND;
    }

    public static boolean isPreferredAccessorySlot(ItemStack stack, AccessorySlot slot) {
        if (stack.m_41720_() instanceof AccessoryItem) {
            AccessoryItem item = (AccessoryItem)stack.m_41720_();
            return item.getAccessorySlots().contains(slot);
        }
        return false;
    }

    public static boolean isPreferredAccessorySlot(ItemStack stack, AccessorySlot.Group group) {
        for (AccessorySlot slot : AccessorySlot.values()) {
            if (slot.getGroup() != group || Reforged.isPreferredAccessorySlot(stack, slot)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPreferredCurioSlot(ItemStack stack, String slot) {
        return stack.m_204117_(TagKey.m_203882_((ResourceKey)RegistryHelper.itemKey(), (ResourceLocation)VersionHelper.toLoc((String)"curios", (String)slot)));
    }

    public void registerPackets(PacketCollector collector) {
        collector.registerClientboundPacket(ClientboundTierSyncerPacket.id, ClientboundTierSyncerPacket.class, ClientboundTierSyncerPacket::new);
    }

    public static <T> Multimap<Attribute, AttributeModifier> AppendAttributesToOriginal(ItemStack stack, T slot, boolean isPreferredSlot, String customAttributes, Function<AttributeTemplate, T[]> requiredSlotsArray, Function<AttributeTemplate, T[]> optionalSlotsArray, Consumer<AttributeTemplate> realize) {
        LinkedListMultimap newMap = LinkedListMultimap.create();
        if (Reforged.hasModifier(stack)) {
            PotentialAttribute potentialAttribute;
            ResourceLocation tier = new ResourceLocation(stack.m_41698_("Reforged").m_128461_("Tier"));
            if (!(stack.m_41782_() && stack.m_41783_().m_128425_(customAttributes, 9) || (potentialAttribute = TIER_DATA.getTiers().get(tier)) == null)) {
                potentialAttribute.getAttributes().forEach(template -> {
                    ArrayList<Object> optionalSlots;
                    ArrayList<Object> requiredSlots;
                    if (requiredSlotsArray.apply(template) != null && (requiredSlots = new ArrayList<Object>(Arrays.asList((Object[])requiredSlotsArray.apply(template)))).contains(slot)) {
                        realize.accept((AttributeTemplate)template);
                    }
                    if (optionalSlotsArray.apply(template) != null && (optionalSlots = new ArrayList<Object>(Arrays.asList((Object[])optionalSlotsArray.apply(template)))).contains(slot) && isPreferredSlot) {
                        realize.accept((AttributeTemplate)template);
                    }
                });
            }
        }
        return newMap;
    }

    public class ComponentsRegistry {
        public static final String NBT_SUBTAG_KEY = "Reforged";
        public static final String NBT_SUBTAG_DATA_KEY = "Tier";
        public static final VersionHelper.Data<ResourceLocation> MODIFIER_D = new VersionHelper.Data(stack -> stack.m_41783_() != null && stack.m_41737_(NBT_SUBTAG_KEY) != null, stack -> VersionHelper.toLoc((String)stack.m_41698_(NBT_SUBTAG_KEY).m_128461_(NBT_SUBTAG_DATA_KEY)), (stack, dat) -> stack.m_41698_(NBT_SUBTAG_KEY).m_128359_(NBT_SUBTAG_DATA_KEY, dat.toString()), stack -> stack.m_41749_(NBT_SUBTAG_KEY));
    }

    @RegistryHolder(namespace="tiered")
    public class ItemRegistries {
        @RegistryObject(value="armorers_hammer")
        public static final Item ARMORERS_HAMMER = new Item(new Item.Properties().m_41503_(20));
        @RegistryObject(value="toolsmiths_hammer")
        public static final Item TOOLSMITHS_HAMMER = new Item(new Item.Properties().m_41503_(20));
        @RegistryObject(value="weaponsmiths_hammer")
        public static final Item WEAPONSMITHS_HAMMER = new Item(new Item.Properties().m_41503_(20));
    }
}

