/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered;

import com.google.common.base.Function;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.stereowalker.reforged.config.Config;
import com.stereowalker.tiered.ReforgedClientSegment;
import com.stereowalker.tiered.api.AttributeTemplate;
import com.stereowalker.tiered.api.ModifierUtils;
import com.stereowalker.tiered.api.PotentialAttribute;
import com.stereowalker.tiered.data.PoolDataLoader;
import com.stereowalker.tiered.data.TierAffixer;
import com.stereowalker.tiered.data.TierDataLoader;
import com.stereowalker.tiered.network.protocol.game.ClientboundTierSyncerPacket;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.collectors.ConfigCollector;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.PacketCollector;
import com.stereowalker.unionlib.api.collectors.ReloadListeners;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabPopulator;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.core.registries.RegistryHolder;
import com.stereowalker.unionlib.core.registries.RegistryObject;
import com.stereowalker.unionlib.insert.InsertHandler;
import com.stereowalker.unionlib.insert.Inserts;
import com.stereowalker.unionlib.insert.ServerInserts;
import com.stereowalker.unionlib.insert.handler.item.ItemAttributeModifierHandler;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.PacketHolder;
import com.stereowalker.unionlib.mod.ServerSegment;
import com.stereowalker.unionlib.resource.ReloadListener;
import com.stereowalker.unionlib.util.ModHelper;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import com.stereowalker.unionlib.world.item.AccessoryItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Reforged
extends MinecraftMod
implements PacketHolder {
    public static final TierDataLoader TIER_DATA = new TierDataLoader();
    public static final PoolDataLoader POOL_DATA = new PoolDataLoader();
    public static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6C"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0E"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48F"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB151"), UUID.fromString("4a88bc27-9563-4eeb-96d5-fe50917cc24f"), UUID.fromString("fee48d8c-1b51-4c46-9f4b-c58162623a7a"), UUID.fromString("3ac44786-fd3d-43db-8283-6822f7d62ea4"), UUID.fromString("2671f9f5-4ca6-4d09-b4bb-b958ac6d31e7"), UUID.fromString("31a9945e-2c8d-4894-86b6-87ba416c2e18"), UUID.fromString("63360860-88b6-4395-a561-151cd51dc91b"), UUID.fromString("7ec914a0-7b1d-4bec-ba17-d435ffa49eb4"), UUID.fromString("2dcd3ee4-cadb-4fa4-9bd4-b90b67ab77ff"), UUID.fromString("031de3a3-4368-4021-a6b1-42e8c454cfc1"), UUID.fromString("62c90c65-0f18-4d8d-afb2-340e5ff17fc5"), UUID.fromString("b8c433d5-1ae0-4ab1-9a40-000a6aab3f29"), UUID.fromString("b340cc35-ef8e-4fa6-b21f-9a60e5d4e4b3"), UUID.fromString("24cf925c-bfac-4729-9bad-57e1dc4502f7"), UUID.fromString("1732e8f1-8c5e-4f1f-aa34-b2489b4259c9")};
    public static final Map<String, UUID> CURIO_MODIFIERS = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        map.put("back", UUID.fromString("fee48d8c-1b51-4c46-9f4b-c58162623a7a"));
        map.put("ring", UUID.fromString("fee48d8c-1b51-4c46-9f4b-c58162623a7b"));
    });
    public static final Logger LOGGER = LogManager.getLogger();
    public static Reforged instance;

    public static class_2960 getKey(PotentialAttribute tier) {
        return TIER_DATA.getTiers().entrySet().stream().filter(entry -> tier.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().get();
    }

    public Reforged() {
        super("tiered", () -> new ReforgedClientSegment(), () -> new ServerSegment());
        instance = this;
        UnionLib.Modulo.Default_Bow_Draw_Speed.enable();
    }

    public void setupConfigs(ConfigCollector collector) {
        collector.registerConfig(Config.class);
    }

    public static boolean hasModifier(class_1799 stack) {
        return ComponentsRegistry.MODIFIER_D.hasData(stack) && ComponentsRegistry.MODIFIER_D.getData(stack) != ModifierUtils.BLANK;
    }

    public void onModConstruct() {
        if (ModHelper.isCuriosLoaded()) {
            boolean useCurios = false;
            try {
                Class.forName("top.theillusivec4.curios.api.event.CurioAttributeModifierEvent");
                useCurios = true;
            }
            catch (Exception e) {
                System.err.println("Curios support was disabled because the modifier event was not present");
            }
        }
    }

    public void registerServerRelaodableResources(ReloadListeners reloadListener) {
        reloadListener.listenTo((ReloadListener)TIER_DATA);
        reloadListener.listenTo((ReloadListener)POOL_DATA);
    }

    public void registerInserts(InsertCollector collector) {
        collector.addInsert((InsertHandler)Inserts.LOGGED_IN, insert -> {
            if (insert.player().method_37908().field_9236) {
                return;
            }
            new ClientboundTierSyncerPacket(TIER_DATA.getTiers()).send((class_3222)insert.player());
        });
        collector.addInsert((InsertHandler)Inserts.MENU_OPEN, insert -> insert.menu().method_7602().forEach(Reforged::attemptToAffixTier));
        collector.addInsert((InsertHandler)Inserts.ITEM_CRAFTED, insert -> {
            if (!Config.canCraftedReceiveTier) {
                insert.craftingStack().method_7911("Reforged").method_10582("Tier", ModifierUtils.getBlankAttributeIDFor(insert.craftingStack().method_7909()).toString());
            }
        });
        collector.addInsert((InsertHandler)ServerInserts.VILLAGER_TRADES, insert -> {
            if (insert.profession() == class_3852.field_17052) {
                ((List)insert.trades().get(3)).add(new class_3853.class_4165(ItemRegistries.ARMORERS_HAMMER, 64, 1, 1, 10));
            }
            if (insert.profession() == class_3852.field_17064) {
                ((List)insert.trades().get(3)).add(new class_3853.class_4165(ItemRegistries.TOOLSMITHS_HAMMER, 64, 1, 1, 10));
            }
            if (insert.profession() == class_3852.field_17065) {
                ((List)insert.trades().get(4)).add(new class_3853.class_4165(ItemRegistries.WEAPONSMITHS_HAMMER, 64, 1, 1, 10));
            }
        });
        collector.addInsert((InsertHandler)Inserts.LIVING_TICK, insert -> {
            class_1309 patt7483$temp = insert.living();
            if (patt7483$temp instanceof TierAffixer) {
                TierAffixer affixer = (TierAffixer)patt7483$temp;
                if (affixer.InvCopy() == null) {
                    affixer.SetInvCopy(affixer.copyDefaultedList((class_2371<class_1799>)affixer.player().field_7514.field_7547));
                    affixer.player().field_7514.field_7547.forEach(Reforged::attemptToAffixTier);
                }
                if (!affixer.player().field_7514.field_7547.equals(affixer.InvCopy())) {
                    affixer.SetInvCopy(affixer.copyDefaultedList((class_2371<class_1799>)affixer.player().field_7514.field_7547));
                    affixer.player().field_7514.field_7547.forEach(Reforged::attemptToAffixTier);
                }
            }
        });
        collector.addInsert((InsertHandler)Inserts.ANVIL_CONTENT_CHANGE, insert -> {
            if ((Config.canReforgeBroken || !insert.left().method_7986()) && Reforged.hasModifier(insert.left())) {
                PotentialAttribute reforgedAttribute = TIER_DATA.getTiers().get(new class_2960(insert.left().method_7941("Reforged").method_10558("Tier")));
                if (reforgedAttribute.getReforgeItem() != null) {
                    if (RegistryHelper.getItemKey((class_1792)insert.right().method_7909()).equals((Object)VersionHelper.toLoc((String)reforgedAttribute.getReforgeItem())) && insert.right().method_7936() - insert.right().method_7919() >= reforgedAttribute.getReforgeDurabilityCost()) {
                        class_1799 copy = insert.left().method_7972();
                        copy.method_7983("Reforged");
                        insert.output().set((Object)copy);
                        if (Config.enableReforgeExpCost) {
                            insert.cost().set((Object)reforgedAttribute.getReforgeExperienceCost());
                        } else {
                            insert.canTakeOnZeroExp().set((Object)true);
                            insert.cost().set((Object)0L);
                        }
                    }
                } else {
                    LOGGER.info(Reforged.getKey(reforgedAttribute) + " cannot be reforged because it either does not provide any reforging info or the info it provides is not complete");
                }
            }
        });
        collector.addInsert((InsertHandler)Inserts.ITEM_ATTRIBUTE_MODIFIER, insert -> Reforged.AppendAttributesToOriginal(insert.itemStack(), insert.slot(), Reforged.isPreferredEquipmentSlot(insert.itemStack(), insert.slot()), "AttributeModifiers", (Function<AttributeTemplate, T[]>)((Function)template -> template.getRequiredEquipmentSlot()), (Function<AttributeTemplate, T[]>)((Function)template -> template.getOptionalEquipmentSlot()), template -> template.realize((arg_0, arg_1) -> ((ItemAttributeModifierHandler.AttributeModification)insert.attributes()).add(arg_0, arg_1), insert.slot())));
    }

    public void setupRegistries(RegistryCollector collector) {
        collector.addRegistryHolder(class_7924.field_41197, ItemRegistries.class);
    }

    public void populateCreativeTabs(CreativeTabPopulator populator) {
        if (populator.isToolTab()) {
            populator.addItems(new class_1792[]{ItemRegistries.ARMORERS_HAMMER});
            populator.addItems(new class_1792[]{ItemRegistries.TOOLSMITHS_HAMMER});
            populator.addItems(new class_1792[]{ItemRegistries.WEAPONSMITHS_HAMMER});
        }
    }

    public static void attemptToAffixTier(class_1799 stack) {
        class_2960 potentialAttributeID;
        if (!Reforged.hasModifier(stack) && !stack.method_7960() && (potentialAttributeID = ModifierUtils.getRandomAttributeIDFor(stack.method_7909())) != ModifierUtils.BLANK) {
            ComponentsRegistry.MODIFIER_D.setData(stack, (Object)potentialAttributeID);
        }
    }

    public static class_2960 id(String path) {
        return VersionHelper.toLoc((String)"tiered", (String)path);
    }

    public static boolean isPreferredEquipmentSlot(class_1799 stack, class_1304 slot) {
        if (stack.method_7909() instanceof class_1738) {
            class_1738 item = (class_1738)stack.method_7909();
            return VersionHelper.isEquippableInSlot((class_1738)item, (class_1304)slot);
        }
        if (stack.method_7909() instanceof class_1819) {
            return slot == class_1304.field_6173 || slot == class_1304.field_6171;
        }
        return slot == class_1304.field_6173;
    }

    public static boolean isPreferredAccessorySlot(class_1799 stack, AccessorySlot slot) {
        if (stack.method_7909() instanceof AccessoryItem) {
            AccessoryItem item = (AccessoryItem)stack.method_7909();
            return item.getAccessorySlots().contains(slot);
        }
        return false;
    }

    public static boolean isPreferredAccessorySlot(class_1799 stack, AccessorySlot.Group group) {
        for (AccessorySlot slot : AccessorySlot.values()) {
            if (slot.getGroup() != group || Reforged.isPreferredAccessorySlot(stack, slot)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPreferredCurioSlot(class_1799 stack, String slot) {
        return stack.method_31573(class_6862.method_40092((class_5321)RegistryHelper.itemKey(), (class_2960)VersionHelper.toLoc((String)"curios", (String)slot)));
    }

    public void registerPackets(PacketCollector collector) {
        collector.registerClientboundPacket(ClientboundTierSyncerPacket.id, ClientboundTierSyncerPacket.class, ClientboundTierSyncerPacket::new);
    }

    public static <T> Multimap<class_1320, class_1322> AppendAttributesToOriginal(class_1799 stack, T slot, boolean isPreferredSlot, String customAttributes, Function<AttributeTemplate, T[]> requiredSlotsArray, Function<AttributeTemplate, T[]> optionalSlotsArray, Consumer<AttributeTemplate> realize) {
        LinkedListMultimap newMap = LinkedListMultimap.create();
        if (Reforged.hasModifier(stack)) {
            PotentialAttribute potentialAttribute;
            class_2960 tier = new class_2960(stack.method_7911("Reforged").method_10558("Tier"));
            if (!(stack.method_7985() && stack.method_7969().method_10573(customAttributes, 9) || (potentialAttribute = TIER_DATA.getTiers().get(tier)) == null)) {
                potentialAttribute.getAttributes().forEach(template -> {
                    ArrayList<Object> optionalSlots;
                    ArrayList<Object> requiredSlots;
                    if (requiredSlotsArray.apply(template) != null && (requiredSlots = new ArrayList<Object>(Arrays.asList((Object[])requiredSlotsArray.apply(template)))).contains(slot)) {
                        realize.accept((AttributeTemplate)template);
                    }
                    if (optionalSlotsArray.apply(template) != null && (optionalSlots = new ArrayList<Object>(Arrays.asList((Object[])optionalSlotsArray.apply(template)))).contains(slot) && isPreferredSlot) {
                        realize.accept((AttributeTemplate)template);
                    }
                });
            }
        }
        return newMap;
    }

    public class ComponentsRegistry {
        public static final String NBT_SUBTAG_KEY = "Reforged";
        public static final String NBT_SUBTAG_DATA_KEY = "Tier";
        public static final VersionHelper.Data<class_2960> MODIFIER_D = new VersionHelper.Data(stack -> stack.method_7969() != null && stack.method_7941(NBT_SUBTAG_KEY) != null, stack -> VersionHelper.toLoc((String)stack.method_7911(NBT_SUBTAG_KEY).method_10558(NBT_SUBTAG_DATA_KEY)), (stack, dat) -> stack.method_7911(NBT_SUBTAG_KEY).method_10582(NBT_SUBTAG_DATA_KEY, dat.toString()), stack -> stack.method_7983(NBT_SUBTAG_KEY));
    }

    @RegistryHolder(namespace="tiered")
    public class ItemRegistries {
        @RegistryObject(value="armorers_hammer")
        public static final class_1792 ARMORERS_HAMMER = new class_1792(new class_1792.class_1793().method_7895(20));
        @RegistryObject(value="toolsmiths_hammer")
        public static final class_1792 TOOLSMITHS_HAMMER = new class_1792(new class_1792.class_1793().method_7895(20));
        @RegistryObject(value="weaponsmiths_hammer")
        public static final class_1792 WEAPONSMITHS_HAMMER = new class_1792(new class_1792.class_1793().method_7895(20));
    }
}

