/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.color.item;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import reliquary.item.MobCharmItem;

public class CharmTintSources {
    private static final Cache<EntityType<?>, Integer> entityTypeMainTints = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private static final Cache<EntityType<?>, Integer> entityTypeAccentTints = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();

    private static int getTint(@Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, EntityType<?> entityType, Cache<EntityType<?>, Integer> tintCache, int tintIndex) {
        Integer tint = (Integer)tintCache.getIfPresent(entityType);
        if (tint != null) {
            return tint;
        }
        tint = CharmTintSources.getLayerRenderState(entityType, clientLevel, livingEntity).map(layer -> layer.tintLayers.length < tintIndex + 1 ? -1 : layer.tintLayers[tintIndex]).orElse(-1);
        tintCache.put(entityType, (Object)tint);
        return tint;
    }

    private static Optional<ItemStackRenderState.LayerRenderState> getLayerRenderState(EntityType<?> entityType, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity) {
        SpawnEggItem eggItem = SpawnEggItem.byId(entityType);
        if (eggItem == null) {
            return Optional.empty();
        }
        ItemStack egg = new ItemStack((ItemLike)eggItem);
        ItemStackRenderState renderState = new ItemStackRenderState();
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(renderState, egg, ItemDisplayContext.GUI, false, (Level)clientLevel, livingEntity, 0);
        if (renderState.layers.length == 0) {
            return Optional.empty();
        }
        ItemStackRenderState.LayerRenderState layer = renderState.layers[0];
        if (layer.model == null) {
            return Optional.empty();
        }
        return Optional.of(layer);
    }

    public static class Accent
    implements ItemTintSource {
        public static final Accent INSTANCE = new Accent();
        public static final MapCodec<Accent> MAP_CODEC = MapCodec.unit((Object)INSTANCE);

        public int calculate(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity) {
            return MobCharmItem.getEntityTypeFromCharm(itemStack).map(entityType -> CharmTintSources.getTint(clientLevel, livingEntity, entityType, entityTypeAccentTints, 1)).orElse(-1);
        }

        public MapCodec<? extends ItemTintSource> type() {
            return MAP_CODEC;
        }
    }

    public static class Main
    implements ItemTintSource {
        public static final Main INSTANCE = new Main();
        public static final MapCodec<Main> MAP_CODEC = MapCodec.unit((Object)INSTANCE);

        public int calculate(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity) {
            return MobCharmItem.getEntityTypeFromCharm(itemStack).map(entityType -> CharmTintSources.getTint(clientLevel, livingEntity, entityType, entityTypeMainTints, 0)).orElse(-1);
        }

        public MapCodec<? extends ItemTintSource> type() {
            return MAP_CODEC;
        }
    }
}

