/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import reliquary.Reliquary;
import reliquary.client.gui.BaseScreen;
import reliquary.common.gui.AlkahestTomeMenu;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.init.ModItems;

public class AlkahestryTomeScreen
extends BaseScreen<AlkahestTomeMenu> {
    private static final ResourceLocation BOOK_TEX = Reliquary.getRL("textures/gui/book.png");

    public AlkahestryTomeScreen(AlkahestTomeMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        this.drawTitleText(guiGraphics);
        this.drawTomeText(guiGraphics, this.font);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(RenderType::guiTextured, BOOK_TEX, (this.width - 146) / 2, (this.height - 179) / 2, 0.0f, 0.0f, 146, 179, 256, 256);
        guiGraphics.blit(RenderType::guiTextured, BOOK_TEX, (this.width - 16) / 2 + 19, (this.height - 179) / 2 + 148, 0.0f, 180.0f, 10, 10, 256, 256);
        guiGraphics.blit(RenderType::guiTextured, BOOK_TEX, (this.width - 16) / 2 - 14, (this.height - 179) / 2 + 148, 10.0f, 180.0f, 10, 10, 256, 256);
        this.drawItemStack(guiGraphics, new ItemStack((ItemLike)ModItems.ALKAHESTRY_TOME.get()), (this.width - 16) / 2, (this.height - 179) / 2 + 145);
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        AlkahestryRecipeRegistry.getDrainRecipe().ifPresent(drainRecipe -> {
            this.drawItemStack(guiGraphics, drainRecipe.getResultItem(), (this.width - 16) / 2 - 32, (this.height - 179) / 2 + 145);
            this.drawItemStack(guiGraphics, drainRecipe.getResultItem(), (this.width - 16) / 2 + 32, (this.height - 179) / 2 + 145);
        });
    }

    private void drawTomeText(GuiGraphics guigraphics, Font font) {
        String values = Language.getInstance().getOrDefault("gui.reliquary.alkahestry_tome.text");
        Objects.requireNonNull(font);
        int y = 36 + 9;
        for (String value : values.split("\n")) {
            List splitText = font.split((FormattedText)Component.literal((String)value), 100);
            for (FormattedCharSequence text : splitText) {
                int x = (146 - font.width(text)) / 2;
                guigraphics.drawString(font, text, x + 15, y, 0, false);
                Objects.requireNonNull(font);
                y += 9;
            }
        }
    }

    private void drawTitleText(GuiGraphics guiGraphics) {
        String values = "Perform basic,\nintermediate or\nadvanced Alkahestry.";
        int count = 1;
        for (String value : values.split("\n")) {
            int x = (146 - this.font.width(value)) / 2;
            Objects.requireNonNull(this.font);
            int y = 4 + count * 9;
            guiGraphics.drawString(this.font, value, x + 15, y, 0, false);
            ++count;
        }
    }
}

