/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import reliquary.Reliquary;
import reliquary.client.gui.BaseScreen;
import reliquary.common.gui.MobCharmBeltMenu;
import reliquary.init.ModItems;
import reliquary.item.MobCharmRegistry;

public class MobCharmBeltScreen
extends BaseScreen<MobCharmBeltMenu> {
    private static final ResourceLocation BELT_TEX = Reliquary.getRL("textures/gui/mob_charm_belt.png");
    private static final ResourceLocation BELT_ITEM_TEX = Reliquary.getRL("textures/item/mob_charm_belt.png");
    private static final int WIDTH = 175;
    private static final int HEIGHT = 221;
    private final ItemStack belt;

    public MobCharmBeltScreen(MobCharmBeltMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.belt = container.getBelt();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderType::guiTextured, BELT_TEX, i, j - 27, 0.0f, 0.0f, 175, 221, 256, 256);
        int centerX = i + 88;
        int centerY = j + 40;
        this.updateMobCharmSlots(guiGraphics, centerX, centerY);
        GlStateManager._enableBlend();
        guiGraphics.blit(RenderType::guiTextured, BELT_ITEM_TEX, centerX - 26, centerY - 26, 0.0f, 0.0f, 48, 48, 48, 48);
        GlStateManager._disableBlend();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
    }

    private void updateMobCharmSlots(GuiGraphics guiGraphics, int centerX, int centerY) {
        int i;
        int slots = ModItems.MOB_CHARM_BELT.get().getCharmCount(this.belt);
        slots = Math.min(slots, MobCharmRegistry.getRegisteredNames().size());
        double radius = 44.0;
        double increment = Math.PI * 2 / (double)(slots + 1);
        double start = 1.5707963267948966;
        for (i = 1; i <= slots; ++i) {
            double angle = start + (double)i * increment;
            int offsetX = (int)Math.round(Math.cos(angle) * radius);
            int offsetY = (int)Math.round(Math.sin(angle) * radius);
            int x = centerX - offsetX - 8;
            int y = centerY - offsetY - 8;
            RenderSystem.enableBlend();
            guiGraphics.blit(RenderType::guiTextured, BELT_TEX, x, y, 176.0f, 0.0f, 16, 16, 256, 256);
            RenderSystem.disableBlend();
            ((Slot)((MobCharmBeltMenu)this.menu).slots.get((int)(i - 1))).x = x - centerX + 88;
            ((Slot)((MobCharmBeltMenu)this.menu).slots.get((int)(i - 1))).y = y - centerY + 40;
        }
        ((Slot)((MobCharmBeltMenu)this.menu).slots.get((int)slots)).x = 80;
        ((Slot)((MobCharmBeltMenu)this.menu).slots.get((int)slots)).y = -12;
        for (i = slots + 1; i < MobCharmRegistry.getRegisteredNames().size() + 1; ++i) {
            ((Slot)((MobCharmBeltMenu)this.menu).slots.get((int)i)).x = -999;
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

